// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class UpdateFileSystemAssociationRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    val auditDestinationArn: String? = builder.auditDestinationArn
    /**
     * The refresh cache information for the file share or FSx file systems.
     */
    val cacheAttributes: CacheAttributes? = builder.cacheAttributes
    /**
     * The Amazon Resource Name (ARN) of the file system association that you want to update.
     */
    val fileSystemAssociationArn: String? = builder.fileSystemAssociationArn
    /**
     * The password of the user credential.
     */
    val password: String? = builder.password
    /**
     * The user name of the user credential that has permission to access the root share D$ of
     * the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin
     * user group.
     */
    val userName: String? = builder.userName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFileSystemAssociationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemAssociationRequest(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("fileSystemAssociationArn=$fileSystemAssociationArn,")
        append("password=*** Sensitive Data Redacted ***,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFileSystemAssociationRequest

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (fileSystemAssociationArn != other.fileSystemAssociationArn) return false
        if (password != other.password) return false
        if (userName != other.userName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFileSystemAssociationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFileSystemAssociationRequest
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        fun auditDestinationArn(auditDestinationArn: String): FluentBuilder
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the file system association that you want to update.
         */
        fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder
        /**
         * The password of the user credential.
         */
        fun password(password: String): FluentBuilder
        /**
         * The user name of the user credential that has permission to access the root share D$ of
         * the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin
         * user group.
         */
        fun userName(userName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        var auditDestinationArn: String?
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        var cacheAttributes: CacheAttributes?
        /**
         * The Amazon Resource Name (ARN) of the file system association that you want to update.
         */
        var fileSystemAssociationArn: String?
        /**
         * The password of the user credential.
         */
        var password: String?
        /**
         * The user name of the user credential that has permission to access the root share D$ of
         * the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin
         * user group.
         */
        var userName: String?

        fun build(): UpdateFileSystemAssociationRequest
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        fun cacheAttributes(block: CacheAttributes.DslBuilder.() -> kotlin.Unit) {
            this.cacheAttributes = CacheAttributes.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var auditDestinationArn: String? = null
        override var cacheAttributes: CacheAttributes? = null
        override var fileSystemAssociationArn: String? = null
        override var password: String? = null
        override var userName: String? = null

        constructor(x: UpdateFileSystemAssociationRequest) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.fileSystemAssociationArn = x.fileSystemAssociationArn
            this.password = x.password
            this.userName = x.userName
        }

        override fun build(): UpdateFileSystemAssociationRequest = UpdateFileSystemAssociationRequest(this)
        override fun auditDestinationArn(auditDestinationArn: String): FluentBuilder = apply { this.auditDestinationArn = auditDestinationArn }
        override fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder = apply { this.cacheAttributes = cacheAttributes }
        override fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder = apply { this.fileSystemAssociationArn = fileSystemAssociationArn }
        override fun password(password: String): FluentBuilder = apply { this.password = password }
        override fun userName(userName: String): FluentBuilder = apply { this.userName = userName }
    }
}
