// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * A JSON object containing one or more of the following fields:
 * UpdateChapCredentialsInput$InitiatorName
 * UpdateChapCredentialsInput$SecretToAuthenticateInitiator
 * UpdateChapCredentialsInput$SecretToAuthenticateTarget
 * UpdateChapCredentialsInput$TargetARN
 */
class UpdateChapCredentialsRequest private constructor(builder: BuilderImpl) {
    /**
     * The iSCSI initiator that connects to the target.
     */
    val initiatorName: String? = builder.initiatorName
    /**
     * The secret key that the initiator (for example, the Windows client) must provide to
     * participate in mutual CHAP with the target.
     * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
     */
    val secretToAuthenticateInitiator: String? = builder.secretToAuthenticateInitiator
    /**
     * The secret key that the target must provide to participate in mutual CHAP with the
     * initiator (e.g. Windows client).
     * Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
     * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
     */
    val secretToAuthenticateTarget: String? = builder.secretToAuthenticateTarget
    /**
     * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return the TargetARN for specified
     * VolumeARN.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateChapCredentialsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateChapCredentialsRequest(")
        append("initiatorName=$initiatorName,")
        append("secretToAuthenticateInitiator=*** Sensitive Data Redacted ***,")
        append("secretToAuthenticateTarget=*** Sensitive Data Redacted ***,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = initiatorName?.hashCode() ?: 0
        result = 31 * result + (secretToAuthenticateInitiator?.hashCode() ?: 0)
        result = 31 * result + (secretToAuthenticateTarget?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateChapCredentialsRequest

        if (initiatorName != other.initiatorName) return false
        if (secretToAuthenticateInitiator != other.secretToAuthenticateInitiator) return false
        if (secretToAuthenticateTarget != other.secretToAuthenticateTarget) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateChapCredentialsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateChapCredentialsRequest
        /**
         * The iSCSI initiator that connects to the target.
         */
        fun initiatorName(initiatorName: String): FluentBuilder
        /**
         * The secret key that the initiator (for example, the Windows client) must provide to
         * participate in mutual CHAP with the target.
         * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
         */
        fun secretToAuthenticateInitiator(secretToAuthenticateInitiator: String): FluentBuilder
        /**
         * The secret key that the target must provide to participate in mutual CHAP with the
         * initiator (e.g. Windows client).
         * Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
         * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
         */
        fun secretToAuthenticateTarget(secretToAuthenticateTarget: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return the TargetARN for specified
         * VolumeARN.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The iSCSI initiator that connects to the target.
         */
        var initiatorName: String?
        /**
         * The secret key that the initiator (for example, the Windows client) must provide to
         * participate in mutual CHAP with the target.
         * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
         */
        var secretToAuthenticateInitiator: String?
        /**
         * The secret key that the target must provide to participate in mutual CHAP with the
         * initiator (e.g. Windows client).
         * Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
         * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
         */
        var secretToAuthenticateTarget: String?
        /**
         * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return the TargetARN for specified
         * VolumeARN.
         */
        var targetArn: String?

        fun build(): UpdateChapCredentialsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var initiatorName: String? = null
        override var secretToAuthenticateInitiator: String? = null
        override var secretToAuthenticateTarget: String? = null
        override var targetArn: String? = null

        constructor(x: UpdateChapCredentialsRequest) : this() {
            this.initiatorName = x.initiatorName
            this.secretToAuthenticateInitiator = x.secretToAuthenticateInitiator
            this.secretToAuthenticateTarget = x.secretToAuthenticateTarget
            this.targetArn = x.targetArn
        }

        override fun build(): UpdateChapCredentialsRequest = UpdateChapCredentialsRequest(this)
        override fun initiatorName(initiatorName: String): FluentBuilder = apply { this.initiatorName = initiatorName }
        override fun secretToAuthenticateInitiator(secretToAuthenticateInitiator: String): FluentBuilder = apply { this.secretToAuthenticateInitiator = secretToAuthenticateInitiator }
        override fun secretToAuthenticateTarget(secretToAuthenticateTarget: String): FluentBuilder = apply { this.secretToAuthenticateTarget = secretToAuthenticateTarget }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
