// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a recovery point.
 */
class TapeRecoveryPointInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the virtual tape.
     */
    val tapeArn: String? = builder.tapeArn
    /**
     * The time when the point-in-time view of the virtual tape was replicated for later
     * recovery.
     * The default timestamp format of the tape recovery point time is in the ISO8601 extended
     * YYYY-MM-DD'T'HH:MM:SS'Z' format.
     */
    val tapeRecoveryPointTime: Instant? = builder.tapeRecoveryPointTime
    /**
     * The size, in bytes, of the virtual tapes to recover.
     */
    val tapeSizeInBytes: Long? = builder.tapeSizeInBytes
    /**
     * The status of the virtual tapes.
     */
    val tapeStatus: String? = builder.tapeStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TapeRecoveryPointInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TapeRecoveryPointInfo(")
        append("tapeArn=$tapeArn,")
        append("tapeRecoveryPointTime=$tapeRecoveryPointTime,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = tapeArn?.hashCode() ?: 0
        result = 31 * result + (tapeRecoveryPointTime?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TapeRecoveryPointInfo

        if (tapeArn != other.tapeArn) return false
        if (tapeRecoveryPointTime != other.tapeRecoveryPointTime) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TapeRecoveryPointInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TapeRecoveryPointInfo
        /**
         * The Amazon Resource Name (ARN) of the virtual tape.
         */
        fun tapeArn(tapeArn: String): FluentBuilder
        /**
         * The time when the point-in-time view of the virtual tape was replicated for later
         * recovery.
         * The default timestamp format of the tape recovery point time is in the ISO8601 extended
         * YYYY-MM-DD'T'HH:MM:SS'Z' format.
         */
        fun tapeRecoveryPointTime(tapeRecoveryPointTime: Instant): FluentBuilder
        /**
         * The size, in bytes, of the virtual tapes to recover.
         */
        fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder
        /**
         * The status of the virtual tapes.
         */
        fun tapeStatus(tapeStatus: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the virtual tape.
         */
        var tapeArn: String?
        /**
         * The time when the point-in-time view of the virtual tape was replicated for later
         * recovery.
         * The default timestamp format of the tape recovery point time is in the ISO8601 extended
         * YYYY-MM-DD'T'HH:MM:SS'Z' format.
         */
        var tapeRecoveryPointTime: Instant?
        /**
         * The size, in bytes, of the virtual tapes to recover.
         */
        var tapeSizeInBytes: Long?
        /**
         * The status of the virtual tapes.
         */
        var tapeStatus: String?

        fun build(): TapeRecoveryPointInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var tapeArn: String? = null
        override var tapeRecoveryPointTime: Instant? = null
        override var tapeSizeInBytes: Long? = null
        override var tapeStatus: String? = null

        constructor(x: TapeRecoveryPointInfo) : this() {
            this.tapeArn = x.tapeArn
            this.tapeRecoveryPointTime = x.tapeRecoveryPointTime
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
        }

        override fun build(): TapeRecoveryPointInfo = TapeRecoveryPointInfo(this)
        override fun tapeArn(tapeArn: String): FluentBuilder = apply { this.tapeArn = tapeArn }
        override fun tapeRecoveryPointTime(tapeRecoveryPointTime: Instant): FluentBuilder = apply { this.tapeRecoveryPointTime = tapeRecoveryPointTime }
        override fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder = apply { this.tapeSizeInBytes = tapeSizeInBytes }
        override fun tapeStatus(tapeStatus: String): FluentBuilder = apply { this.tapeStatus = tapeStatus }
    }
}
