// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a virtual tape.
 */
class TapeInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The date that the tape entered the custom tape pool with tape retention lock
     * enabled.
     */
    val poolEntryDate: Instant? = builder.poolEntryDate
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this
     * pool is archived in the S3 storage class that is associated with the pool. When you use
     * your backup application to eject the tape, the tape is archived directly into the storage
     * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    val poolId: String? = builder.poolId
    /**
     * The date that the tape became subject to tape retention lock.
     */
    val retentionStartDate: Instant? = builder.retentionStartDate
    /**
     * The Amazon Resource Name (ARN) of a virtual tape.
     */
    val tapeArn: String? = builder.tapeArn
    /**
     * The barcode that identifies a specific virtual tape.
     */
    val tapeBarcode: String? = builder.tapeBarcode
    /**
     * The size, in bytes, of a virtual tape.
     */
    val tapeSizeInBytes: Long? = builder.tapeSizeInBytes
    /**
     * The status of the tape.
     */
    val tapeStatus: String? = builder.tapeStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TapeInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TapeInfo(")
        append("gatewayArn=$gatewayArn,")
        append("poolEntryDate=$poolEntryDate,")
        append("poolId=$poolId,")
        append("retentionStartDate=$retentionStartDate,")
        append("tapeArn=$tapeArn,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (poolEntryDate?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (retentionStartDate?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TapeInfo

        if (gatewayArn != other.gatewayArn) return false
        if (poolEntryDate != other.poolEntryDate) return false
        if (poolId != other.poolId) return false
        if (retentionStartDate != other.retentionStartDate) return false
        if (tapeArn != other.tapeArn) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TapeInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TapeInfo
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The date that the tape entered the custom tape pool with tape retention lock
         * enabled.
         */
        fun poolEntryDate(poolEntryDate: Instant): FluentBuilder
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * The date that the tape became subject to tape retention lock.
         */
        fun retentionStartDate(retentionStartDate: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a virtual tape.
         */
        fun tapeArn(tapeArn: String): FluentBuilder
        /**
         * The barcode that identifies a specific virtual tape.
         */
        fun tapeBarcode(tapeBarcode: String): FluentBuilder
        /**
         * The size, in bytes, of a virtual tape.
         */
        fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder
        /**
         * The status of the tape.
         */
        fun tapeStatus(tapeStatus: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The date that the tape entered the custom tape pool with tape retention lock
         * enabled.
         */
        var poolEntryDate: Instant?
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        var poolId: String?
        /**
         * The date that the tape became subject to tape retention lock.
         */
        var retentionStartDate: Instant?
        /**
         * The Amazon Resource Name (ARN) of a virtual tape.
         */
        var tapeArn: String?
        /**
         * The barcode that identifies a specific virtual tape.
         */
        var tapeBarcode: String?
        /**
         * The size, in bytes, of a virtual tape.
         */
        var tapeSizeInBytes: Long?
        /**
         * The status of the tape.
         */
        var tapeStatus: String?

        fun build(): TapeInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null
        override var poolEntryDate: Instant? = null
        override var poolId: String? = null
        override var retentionStartDate: Instant? = null
        override var tapeArn: String? = null
        override var tapeBarcode: String? = null
        override var tapeSizeInBytes: Long? = null
        override var tapeStatus: String? = null

        constructor(x: TapeInfo) : this() {
            this.gatewayArn = x.gatewayArn
            this.poolEntryDate = x.poolEntryDate
            this.poolId = x.poolId
            this.retentionStartDate = x.retentionStartDate
            this.tapeArn = x.tapeArn
            this.tapeBarcode = x.tapeBarcode
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
        }

        override fun build(): TapeInfo = TapeInfo(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun poolEntryDate(poolEntryDate: Instant): FluentBuilder = apply { this.poolEntryDate = poolEntryDate }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun retentionStartDate(retentionStartDate: Instant): FluentBuilder = apply { this.retentionStartDate = retentionStartDate }
        override fun tapeArn(tapeArn: String): FluentBuilder = apply { this.tapeArn = tapeArn }
        override fun tapeBarcode(tapeBarcode: String): FluentBuilder = apply { this.tapeBarcode = tapeBarcode }
        override fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder = apply { this.tapeSizeInBytes = tapeSizeInBytes }
        override fun tapeStatus(tapeStatus: String): FluentBuilder = apply { this.tapeStatus = tapeStatus }
    }
}
