// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a virtual tape that is archived in the virtual tape shelf (VTS).
 */
class TapeArchive private constructor(builder: BuilderImpl) {
    /**
     * The time that the archiving of the virtual tape was completed.
     * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
     * format.
     */
    val completionTime: Instant? = builder.completionTime
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The time that the tape entered the custom tape pool.
     * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
     * format.
     */
    val poolEntryDate: Instant? = builder.poolEntryDate
    /**
     * The ID of the pool that was used to archive the tape. The tapes in this pool are
     * archived in the S3 storage class that is associated with the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    val poolId: String? = builder.poolId
    /**
     * If the archived tape is subject to tape retention lock, the date that the archived tape
     * started being retained.
     */
    val retentionStartDate: Instant? = builder.retentionStartDate
    /**
     * The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being
     * retrieved to.
     * The virtual tape is retrieved from the virtual tape shelf (VTS).
     */
    val retrievedTo: String? = builder.retrievedTo
    /**
     * The Amazon Resource Name (ARN) of an archived virtual tape.
     */
    val tapeArn: String? = builder.tapeArn
    /**
     * The barcode that identifies the archived virtual tape.
     */
    val tapeBarcode: String? = builder.tapeBarcode
    /**
     * The date the virtual tape was created.
     */
    val tapeCreatedDate: Instant? = builder.tapeCreatedDate
    /**
     * The size, in bytes, of the archived virtual tape.
     */
    val tapeSizeInBytes: Long? = builder.tapeSizeInBytes
    /**
     * The current state of the archived virtual tape.
     */
    val tapeStatus: String? = builder.tapeStatus
    /**
     * The size, in bytes, of data stored on the virtual tape.
     * This value is not available for tapes created prior to May 13, 2015.
     */
    val tapeUsedInBytes: Long? = builder.tapeUsedInBytes
    /**
     * Set to true if the archived tape is stored as write-once-read-many
     * (WORM).
     */
    val worm: Boolean = builder.worm

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TapeArchive = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TapeArchive(")
        append("completionTime=$completionTime,")
        append("kmsKey=$kmsKey,")
        append("poolEntryDate=$poolEntryDate,")
        append("poolId=$poolId,")
        append("retentionStartDate=$retentionStartDate,")
        append("retrievedTo=$retrievedTo,")
        append("tapeArn=$tapeArn,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeCreatedDate=$tapeCreatedDate,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus,")
        append("tapeUsedInBytes=$tapeUsedInBytes,")
        append("worm=$worm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (poolEntryDate?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (retentionStartDate?.hashCode() ?: 0)
        result = 31 * result + (retrievedTo?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeCreatedDate?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        result = 31 * result + (tapeUsedInBytes?.hashCode() ?: 0)
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TapeArchive

        if (completionTime != other.completionTime) return false
        if (kmsKey != other.kmsKey) return false
        if (poolEntryDate != other.poolEntryDate) return false
        if (poolId != other.poolId) return false
        if (retentionStartDate != other.retentionStartDate) return false
        if (retrievedTo != other.retrievedTo) return false
        if (tapeArn != other.tapeArn) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeCreatedDate != other.tapeCreatedDate) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false
        if (tapeUsedInBytes != other.tapeUsedInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TapeArchive = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TapeArchive
        /**
         * The time that the archiving of the virtual tape was completed.
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
         * format.
         */
        fun completionTime(completionTime: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The time that the tape entered the custom tape pool.
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
         * format.
         */
        fun poolEntryDate(poolEntryDate: Instant): FluentBuilder
        /**
         * The ID of the pool that was used to archive the tape. The tapes in this pool are
         * archived in the S3 storage class that is associated with the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * If the archived tape is subject to tape retention lock, the date that the archived tape
         * started being retained.
         */
        fun retentionStartDate(retentionStartDate: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being
         * retrieved to.
         * The virtual tape is retrieved from the virtual tape shelf (VTS).
         */
        fun retrievedTo(retrievedTo: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of an archived virtual tape.
         */
        fun tapeArn(tapeArn: String): FluentBuilder
        /**
         * The barcode that identifies the archived virtual tape.
         */
        fun tapeBarcode(tapeBarcode: String): FluentBuilder
        /**
         * The date the virtual tape was created.
         */
        fun tapeCreatedDate(tapeCreatedDate: Instant): FluentBuilder
        /**
         * The size, in bytes, of the archived virtual tape.
         */
        fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder
        /**
         * The current state of the archived virtual tape.
         */
        fun tapeStatus(tapeStatus: String): FluentBuilder
        /**
         * The size, in bytes, of data stored on the virtual tape.
         * This value is not available for tapes created prior to May 13, 2015.
         */
        fun tapeUsedInBytes(tapeUsedInBytes: Long): FluentBuilder
        /**
         * Set to true if the archived tape is stored as write-once-read-many
         * (WORM).
         */
        fun worm(worm: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time that the archiving of the virtual tape was completed.
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
         * format.
         */
        var completionTime: Instant?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The time that the tape entered the custom tape pool.
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
         * format.
         */
        var poolEntryDate: Instant?
        /**
         * The ID of the pool that was used to archive the tape. The tapes in this pool are
         * archived in the S3 storage class that is associated with the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        var poolId: String?
        /**
         * If the archived tape is subject to tape retention lock, the date that the archived tape
         * started being retained.
         */
        var retentionStartDate: Instant?
        /**
         * The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being
         * retrieved to.
         * The virtual tape is retrieved from the virtual tape shelf (VTS).
         */
        var retrievedTo: String?
        /**
         * The Amazon Resource Name (ARN) of an archived virtual tape.
         */
        var tapeArn: String?
        /**
         * The barcode that identifies the archived virtual tape.
         */
        var tapeBarcode: String?
        /**
         * The date the virtual tape was created.
         */
        var tapeCreatedDate: Instant?
        /**
         * The size, in bytes, of the archived virtual tape.
         */
        var tapeSizeInBytes: Long?
        /**
         * The current state of the archived virtual tape.
         */
        var tapeStatus: String?
        /**
         * The size, in bytes, of data stored on the virtual tape.
         * This value is not available for tapes created prior to May 13, 2015.
         */
        var tapeUsedInBytes: Long?
        /**
         * Set to true if the archived tape is stored as write-once-read-many
         * (WORM).
         */
        var worm: Boolean

        fun build(): TapeArchive
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var completionTime: Instant? = null
        override var kmsKey: String? = null
        override var poolEntryDate: Instant? = null
        override var poolId: String? = null
        override var retentionStartDate: Instant? = null
        override var retrievedTo: String? = null
        override var tapeArn: String? = null
        override var tapeBarcode: String? = null
        override var tapeCreatedDate: Instant? = null
        override var tapeSizeInBytes: Long? = null
        override var tapeStatus: String? = null
        override var tapeUsedInBytes: Long? = null
        override var worm: Boolean = false

        constructor(x: TapeArchive) : this() {
            this.completionTime = x.completionTime
            this.kmsKey = x.kmsKey
            this.poolEntryDate = x.poolEntryDate
            this.poolId = x.poolId
            this.retentionStartDate = x.retentionStartDate
            this.retrievedTo = x.retrievedTo
            this.tapeArn = x.tapeArn
            this.tapeBarcode = x.tapeBarcode
            this.tapeCreatedDate = x.tapeCreatedDate
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
            this.tapeUsedInBytes = x.tapeUsedInBytes
            this.worm = x.worm
        }

        override fun build(): TapeArchive = TapeArchive(this)
        override fun completionTime(completionTime: Instant): FluentBuilder = apply { this.completionTime = completionTime }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun poolEntryDate(poolEntryDate: Instant): FluentBuilder = apply { this.poolEntryDate = poolEntryDate }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun retentionStartDate(retentionStartDate: Instant): FluentBuilder = apply { this.retentionStartDate = retentionStartDate }
        override fun retrievedTo(retrievedTo: String): FluentBuilder = apply { this.retrievedTo = retrievedTo }
        override fun tapeArn(tapeArn: String): FluentBuilder = apply { this.tapeArn = tapeArn }
        override fun tapeBarcode(tapeBarcode: String): FluentBuilder = apply { this.tapeBarcode = tapeBarcode }
        override fun tapeCreatedDate(tapeCreatedDate: Instant): FluentBuilder = apply { this.tapeCreatedDate = tapeCreatedDate }
        override fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder = apply { this.tapeSizeInBytes = tapeSizeInBytes }
        override fun tapeStatus(tapeStatus: String): FluentBuilder = apply { this.tapeStatus = tapeStatus }
        override fun tapeUsedInBytes(tapeUsedInBytes: Long): FluentBuilder = apply { this.tapeUsedInBytes = tapeUsedInBytes }
        override fun worm(worm: Boolean): FluentBuilder = apply { this.worm = worm }
    }
}
