// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a virtual tape object.
 */
class Tape private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The date that the tape enters a custom tape pool.
     */
    val poolEntryDate: Instant? = builder.poolEntryDate
    /**
     * The ID of the pool that contains tapes that will be archived. The tapes in this pool are
     * archived in the S3 storage class that is associated with the pool. When you use your backup
     * application to eject the tape, the tape is archived directly into the storage class (S3
     * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    val poolId: String? = builder.poolId
    /**
     * For archiving virtual tapes, indicates how much data remains to be uploaded before
     * archiving is complete.
     * Range: 0 (not started) to 100 (complete).
     */
    val progress: Double? = builder.progress
    /**
     * The date that the tape is first archived with tape retention lock enabled.
     */
    val retentionStartDate: Instant? = builder.retentionStartDate
    /**
     * The Amazon Resource Name (ARN) of the virtual tape.
     */
    val tapeArn: String? = builder.tapeArn
    /**
     * The barcode that identifies a specific virtual tape.
     */
    val tapeBarcode: String? = builder.tapeBarcode
    /**
     * The date the virtual tape was created.
     */
    val tapeCreatedDate: Instant? = builder.tapeCreatedDate
    /**
     * The size, in bytes, of the virtual tape capacity.
     */
    val tapeSizeInBytes: Long? = builder.tapeSizeInBytes
    /**
     * The current state of the virtual tape.
     */
    val tapeStatus: String? = builder.tapeStatus
    /**
     * The size, in bytes, of data stored on the virtual tape.
     * This value is not available for tapes created prior to May 13, 2015.
     */
    val tapeUsedInBytes: Long? = builder.tapeUsedInBytes
    /**
     * The virtual tape library (VTL) device that the virtual tape is associated with.
     */
    val vtlDevice: String? = builder.vtlDevice
    /**
     * If the tape is archived as write-once-read-many (WORM), this value is
     * true.
     */
    val worm: Boolean = builder.worm

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Tape = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Tape(")
        append("kmsKey=$kmsKey,")
        append("poolEntryDate=$poolEntryDate,")
        append("poolId=$poolId,")
        append("progress=$progress,")
        append("retentionStartDate=$retentionStartDate,")
        append("tapeArn=$tapeArn,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeCreatedDate=$tapeCreatedDate,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus,")
        append("tapeUsedInBytes=$tapeUsedInBytes,")
        append("vtlDevice=$vtlDevice,")
        append("worm=$worm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKey?.hashCode() ?: 0
        result = 31 * result + (poolEntryDate?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (retentionStartDate?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeCreatedDate?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        result = 31 * result + (tapeUsedInBytes?.hashCode() ?: 0)
        result = 31 * result + (vtlDevice?.hashCode() ?: 0)
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Tape

        if (kmsKey != other.kmsKey) return false
        if (poolEntryDate != other.poolEntryDate) return false
        if (poolId != other.poolId) return false
        if (progress != other.progress) return false
        if (retentionStartDate != other.retentionStartDate) return false
        if (tapeArn != other.tapeArn) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeCreatedDate != other.tapeCreatedDate) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false
        if (tapeUsedInBytes != other.tapeUsedInBytes) return false
        if (vtlDevice != other.vtlDevice) return false
        if (worm != other.worm) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Tape = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Tape
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The date that the tape enters a custom tape pool.
         */
        fun poolEntryDate(poolEntryDate: Instant): FluentBuilder
        /**
         * The ID of the pool that contains tapes that will be archived. The tapes in this pool are
         * archived in the S3 storage class that is associated with the pool. When you use your backup
         * application to eject the tape, the tape is archived directly into the storage class (S3
         * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * For archiving virtual tapes, indicates how much data remains to be uploaded before
         * archiving is complete.
         * Range: 0 (not started) to 100 (complete).
         */
        fun progress(progress: Double): FluentBuilder
        /**
         * The date that the tape is first archived with tape retention lock enabled.
         */
        fun retentionStartDate(retentionStartDate: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the virtual tape.
         */
        fun tapeArn(tapeArn: String): FluentBuilder
        /**
         * The barcode that identifies a specific virtual tape.
         */
        fun tapeBarcode(tapeBarcode: String): FluentBuilder
        /**
         * The date the virtual tape was created.
         */
        fun tapeCreatedDate(tapeCreatedDate: Instant): FluentBuilder
        /**
         * The size, in bytes, of the virtual tape capacity.
         */
        fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder
        /**
         * The current state of the virtual tape.
         */
        fun tapeStatus(tapeStatus: String): FluentBuilder
        /**
         * The size, in bytes, of data stored on the virtual tape.
         * This value is not available for tapes created prior to May 13, 2015.
         */
        fun tapeUsedInBytes(tapeUsedInBytes: Long): FluentBuilder
        /**
         * The virtual tape library (VTL) device that the virtual tape is associated with.
         */
        fun vtlDevice(vtlDevice: String): FluentBuilder
        /**
         * If the tape is archived as write-once-read-many (WORM), this value is
         * true.
         */
        fun worm(worm: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The date that the tape enters a custom tape pool.
         */
        var poolEntryDate: Instant?
        /**
         * The ID of the pool that contains tapes that will be archived. The tapes in this pool are
         * archived in the S3 storage class that is associated with the pool. When you use your backup
         * application to eject the tape, the tape is archived directly into the storage class (S3
         * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        var poolId: String?
        /**
         * For archiving virtual tapes, indicates how much data remains to be uploaded before
         * archiving is complete.
         * Range: 0 (not started) to 100 (complete).
         */
        var progress: Double?
        /**
         * The date that the tape is first archived with tape retention lock enabled.
         */
        var retentionStartDate: Instant?
        /**
         * The Amazon Resource Name (ARN) of the virtual tape.
         */
        var tapeArn: String?
        /**
         * The barcode that identifies a specific virtual tape.
         */
        var tapeBarcode: String?
        /**
         * The date the virtual tape was created.
         */
        var tapeCreatedDate: Instant?
        /**
         * The size, in bytes, of the virtual tape capacity.
         */
        var tapeSizeInBytes: Long?
        /**
         * The current state of the virtual tape.
         */
        var tapeStatus: String?
        /**
         * The size, in bytes, of data stored on the virtual tape.
         * This value is not available for tapes created prior to May 13, 2015.
         */
        var tapeUsedInBytes: Long?
        /**
         * The virtual tape library (VTL) device that the virtual tape is associated with.
         */
        var vtlDevice: String?
        /**
         * If the tape is archived as write-once-read-many (WORM), this value is
         * true.
         */
        var worm: Boolean

        fun build(): Tape
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var kmsKey: String? = null
        override var poolEntryDate: Instant? = null
        override var poolId: String? = null
        override var progress: Double? = null
        override var retentionStartDate: Instant? = null
        override var tapeArn: String? = null
        override var tapeBarcode: String? = null
        override var tapeCreatedDate: Instant? = null
        override var tapeSizeInBytes: Long? = null
        override var tapeStatus: String? = null
        override var tapeUsedInBytes: Long? = null
        override var vtlDevice: String? = null
        override var worm: Boolean = false

        constructor(x: Tape) : this() {
            this.kmsKey = x.kmsKey
            this.poolEntryDate = x.poolEntryDate
            this.poolId = x.poolId
            this.progress = x.progress
            this.retentionStartDate = x.retentionStartDate
            this.tapeArn = x.tapeArn
            this.tapeBarcode = x.tapeBarcode
            this.tapeCreatedDate = x.tapeCreatedDate
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
            this.tapeUsedInBytes = x.tapeUsedInBytes
            this.vtlDevice = x.vtlDevice
            this.worm = x.worm
        }

        override fun build(): Tape = Tape(this)
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun poolEntryDate(poolEntryDate: Instant): FluentBuilder = apply { this.poolEntryDate = poolEntryDate }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun progress(progress: Double): FluentBuilder = apply { this.progress = progress }
        override fun retentionStartDate(retentionStartDate: Instant): FluentBuilder = apply { this.retentionStartDate = retentionStartDate }
        override fun tapeArn(tapeArn: String): FluentBuilder = apply { this.tapeArn = tapeArn }
        override fun tapeBarcode(tapeBarcode: String): FluentBuilder = apply { this.tapeBarcode = tapeBarcode }
        override fun tapeCreatedDate(tapeCreatedDate: Instant): FluentBuilder = apply { this.tapeCreatedDate = tapeCreatedDate }
        override fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder = apply { this.tapeSizeInBytes = tapeSizeInBytes }
        override fun tapeStatus(tapeStatus: String): FluentBuilder = apply { this.tapeStatus = tapeStatus }
        override fun tapeUsedInBytes(tapeUsedInBytes: Long): FluentBuilder = apply { this.tapeUsedInBytes = tapeUsedInBytes }
        override fun vtlDevice(vtlDevice: String): FluentBuilder = apply { this.vtlDevice = vtlDevice }
        override fun worm(worm: Boolean): FluentBuilder = apply { this.worm = worm }
    }
}
