// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an iSCSI stored volume.
 */
class StorediScsiVolume private constructor(builder: BuilderImpl) {
    /**
     * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
     * timestamp.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * Indicates if when the stored volume was created, existing data on the underlying local
     * disk was preserved.
     * Valid Values: true | false
     */
    val preservedExistingData: Boolean = builder.preservedExistingData
    /**
     * If the stored volume was created from a snapshot, this field contains the snapshot ID
     * used, e.g. snap-78e22663. Otherwise, this field is not included.
     */
    val sourceSnapshotId: String? = builder.sourceSnapshotId
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a
     * suffix for the target ARN. For example, specifying TargetName as
     * myvolume results in the target ARN of
     * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
     * The target name must be unique across all volumes on a gateway.
     * If you don't specify a value, Storage Gateway uses the value that was previously
     * used for this volume as the new target name.
     */
    val targetName: String? = builder.targetName
    /**
     * The Amazon Resource Name (ARN) of the storage volume.
     */
    val volumeArn: String? = builder.volumeArn
    /**
     * A value that indicates whether a storage volume is attached to, detached from, or is in
     * the process of detaching from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
     * your volumes to a different gateway.
     */
    val volumeAttachmentStatus: String? = builder.volumeAttachmentStatus
    /**
     * The ID of the local disk that was specified in the CreateStorediSCSIVolume operation.
     */
    val volumeDiskId: String? = builder.volumeDiskId
    /**
     * The unique identifier of the volume, e.g., vol-AE4B946D.
     */
    val volumeId: String? = builder.volumeId
    /**
     * Represents the percentage complete if the volume is restoring or bootstrapping that
     * represents the percent of data transferred. This field does not appear in the response if
     * the stored volume is not restoring or bootstrapping.
     */
    val volumeProgress: Double? = builder.volumeProgress
    /**
     * The size of the volume in bytes.
     */
    val volumeSizeInBytes: Long = builder.volumeSizeInBytes
    /**
     * One of the VolumeStatus values that indicates the state of the storage volume.
     */
    val volumeStatus: String? = builder.volumeStatus
    /**
     * One of the VolumeType enumeration values describing the type of the volume.
     */
    val volumeType: String? = builder.volumeType
    /**
     * The size of the data stored on the volume in bytes. This value is calculated based on
     * the number of blocks that are touched, instead of the actual amount of data written. This
     * value can be useful for sequential write patterns but less accurate for random write
     * patterns. VolumeUsedInBytes is different from the compressed size of the
     * volume, which is the value that is used to calculate your bill.
     * This value is not available for volumes created prior to May 13, 2015, until you
     * store data on the volume.
     */
    val volumeUsedInBytes: Long? = builder.volumeUsedInBytes
    /**
     * An VolumeiSCSIAttributes object that represents a collection of iSCSI
     * attributes for one stored volume.
     */
    val volumeiScsiAttributes: VolumeiScsiAttributes? = builder.volumeiScsiAttributes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StorediScsiVolume = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StorediScsiVolume(")
        append("createdDate=$createdDate,")
        append("kmsKey=$kmsKey,")
        append("preservedExistingData=$preservedExistingData,")
        append("sourceSnapshotId=$sourceSnapshotId,")
        append("targetName=$targetName,")
        append("volumeArn=$volumeArn,")
        append("volumeAttachmentStatus=$volumeAttachmentStatus,")
        append("volumeDiskId=$volumeDiskId,")
        append("volumeId=$volumeId,")
        append("volumeProgress=$volumeProgress,")
        append("volumeSizeInBytes=$volumeSizeInBytes,")
        append("volumeStatus=$volumeStatus,")
        append("volumeType=$volumeType,")
        append("volumeUsedInBytes=$volumeUsedInBytes,")
        append("volumeiScsiAttributes=$volumeiScsiAttributes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (preservedExistingData.hashCode())
        result = 31 * result + (sourceSnapshotId?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeAttachmentStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeDiskId?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeProgress?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        result = 31 * result + (volumeStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        result = 31 * result + (volumeUsedInBytes?.hashCode() ?: 0)
        result = 31 * result + (volumeiScsiAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StorediScsiVolume

        if (createdDate != other.createdDate) return false
        if (kmsKey != other.kmsKey) return false
        if (preservedExistingData != other.preservedExistingData) return false
        if (sourceSnapshotId != other.sourceSnapshotId) return false
        if (targetName != other.targetName) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeAttachmentStatus != other.volumeAttachmentStatus) return false
        if (volumeDiskId != other.volumeDiskId) return false
        if (volumeId != other.volumeId) return false
        if (volumeProgress != other.volumeProgress) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false
        if (volumeStatus != other.volumeStatus) return false
        if (volumeType != other.volumeType) return false
        if (volumeUsedInBytes != other.volumeUsedInBytes) return false
        if (volumeiScsiAttributes != other.volumeiScsiAttributes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StorediScsiVolume = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StorediScsiVolume
        /**
         * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
         * timestamp.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * Indicates if when the stored volume was created, existing data on the underlying local
         * disk was preserved.
         * Valid Values: true | false
         */
        fun preservedExistingData(preservedExistingData: Boolean): FluentBuilder
        /**
         * If the stored volume was created from a snapshot, this field contains the snapshot ID
         * used, e.g. snap-78e22663. Otherwise, this field is not included.
         */
        fun sourceSnapshotId(sourceSnapshotId: String): FluentBuilder
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        fun targetName(targetName: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the storage volume.
         */
        fun volumeArn(volumeArn: String): FluentBuilder
        /**
         * A value that indicates whether a storage volume is attached to, detached from, or is in
         * the process of detaching from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
         * your volumes to a different gateway.
         */
        fun volumeAttachmentStatus(volumeAttachmentStatus: String): FluentBuilder
        /**
         * The ID of the local disk that was specified in the CreateStorediSCSIVolume operation.
         */
        fun volumeDiskId(volumeDiskId: String): FluentBuilder
        /**
         * The unique identifier of the volume, e.g., vol-AE4B946D.
         */
        fun volumeId(volumeId: String): FluentBuilder
        /**
         * Represents the percentage complete if the volume is restoring or bootstrapping that
         * represents the percent of data transferred. This field does not appear in the response if
         * the stored volume is not restoring or bootstrapping.
         */
        fun volumeProgress(volumeProgress: Double): FluentBuilder
        /**
         * The size of the volume in bytes.
         */
        fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder
        /**
         * One of the VolumeStatus values that indicates the state of the storage volume.
         */
        fun volumeStatus(volumeStatus: String): FluentBuilder
        /**
         * One of the VolumeType enumeration values describing the type of the volume.
         */
        fun volumeType(volumeType: String): FluentBuilder
        /**
         * The size of the data stored on the volume in bytes. This value is calculated based on
         * the number of blocks that are touched, instead of the actual amount of data written. This
         * value can be useful for sequential write patterns but less accurate for random write
         * patterns. VolumeUsedInBytes is different from the compressed size of the
         * volume, which is the value that is used to calculate your bill.
         * This value is not available for volumes created prior to May 13, 2015, until you
         * store data on the volume.
         */
        fun volumeUsedInBytes(volumeUsedInBytes: Long): FluentBuilder
        /**
         * An VolumeiSCSIAttributes object that represents a collection of iSCSI
         * attributes for one stored volume.
         */
        fun volumeiScsiAttributes(volumeiScsiAttributes: VolumeiScsiAttributes): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this
         * timestamp.
         */
        var createdDate: Instant?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * Indicates if when the stored volume was created, existing data on the underlying local
         * disk was preserved.
         * Valid Values: true | false
         */
        var preservedExistingData: Boolean
        /**
         * If the stored volume was created from a snapshot, this field contains the snapshot ID
         * used, e.g. snap-78e22663. Otherwise, this field is not included.
         */
        var sourceSnapshotId: String?
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        var targetName: String?
        /**
         * The Amazon Resource Name (ARN) of the storage volume.
         */
        var volumeArn: String?
        /**
         * A value that indicates whether a storage volume is attached to, detached from, or is in
         * the process of detaching from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving
         * your volumes to a different gateway.
         */
        var volumeAttachmentStatus: String?
        /**
         * The ID of the local disk that was specified in the CreateStorediSCSIVolume operation.
         */
        var volumeDiskId: String?
        /**
         * The unique identifier of the volume, e.g., vol-AE4B946D.
         */
        var volumeId: String?
        /**
         * Represents the percentage complete if the volume is restoring or bootstrapping that
         * represents the percent of data transferred. This field does not appear in the response if
         * the stored volume is not restoring or bootstrapping.
         */
        var volumeProgress: Double?
        /**
         * The size of the volume in bytes.
         */
        var volumeSizeInBytes: Long
        /**
         * One of the VolumeStatus values that indicates the state of the storage volume.
         */
        var volumeStatus: String?
        /**
         * One of the VolumeType enumeration values describing the type of the volume.
         */
        var volumeType: String?
        /**
         * The size of the data stored on the volume in bytes. This value is calculated based on
         * the number of blocks that are touched, instead of the actual amount of data written. This
         * value can be useful for sequential write patterns but less accurate for random write
         * patterns. VolumeUsedInBytes is different from the compressed size of the
         * volume, which is the value that is used to calculate your bill.
         * This value is not available for volumes created prior to May 13, 2015, until you
         * store data on the volume.
         */
        var volumeUsedInBytes: Long?
        /**
         * An VolumeiSCSIAttributes object that represents a collection of iSCSI
         * attributes for one stored volume.
         */
        var volumeiScsiAttributes: VolumeiScsiAttributes?

        fun build(): StorediScsiVolume
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.VolumeiScsiAttributes] inside the given [block]
         */
        fun volumeiScsiAttributes(block: VolumeiScsiAttributes.DslBuilder.() -> kotlin.Unit) {
            this.volumeiScsiAttributes = VolumeiScsiAttributes.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdDate: Instant? = null
        override var kmsKey: String? = null
        override var preservedExistingData: Boolean = false
        override var sourceSnapshotId: String? = null
        override var targetName: String? = null
        override var volumeArn: String? = null
        override var volumeAttachmentStatus: String? = null
        override var volumeDiskId: String? = null
        override var volumeId: String? = null
        override var volumeProgress: Double? = null
        override var volumeSizeInBytes: Long = 0L
        override var volumeStatus: String? = null
        override var volumeType: String? = null
        override var volumeUsedInBytes: Long? = null
        override var volumeiScsiAttributes: VolumeiScsiAttributes? = null

        constructor(x: StorediScsiVolume) : this() {
            this.createdDate = x.createdDate
            this.kmsKey = x.kmsKey
            this.preservedExistingData = x.preservedExistingData
            this.sourceSnapshotId = x.sourceSnapshotId
            this.targetName = x.targetName
            this.volumeArn = x.volumeArn
            this.volumeAttachmentStatus = x.volumeAttachmentStatus
            this.volumeDiskId = x.volumeDiskId
            this.volumeId = x.volumeId
            this.volumeProgress = x.volumeProgress
            this.volumeSizeInBytes = x.volumeSizeInBytes
            this.volumeStatus = x.volumeStatus
            this.volumeType = x.volumeType
            this.volumeUsedInBytes = x.volumeUsedInBytes
            this.volumeiScsiAttributes = x.volumeiScsiAttributes
        }

        override fun build(): StorediScsiVolume = StorediScsiVolume(this)
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun preservedExistingData(preservedExistingData: Boolean): FluentBuilder = apply { this.preservedExistingData = preservedExistingData }
        override fun sourceSnapshotId(sourceSnapshotId: String): FluentBuilder = apply { this.sourceSnapshotId = sourceSnapshotId }
        override fun targetName(targetName: String): FluentBuilder = apply { this.targetName = targetName }
        override fun volumeArn(volumeArn: String): FluentBuilder = apply { this.volumeArn = volumeArn }
        override fun volumeAttachmentStatus(volumeAttachmentStatus: String): FluentBuilder = apply { this.volumeAttachmentStatus = volumeAttachmentStatus }
        override fun volumeDiskId(volumeDiskId: String): FluentBuilder = apply { this.volumeDiskId = volumeDiskId }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
        override fun volumeProgress(volumeProgress: Double): FluentBuilder = apply { this.volumeProgress = volumeProgress }
        override fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder = apply { this.volumeSizeInBytes = volumeSizeInBytes }
        override fun volumeStatus(volumeStatus: String): FluentBuilder = apply { this.volumeStatus = volumeStatus }
        override fun volumeType(volumeType: String): FluentBuilder = apply { this.volumeType = volumeType }
        override fun volumeUsedInBytes(volumeUsedInBytes: Long): FluentBuilder = apply { this.volumeUsedInBytes = volumeUsedInBytes }
        override fun volumeiScsiAttributes(volumeiScsiAttributes: VolumeiScsiAttributes): FluentBuilder = apply { this.volumeiScsiAttributes = volumeiScsiAttributes }
    }
}
