// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * The Windows file permissions and ownership information assigned, by default, to native
 * S3 objects when S3 File Gateway discovers them in S3 buckets. This operation is only supported
 * for S3 File Gateways.
 */
class SmbFileShareInfo private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether AccessBasedEnumeration is enabled.
     */
    val accessBasedEnumeration: Boolean? = builder.accessBasedEnumeration
    /**
     * A list of users or groups in the Active Directory that have administrator rights to the
     * file share. A group must be prefixed with the @ character. Acceptable formats include:
     * DOMAIN\User1, user1, @group1, and
     * @DOMAIN\group1. Can only be set if Authentication is set to
     * ActiveDirectory.
     */
    val adminUserList: List<String>? = builder.adminUserList
    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    val auditDestinationArn: String? = builder.auditDestinationArn
    /**
     * The authentication method of the file share. The default is
     * ActiveDirectory.
     * Valid Values: ActiveDirectory | GuestAccess
     */
    val authentication: String? = builder.authentication
    /**
     * Specifies the Region of the S3 bucket where the SMB file share stores files.
     * This parameter is required for SMB file shares that connect to Amazon S3
     * through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    val bucketRegion: String? = builder.bucketRegion
    /**
     * Refresh cache information for the file share.
     */
    val cacheAttributes: CacheAttributes? = builder.cacheAttributes
    /**
     * The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
     * client determines the case sensitivity. For CaseSensitive, the gateway
     * determines the case sensitivity. The default value is ClientSpecified.
     */
    val caseSensitivity: CaseSensitivity? = builder.caseSensitivity
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
     * The default value is S3_INTELLIGENT_TIERING. Optional.
     * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
     * S3_STANDARD_IA | S3_ONEZONE_IA
     */
    val defaultStorageClass: String? = builder.defaultStorageClass
    /**
     * The Amazon Resource Name (ARN) of the file share.
     */
    val fileShareArn: String? = builder.fileShareArn
    /**
     * The ID of the file share.
     */
    val fileShareId: String? = builder.fileShareId
    /**
     * The name of the file share. Optional.
     * FileShareName must be set if an S3 prefix name is set in
     * LocationARN.
     */
    val fileShareName: String? = builder.fileShareName
    /**
     * The status of the file share.
     * Valid Values: CREATING | UPDATING | AVAILABLE |
     * DELETING
     */
    val fileShareStatus: String? = builder.fileShareStatus
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file
     * extensions. Set this value to true to enable MIME type guessing, otherwise set
     * to false. The default value is true.
     * Valid Values: true | false
     */
    val guessMimeTypeEnabled: Boolean? = builder.guessMimeTypeEnabled
    /**
     * A list of users or groups in the Active Directory that are not allowed to access the
     * file share. A group must be prefixed with the @ character. Acceptable formats include:
     * DOMAIN\User1, user1, @group1, and
     * @DOMAIN\group1. Can only be set if Authentication is set to
     * ActiveDirectory.
     */
    val invalidUserList: List<String>? = builder.invalidUserList
    /**
     * Set to true to use Amazon S3 server-side encryption with your own KMS
     * key, or false to use a key managed by Amazon S3. Optional.
     * Valid Values: true | false
     */
    val kmsEncrypted: Boolean = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The ARN of the backend storage used for storing file data. A prefix name can be added to
     * the S3 bucket name. It must end with a "/".
     */
    val locationArn: String? = builder.locationArn
    /**
     * The notification policy of the file share. SettlingTimeInSeconds controls
     * the number of seconds to wait after the last point in time a client wrote to a file before
     * generating an ObjectUploaded notification. Because clients can make many small
     * writes to files, it's best to set this parameter for as long as possible to avoid
     * generating multiple notifications for the same file in a small time period.
     * SettlingTimeInSeconds has no effect on the timing of the object
     * uploading to Amazon S3, only the timing of the notification.
     * The following example sets NotificationPolicy on with
     * SettlingTimeInSeconds set to 60.
     * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
     * The following example sets NotificationPolicy off.
     * {}
     */
    val notificationPolicy: String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket
     * that an S3 File Gateway puts objects into. The default value is private.
     */
    val objectAcl: ObjectAcl? = builder.objectAcl
    /**
     * Specifies whether opportunistic locking is enabled for the SMB file share.
     * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve
     * access to files with the same name in different case.
     * Valid Values: true | false
     */
    val oplocksEnabled: Boolean? = builder.oplocksEnabled
    /**
     * The file share path used by the SMB client to identify the mount point.
     */
    val path: String? = builder.path
    /**
     * A value that sets the write status of a file share. Set this value to true
     * to set the write status to read-only, otherwise set to false.
     * Valid Values: true | false
     */
    val readOnly: Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data
     * download from the S3 bucket. If this value is set to true, the requester pays
     * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
     * the cost of storing data.
     * RequesterPays is a configuration for the S3 bucket that backs the file
     * share, so make sure that the configuration on the file share is the same as the S3
     * bucket configuration.
     * Valid Values: true | false
     */
    val requesterPays: Boolean? = builder.requesterPays
    /**
     * The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
     * storage.
     */
    val role: String? = builder.role
    /**
     * If this value is set to true, it indicates that access control list (ACL)
     * is enabled on the SMB file share. If it is set to false, it indicates that
     * file and directory permissions are mapped to the POSIX permission.
     * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
     * control access to an SMB file share in the Storage Gateway User
     * Guide.
     */
    val smbaclEnabled: Boolean? = builder.smbaclEnabled
    /**
     * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
     * name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
     * view all tags using the ListTagsForResource API operation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A list of users or groups in the Active Directory that are allowed to access the file
     * share. A group must be prefixed with the @ character. Acceptable formats include:
     * DOMAIN\User1, user1, @group1, and
     * @DOMAIN\group1. Can only be set if Authentication is set to
     * ActiveDirectory.
     */
    val validUserList: List<String>? = builder.validUserList
    /**
     * Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.
     * This parameter is required for SMB file shares that connect to Amazon S3
     * through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    val vpcEndpointDnsName: String? = builder.vpcEndpointDnsName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SmbFileShareInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SmbFileShareInfo(")
        append("accessBasedEnumeration=$accessBasedEnumeration,")
        append("adminUserList=$adminUserList,")
        append("auditDestinationArn=$auditDestinationArn,")
        append("authentication=$authentication,")
        append("bucketRegion=$bucketRegion,")
        append("cacheAttributes=$cacheAttributes,")
        append("caseSensitivity=$caseSensitivity,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("fileShareArn=$fileShareArn,")
        append("fileShareId=$fileShareId,")
        append("fileShareName=$fileShareName,")
        append("fileShareStatus=$fileShareStatus,")
        append("gatewayArn=$gatewayArn,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("invalidUserList=$invalidUserList,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("locationArn=$locationArn,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("oplocksEnabled=$oplocksEnabled,")
        append("path=$path,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("role=$role,")
        append("smbaclEnabled=$smbaclEnabled,")
        append("tags=$tags,")
        append("validUserList=$validUserList,")
        append("vpcEndpointDnsName=$vpcEndpointDnsName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessBasedEnumeration?.hashCode() ?: 0
        result = 31 * result + (adminUserList?.hashCode() ?: 0)
        result = 31 * result + (auditDestinationArn?.hashCode() ?: 0)
        result = 31 * result + (authentication?.hashCode() ?: 0)
        result = 31 * result + (bucketRegion?.hashCode() ?: 0)
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (caseSensitivity?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (fileShareId?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (fileShareStatus?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (invalidUserList?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted.hashCode())
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (oplocksEnabled?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (smbaclEnabled?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (validUserList?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointDnsName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SmbFileShareInfo

        if (accessBasedEnumeration != other.accessBasedEnumeration) return false
        if (adminUserList != other.adminUserList) return false
        if (auditDestinationArn != other.auditDestinationArn) return false
        if (authentication != other.authentication) return false
        if (bucketRegion != other.bucketRegion) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (caseSensitivity != other.caseSensitivity) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (fileShareArn != other.fileShareArn) return false
        if (fileShareId != other.fileShareId) return false
        if (fileShareName != other.fileShareName) return false
        if (fileShareStatus != other.fileShareStatus) return false
        if (gatewayArn != other.gatewayArn) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (invalidUserList != other.invalidUserList) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (locationArn != other.locationArn) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (oplocksEnabled != other.oplocksEnabled) return false
        if (path != other.path) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (role != other.role) return false
        if (smbaclEnabled != other.smbaclEnabled) return false
        if (tags != other.tags) return false
        if (validUserList != other.validUserList) return false
        if (vpcEndpointDnsName != other.vpcEndpointDnsName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SmbFileShareInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SmbFileShareInfo
        /**
         * Indicates whether AccessBasedEnumeration is enabled.
         */
        fun accessBasedEnumeration(accessBasedEnumeration: Boolean): FluentBuilder
        /**
         * A list of users or groups in the Active Directory that have administrator rights to the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        fun adminUserList(adminUserList: List<String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        fun auditDestinationArn(auditDestinationArn: String): FluentBuilder
        /**
         * The authentication method of the file share. The default is
         * ActiveDirectory.
         * Valid Values: ActiveDirectory | GuestAccess
         */
        fun authentication(authentication: String): FluentBuilder
        /**
         * Specifies the Region of the S3 bucket where the SMB file share stores files.
         * This parameter is required for SMB file shares that connect to Amazon S3
         * through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        fun bucketRegion(bucketRegion: String): FluentBuilder
        /**
         * Refresh cache information for the file share.
         */
        fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder
        /**
         * The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
         * client determines the case sensitivity. For CaseSensitive, the gateway
         * determines the case sensitivity. The default value is ClientSpecified.
         */
        fun caseSensitivity(caseSensitivity: CaseSensitivity): FluentBuilder
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
         * The default value is S3_INTELLIGENT_TIERING. Optional.
         * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
         * S3_STANDARD_IA | S3_ONEZONE_IA
         */
        fun defaultStorageClass(defaultStorageClass: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        fun fileShareArn(fileShareArn: String): FluentBuilder
        /**
         * The ID of the file share.
         */
        fun fileShareId(fileShareId: String): FluentBuilder
        /**
         * The name of the file share. Optional.
         * FileShareName must be set if an S3 prefix name is set in
         * LocationARN.
         */
        fun fileShareName(fileShareName: String): FluentBuilder
        /**
         * The status of the file share.
         * Valid Values: CREATING | UPDATING | AVAILABLE |
         * DELETING
         */
        fun fileShareStatus(fileShareStatus: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file
         * extensions. Set this value to true to enable MIME type guessing, otherwise set
         * to false. The default value is true.
         * Valid Values: true | false
         */
        fun guessMimeTypeEnabled(guessMimeTypeEnabled: Boolean): FluentBuilder
        /**
         * A list of users or groups in the Active Directory that are not allowed to access the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        fun invalidUserList(invalidUserList: List<String>): FluentBuilder
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The ARN of the backend storage used for storing file data. A prefix name can be added to
         * the S3 bucket name. It must end with a "/".
         */
        fun locationArn(locationArn: String): FluentBuilder
        /**
         * The notification policy of the file share. SettlingTimeInSeconds controls
         * the number of seconds to wait after the last point in time a client wrote to a file before
         * generating an ObjectUploaded notification. Because clients can make many small
         * writes to files, it's best to set this parameter for as long as possible to avoid
         * generating multiple notifications for the same file in a small time period.
         * SettlingTimeInSeconds has no effect on the timing of the object
         * uploading to Amazon S3, only the timing of the notification.
         * The following example sets NotificationPolicy on with
         * SettlingTimeInSeconds set to 60.
         * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
         * The following example sets NotificationPolicy off.
         * {}
         */
        fun notificationPolicy(notificationPolicy: String): FluentBuilder
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket
         * that an S3 File Gateway puts objects into. The default value is private.
         */
        fun objectAcl(objectAcl: ObjectAcl): FluentBuilder
        /**
         * Specifies whether opportunistic locking is enabled for the SMB file share.
         * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve
         * access to files with the same name in different case.
         * Valid Values: true | false
         */
        fun oplocksEnabled(oplocksEnabled: Boolean): FluentBuilder
        /**
         * The file share path used by the SMB client to identify the mount point.
         */
        fun path(path: String): FluentBuilder
        /**
         * A value that sets the write status of a file share. Set this value to true
         * to set the write status to read-only, otherwise set to false.
         * Valid Values: true | false
         */
        fun readOnly(readOnly: Boolean): FluentBuilder
        /**
         * A value that sets who pays the cost of the request and the cost associated with data
         * download from the S3 bucket. If this value is set to true, the requester pays
         * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
         * the cost of storing data.
         * RequesterPays is a configuration for the S3 bucket that backs the file
         * share, so make sure that the configuration on the file share is the same as the S3
         * bucket configuration.
         * Valid Values: true | false
         */
        fun requesterPays(requesterPays: Boolean): FluentBuilder
        /**
         * The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
         * storage.
         */
        fun role(role: String): FluentBuilder
        /**
         * If this value is set to true, it indicates that access control list (ACL)
         * is enabled on the SMB file share. If it is set to false, it indicates that
         * file and directory permissions are mapped to the POSIX permission.
         * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
         * control access to an SMB file share in the Storage Gateway User
         * Guide.
         */
        fun smbaclEnabled(smbaclEnabled: Boolean): FluentBuilder
        /**
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
         * name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
         * view all tags using the ListTagsForResource API operation.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * A list of users or groups in the Active Directory that are allowed to access the file
         * share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        fun validUserList(validUserList: List<String>): FluentBuilder
        /**
         * Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.
         * This parameter is required for SMB file shares that connect to Amazon S3
         * through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        fun vpcEndpointDnsName(vpcEndpointDnsName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether AccessBasedEnumeration is enabled.
         */
        var accessBasedEnumeration: Boolean?
        /**
         * A list of users or groups in the Active Directory that have administrator rights to the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        var adminUserList: List<String>?
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        var auditDestinationArn: String?
        /**
         * The authentication method of the file share. The default is
         * ActiveDirectory.
         * Valid Values: ActiveDirectory | GuestAccess
         */
        var authentication: String?
        /**
         * Specifies the Region of the S3 bucket where the SMB file share stores files.
         * This parameter is required for SMB file shares that connect to Amazon S3
         * through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        var bucketRegion: String?
        /**
         * Refresh cache information for the file share.
         */
        var cacheAttributes: CacheAttributes?
        /**
         * The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
         * client determines the case sensitivity. For CaseSensitive, the gateway
         * determines the case sensitivity. The default value is ClientSpecified.
         */
        var caseSensitivity: CaseSensitivity?
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
         * The default value is S3_INTELLIGENT_TIERING. Optional.
         * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
         * S3_STANDARD_IA | S3_ONEZONE_IA
         */
        var defaultStorageClass: String?
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        var fileShareArn: String?
        /**
         * The ID of the file share.
         */
        var fileShareId: String?
        /**
         * The name of the file share. Optional.
         * FileShareName must be set if an S3 prefix name is set in
         * LocationARN.
         */
        var fileShareName: String?
        /**
         * The status of the file share.
         * Valid Values: CREATING | UPDATING | AVAILABLE |
         * DELETING
         */
        var fileShareStatus: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file
         * extensions. Set this value to true to enable MIME type guessing, otherwise set
         * to false. The default value is true.
         * Valid Values: true | false
         */
        var guessMimeTypeEnabled: Boolean?
        /**
         * A list of users or groups in the Active Directory that are not allowed to access the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        var invalidUserList: List<String>?
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        var kmsEncrypted: Boolean
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The ARN of the backend storage used for storing file data. A prefix name can be added to
         * the S3 bucket name. It must end with a "/".
         */
        var locationArn: String?
        /**
         * The notification policy of the file share. SettlingTimeInSeconds controls
         * the number of seconds to wait after the last point in time a client wrote to a file before
         * generating an ObjectUploaded notification. Because clients can make many small
         * writes to files, it's best to set this parameter for as long as possible to avoid
         * generating multiple notifications for the same file in a small time period.
         * SettlingTimeInSeconds has no effect on the timing of the object
         * uploading to Amazon S3, only the timing of the notification.
         * The following example sets NotificationPolicy on with
         * SettlingTimeInSeconds set to 60.
         * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
         * The following example sets NotificationPolicy off.
         * {}
         */
        var notificationPolicy: String?
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket
         * that an S3 File Gateway puts objects into. The default value is private.
         */
        var objectAcl: ObjectAcl?
        /**
         * Specifies whether opportunistic locking is enabled for the SMB file share.
         * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve
         * access to files with the same name in different case.
         * Valid Values: true | false
         */
        var oplocksEnabled: Boolean?
        /**
         * The file share path used by the SMB client to identify the mount point.
         */
        var path: String?
        /**
         * A value that sets the write status of a file share. Set this value to true
         * to set the write status to read-only, otherwise set to false.
         * Valid Values: true | false
         */
        var readOnly: Boolean?
        /**
         * A value that sets who pays the cost of the request and the cost associated with data
         * download from the S3 bucket. If this value is set to true, the requester pays
         * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
         * the cost of storing data.
         * RequesterPays is a configuration for the S3 bucket that backs the file
         * share, so make sure that the configuration on the file share is the same as the S3
         * bucket configuration.
         * Valid Values: true | false
         */
        var requesterPays: Boolean?
        /**
         * The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying
         * storage.
         */
        var role: String?
        /**
         * If this value is set to true, it indicates that access control list (ACL)
         * is enabled on the SMB file share. If it is set to false, it indicates that
         * file and directory permissions are mapped to the POSIX permission.
         * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
         * control access to an SMB file share in the Storage Gateway User
         * Guide.
         */
        var smbaclEnabled: Boolean?
        /**
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key
         * name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
         * view all tags using the ListTagsForResource API operation.
         */
        var tags: List<Tag>?
        /**
         * A list of users or groups in the Active Directory that are allowed to access the file
         * share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        var validUserList: List<String>?
        /**
         * Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.
         * This parameter is required for SMB file shares that connect to Amazon S3
         * through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        var vpcEndpointDnsName: String?

        fun build(): SmbFileShareInfo
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        fun cacheAttributes(block: CacheAttributes.DslBuilder.() -> kotlin.Unit) {
            this.cacheAttributes = CacheAttributes.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessBasedEnumeration: Boolean? = null
        override var adminUserList: List<String>? = null
        override var auditDestinationArn: String? = null
        override var authentication: String? = null
        override var bucketRegion: String? = null
        override var cacheAttributes: CacheAttributes? = null
        override var caseSensitivity: CaseSensitivity? = null
        override var defaultStorageClass: String? = null
        override var fileShareArn: String? = null
        override var fileShareId: String? = null
        override var fileShareName: String? = null
        override var fileShareStatus: String? = null
        override var gatewayArn: String? = null
        override var guessMimeTypeEnabled: Boolean? = null
        override var invalidUserList: List<String>? = null
        override var kmsEncrypted: Boolean = false
        override var kmsKey: String? = null
        override var locationArn: String? = null
        override var notificationPolicy: String? = null
        override var objectAcl: ObjectAcl? = null
        override var oplocksEnabled: Boolean? = null
        override var path: String? = null
        override var readOnly: Boolean? = null
        override var requesterPays: Boolean? = null
        override var role: String? = null
        override var smbaclEnabled: Boolean? = null
        override var tags: List<Tag>? = null
        override var validUserList: List<String>? = null
        override var vpcEndpointDnsName: String? = null

        constructor(x: SmbFileShareInfo) : this() {
            this.accessBasedEnumeration = x.accessBasedEnumeration
            this.adminUserList = x.adminUserList
            this.auditDestinationArn = x.auditDestinationArn
            this.authentication = x.authentication
            this.bucketRegion = x.bucketRegion
            this.cacheAttributes = x.cacheAttributes
            this.caseSensitivity = x.caseSensitivity
            this.defaultStorageClass = x.defaultStorageClass
            this.fileShareArn = x.fileShareArn
            this.fileShareId = x.fileShareId
            this.fileShareName = x.fileShareName
            this.fileShareStatus = x.fileShareStatus
            this.gatewayArn = x.gatewayArn
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.invalidUserList = x.invalidUserList
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.locationArn = x.locationArn
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.oplocksEnabled = x.oplocksEnabled
            this.path = x.path
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.role = x.role
            this.smbaclEnabled = x.smbaclEnabled
            this.tags = x.tags
            this.validUserList = x.validUserList
            this.vpcEndpointDnsName = x.vpcEndpointDnsName
        }

        override fun build(): SmbFileShareInfo = SmbFileShareInfo(this)
        override fun accessBasedEnumeration(accessBasedEnumeration: Boolean): FluentBuilder = apply { this.accessBasedEnumeration = accessBasedEnumeration }
        override fun adminUserList(adminUserList: List<String>): FluentBuilder = apply { this.adminUserList = adminUserList }
        override fun auditDestinationArn(auditDestinationArn: String): FluentBuilder = apply { this.auditDestinationArn = auditDestinationArn }
        override fun authentication(authentication: String): FluentBuilder = apply { this.authentication = authentication }
        override fun bucketRegion(bucketRegion: String): FluentBuilder = apply { this.bucketRegion = bucketRegion }
        override fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder = apply { this.cacheAttributes = cacheAttributes }
        override fun caseSensitivity(caseSensitivity: CaseSensitivity): FluentBuilder = apply { this.caseSensitivity = caseSensitivity }
        override fun defaultStorageClass(defaultStorageClass: String): FluentBuilder = apply { this.defaultStorageClass = defaultStorageClass }
        override fun fileShareArn(fileShareArn: String): FluentBuilder = apply { this.fileShareArn = fileShareArn }
        override fun fileShareId(fileShareId: String): FluentBuilder = apply { this.fileShareId = fileShareId }
        override fun fileShareName(fileShareName: String): FluentBuilder = apply { this.fileShareName = fileShareName }
        override fun fileShareStatus(fileShareStatus: String): FluentBuilder = apply { this.fileShareStatus = fileShareStatus }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun guessMimeTypeEnabled(guessMimeTypeEnabled: Boolean): FluentBuilder = apply { this.guessMimeTypeEnabled = guessMimeTypeEnabled }
        override fun invalidUserList(invalidUserList: List<String>): FluentBuilder = apply { this.invalidUserList = invalidUserList }
        override fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder = apply { this.kmsEncrypted = kmsEncrypted }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun locationArn(locationArn: String): FluentBuilder = apply { this.locationArn = locationArn }
        override fun notificationPolicy(notificationPolicy: String): FluentBuilder = apply { this.notificationPolicy = notificationPolicy }
        override fun objectAcl(objectAcl: ObjectAcl): FluentBuilder = apply { this.objectAcl = objectAcl }
        override fun oplocksEnabled(oplocksEnabled: Boolean): FluentBuilder = apply { this.oplocksEnabled = oplocksEnabled }
        override fun path(path: String): FluentBuilder = apply { this.path = path }
        override fun readOnly(readOnly: Boolean): FluentBuilder = apply { this.readOnly = readOnly }
        override fun requesterPays(requesterPays: Boolean): FluentBuilder = apply { this.requesterPays = requesterPays }
        override fun role(role: String): FluentBuilder = apply { this.role = role }
        override fun smbaclEnabled(smbaclEnabled: Boolean): FluentBuilder = apply { this.smbaclEnabled = smbaclEnabled }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun validUserList(validUserList: List<String>): FluentBuilder = apply { this.validUserList = validUserList }
        override fun vpcEndpointDnsName(vpcEndpointDnsName: String): FluentBuilder = apply { this.vpcEndpointDnsName = vpcEndpointDnsName }
    }
}
