// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * RefreshCacheInput
 */
class RefreshCacheRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the file share you want to refresh.
     */
    val fileShareArn: String? = builder.fileShareArn
    /**
     * A comma-separated list of the paths of folders to refresh in the cache. The default is
     * &#91;"/"&#93;. The default refreshes objects and folders at the root of the Amazon S3 bucket. If Recursive is set to true, the entire S3 bucket that
     * the file share has access to is refreshed.
     */
    val folderList: List<String>? = builder.folderList
    /**
     * A value that specifies whether to recursively refresh folders in the cache. The refresh
     * includes folders that were in the cache the last time the gateway listed the folder's
     * contents. If this value set to true, each folder that is listed in
     * FolderList is recursively updated. Otherwise, subfolders listed in
     * FolderList are not refreshed. Only objects that are in folders listed
     * directly under FolderList are found and used for the update. The default is
     * true.
     * Valid Values: true | false
     */
    val recursive: Boolean? = builder.recursive

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RefreshCacheRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RefreshCacheRequest(")
        append("fileShareArn=$fileShareArn,")
        append("folderList=$folderList,")
        append("recursive=$recursive)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileShareArn?.hashCode() ?: 0
        result = 31 * result + (folderList?.hashCode() ?: 0)
        result = 31 * result + (recursive?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RefreshCacheRequest

        if (fileShareArn != other.fileShareArn) return false
        if (folderList != other.folderList) return false
        if (recursive != other.recursive) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RefreshCacheRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RefreshCacheRequest
        /**
         * The Amazon Resource Name (ARN) of the file share you want to refresh.
         */
        fun fileShareArn(fileShareArn: String): FluentBuilder
        /**
         * A comma-separated list of the paths of folders to refresh in the cache. The default is
         * &#91;"/"&#93;. The default refreshes objects and folders at the root of the Amazon S3 bucket. If Recursive is set to true, the entire S3 bucket that
         * the file share has access to is refreshed.
         */
        fun folderList(folderList: List<String>): FluentBuilder
        /**
         * A value that specifies whether to recursively refresh folders in the cache. The refresh
         * includes folders that were in the cache the last time the gateway listed the folder's
         * contents. If this value set to true, each folder that is listed in
         * FolderList is recursively updated. Otherwise, subfolders listed in
         * FolderList are not refreshed. Only objects that are in folders listed
         * directly under FolderList are found and used for the update. The default is
         * true.
         * Valid Values: true | false
         */
        fun recursive(recursive: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the file share you want to refresh.
         */
        var fileShareArn: String?
        /**
         * A comma-separated list of the paths of folders to refresh in the cache. The default is
         * &#91;"/"&#93;. The default refreshes objects and folders at the root of the Amazon S3 bucket. If Recursive is set to true, the entire S3 bucket that
         * the file share has access to is refreshed.
         */
        var folderList: List<String>?
        /**
         * A value that specifies whether to recursively refresh folders in the cache. The refresh
         * includes folders that were in the cache the last time the gateway listed the folder's
         * contents. If this value set to true, each folder that is listed in
         * FolderList is recursively updated. Otherwise, subfolders listed in
         * FolderList are not refreshed. Only objects that are in folders listed
         * directly under FolderList are found and used for the update. The default is
         * true.
         * Valid Values: true | false
         */
        var recursive: Boolean?

        fun build(): RefreshCacheRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fileShareArn: String? = null
        override var folderList: List<String>? = null
        override var recursive: Boolean? = null

        constructor(x: RefreshCacheRequest) : this() {
            this.fileShareArn = x.fileShareArn
            this.folderList = x.folderList
            this.recursive = x.recursive
        }

        override fun build(): RefreshCacheRequest = RefreshCacheRequest(this)
        override fun fileShareArn(fileShareArn: String): FluentBuilder = apply { this.fileShareArn = fileShareArn }
        override fun folderList(folderList: List<String>): FluentBuilder = apply { this.folderList = folderList }
        override fun recursive(recursive: Boolean): FluentBuilder = apply { this.recursive = recursive }
    }
}
