// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a custom tape pool.
 */
class PoolInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the custom tape pool. Use the ListTapePools operation to return a list of custom tape pools for your
     * account and Region.
     */
    val poolArn: String? = builder.poolArn
    /**
     * The name of the custom tape pool. PoolName can use all ASCII characters,
     * except '/' and '\'.
     */
    val poolName: String? = builder.poolName
    /**
     * Status of the custom tape pool. Pool can be ACTIVE or
     * DELETED.
     */
    val poolStatus: PoolStatus? = builder.poolStatus
    /**
     * Tape retention lock time is set in days. Tape retention lock can be enabled for up to
     * 100 years (36,500 days).
     */
    val retentionLockTimeInDays: Int? = builder.retentionLockTimeInDays
    /**
     * Tape retention lock type, which can be configured in two modes. When configured in
     * governance mode, accounts with specific IAM permissions are authorized to remove the
     * tape retention lock from archived virtual tapes. When configured in compliance mode, the
     * tape retention lock cannot be removed by any user, including the root account.
     */
    val retentionLockType: RetentionLockType? = builder.retentionLockType
    /**
     * The storage class that is associated with the custom pool. When you use your backup
     * application to eject the tape, the tape is archived directly into the storage class (S3
     * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    val storageClass: TapeStorageClass? = builder.storageClass

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PoolInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PoolInfo(")
        append("poolArn=$poolArn,")
        append("poolName=$poolName,")
        append("poolStatus=$poolStatus,")
        append("retentionLockTimeInDays=$retentionLockTimeInDays,")
        append("retentionLockType=$retentionLockType,")
        append("storageClass=$storageClass)")
    }

    override fun hashCode(): kotlin.Int {
        var result = poolArn?.hashCode() ?: 0
        result = 31 * result + (poolName?.hashCode() ?: 0)
        result = 31 * result + (poolStatus?.hashCode() ?: 0)
        result = 31 * result + (retentionLockTimeInDays ?: 0)
        result = 31 * result + (retentionLockType?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PoolInfo

        if (poolArn != other.poolArn) return false
        if (poolName != other.poolName) return false
        if (poolStatus != other.poolStatus) return false
        if (retentionLockTimeInDays != other.retentionLockTimeInDays) return false
        if (retentionLockType != other.retentionLockType) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PoolInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PoolInfo
        /**
         * The Amazon Resource Name (ARN) of the custom tape pool. Use the ListTapePools operation to return a list of custom tape pools for your
         * account and Region.
         */
        fun poolArn(poolArn: String): FluentBuilder
        /**
         * The name of the custom tape pool. PoolName can use all ASCII characters,
         * except '/' and '\'.
         */
        fun poolName(poolName: String): FluentBuilder
        /**
         * Status of the custom tape pool. Pool can be ACTIVE or
         * DELETED.
         */
        fun poolStatus(poolStatus: PoolStatus): FluentBuilder
        /**
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to
         * 100 years (36,500 days).
         */
        fun retentionLockTimeInDays(retentionLockTimeInDays: Int): FluentBuilder
        /**
         * Tape retention lock type, which can be configured in two modes. When configured in
         * governance mode, accounts with specific IAM permissions are authorized to remove the
         * tape retention lock from archived virtual tapes. When configured in compliance mode, the
         * tape retention lock cannot be removed by any user, including the root account.
         */
        fun retentionLockType(retentionLockType: RetentionLockType): FluentBuilder
        /**
         * The storage class that is associated with the custom pool. When you use your backup
         * application to eject the tape, the tape is archived directly into the storage class (S3
         * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        fun storageClass(storageClass: TapeStorageClass): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the custom tape pool. Use the ListTapePools operation to return a list of custom tape pools for your
         * account and Region.
         */
        var poolArn: String?
        /**
         * The name of the custom tape pool. PoolName can use all ASCII characters,
         * except '/' and '\'.
         */
        var poolName: String?
        /**
         * Status of the custom tape pool. Pool can be ACTIVE or
         * DELETED.
         */
        var poolStatus: PoolStatus?
        /**
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to
         * 100 years (36,500 days).
         */
        var retentionLockTimeInDays: Int?
        /**
         * Tape retention lock type, which can be configured in two modes. When configured in
         * governance mode, accounts with specific IAM permissions are authorized to remove the
         * tape retention lock from archived virtual tapes. When configured in compliance mode, the
         * tape retention lock cannot be removed by any user, including the root account.
         */
        var retentionLockType: RetentionLockType?
        /**
         * The storage class that is associated with the custom pool. When you use your backup
         * application to eject the tape, the tape is archived directly into the storage class (S3
         * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        var storageClass: TapeStorageClass?

        fun build(): PoolInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var poolArn: String? = null
        override var poolName: String? = null
        override var poolStatus: PoolStatus? = null
        override var retentionLockTimeInDays: Int? = null
        override var retentionLockType: RetentionLockType? = null
        override var storageClass: TapeStorageClass? = null

        constructor(x: PoolInfo) : this() {
            this.poolArn = x.poolArn
            this.poolName = x.poolName
            this.poolStatus = x.poolStatus
            this.retentionLockTimeInDays = x.retentionLockTimeInDays
            this.retentionLockType = x.retentionLockType
            this.storageClass = x.storageClass
        }

        override fun build(): PoolInfo = PoolInfo(this)
        override fun poolArn(poolArn: String): FluentBuilder = apply { this.poolArn = poolArn }
        override fun poolName(poolName: String): FluentBuilder = apply { this.poolName = poolName }
        override fun poolStatus(poolStatus: PoolStatus): FluentBuilder = apply { this.poolStatus = poolStatus }
        override fun retentionLockTimeInDays(retentionLockTimeInDays: Int): FluentBuilder = apply { this.retentionLockTimeInDays = retentionLockTimeInDays }
        override fun retentionLockType(retentionLockType: RetentionLockType): FluentBuilder = apply { this.retentionLockType = retentionLockType }
        override fun storageClass(storageClass: TapeStorageClass): FluentBuilder = apply { this.storageClass = storageClass }
    }
}
