// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes Network File System (NFS) file share default values. Files and folders stored
 * as Amazon S3 objects in S3 buckets don't, by default, have Unix file permissions
 * assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects that
 * represent files and folders are assigned these default Unix permissions. This operation is
 * only supported for S3 File Gateways.
 */
class NfsFileShareDefaults private constructor(builder: BuilderImpl) {
    /**
     * The Unix directory mode in the form "nnnn". For example, 0666 represents
     * the default access mode for all directories inside the file share. The default value is
     * 0777.
     */
    val directoryMode: String? = builder.directoryMode
    /**
     * The Unix file mode in the form "nnnn". For example, 0666 represents the
     * default file mode inside the file share. The default value is 0666.
     */
    val fileMode: String? = builder.fileMode
    /**
     * The default group ID for the file share (unless the files have another group ID
     * specified). The default value is nfsnobody.
     */
    val groupId: Long? = builder.groupId
    /**
     * The default owner ID for files in the file share (unless the files have another owner ID
     * specified). The default value is nfsnobody.
     */
    val ownerId: Long? = builder.ownerId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NfsFileShareDefaults = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NfsFileShareDefaults(")
        append("directoryMode=$directoryMode,")
        append("fileMode=$fileMode,")
        append("groupId=$groupId,")
        append("ownerId=$ownerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = directoryMode?.hashCode() ?: 0
        result = 31 * result + (fileMode?.hashCode() ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NfsFileShareDefaults

        if (directoryMode != other.directoryMode) return false
        if (fileMode != other.fileMode) return false
        if (groupId != other.groupId) return false
        if (ownerId != other.ownerId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NfsFileShareDefaults = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NfsFileShareDefaults
        /**
         * The Unix directory mode in the form "nnnn". For example, 0666 represents
         * the default access mode for all directories inside the file share. The default value is
         * 0777.
         */
        fun directoryMode(directoryMode: String): FluentBuilder
        /**
         * The Unix file mode in the form "nnnn". For example, 0666 represents the
         * default file mode inside the file share. The default value is 0666.
         */
        fun fileMode(fileMode: String): FluentBuilder
        /**
         * The default group ID for the file share (unless the files have another group ID
         * specified). The default value is nfsnobody.
         */
        fun groupId(groupId: Long): FluentBuilder
        /**
         * The default owner ID for files in the file share (unless the files have another owner ID
         * specified). The default value is nfsnobody.
         */
        fun ownerId(ownerId: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Unix directory mode in the form "nnnn". For example, 0666 represents
         * the default access mode for all directories inside the file share. The default value is
         * 0777.
         */
        var directoryMode: String?
        /**
         * The Unix file mode in the form "nnnn". For example, 0666 represents the
         * default file mode inside the file share. The default value is 0666.
         */
        var fileMode: String?
        /**
         * The default group ID for the file share (unless the files have another group ID
         * specified). The default value is nfsnobody.
         */
        var groupId: Long?
        /**
         * The default owner ID for files in the file share (unless the files have another owner ID
         * specified). The default value is nfsnobody.
         */
        var ownerId: Long?

        fun build(): NfsFileShareDefaults
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var directoryMode: String? = null
        override var fileMode: String? = null
        override var groupId: Long? = null
        override var ownerId: Long? = null

        constructor(x: NfsFileShareDefaults) : this() {
            this.directoryMode = x.directoryMode
            this.fileMode = x.fileMode
            this.groupId = x.groupId
            this.ownerId = x.ownerId
        }

        override fun build(): NfsFileShareDefaults = NfsFileShareDefaults(this)
        override fun directoryMode(directoryMode: String): FluentBuilder = apply { this.directoryMode = directoryMode }
        override fun fileMode(fileMode: String): FluentBuilder = apply { this.fileMode = fileMode }
        override fun groupId(groupId: Long): FluentBuilder = apply { this.groupId = groupId }
        override fun ownerId(ownerId: Long): FluentBuilder = apply { this.ownerId = ownerId }
    }
}
