// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a gateway's network interface.
 */
class NetworkInterface private constructor(builder: BuilderImpl) {
    /**
     * The Internet Protocol version 4 (IPv4) address of the interface.
     */
    val ipv4Address: String? = builder.ipv4Address
    /**
     * The Internet Protocol version 6 (IPv6) address of the interface. Currently not
     * supported.
     */
    val ipv6Address: String? = builder.ipv6Address
    /**
     * The Media Access Control (MAC) address of the interface.
     * This is currently unsupported and will not be returned in output.
     */
    val macAddress: String? = builder.macAddress

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NetworkInterface = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterface(")
        append("ipv4Address=$ipv4Address,")
        append("ipv6Address=$ipv6Address,")
        append("macAddress=$macAddress)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ipv4Address?.hashCode() ?: 0
        result = 31 * result + (ipv6Address?.hashCode() ?: 0)
        result = 31 * result + (macAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NetworkInterface

        if (ipv4Address != other.ipv4Address) return false
        if (ipv6Address != other.ipv6Address) return false
        if (macAddress != other.macAddress) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NetworkInterface = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NetworkInterface
        /**
         * The Internet Protocol version 4 (IPv4) address of the interface.
         */
        fun ipv4Address(ipv4Address: String): FluentBuilder
        /**
         * The Internet Protocol version 6 (IPv6) address of the interface. Currently not
         * supported.
         */
        fun ipv6Address(ipv6Address: String): FluentBuilder
        /**
         * The Media Access Control (MAC) address of the interface.
         * This is currently unsupported and will not be returned in output.
         */
        fun macAddress(macAddress: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Internet Protocol version 4 (IPv4) address of the interface.
         */
        var ipv4Address: String?
        /**
         * The Internet Protocol version 6 (IPv6) address of the interface. Currently not
         * supported.
         */
        var ipv6Address: String?
        /**
         * The Media Access Control (MAC) address of the interface.
         * This is currently unsupported and will not be returned in output.
         */
        var macAddress: String?

        fun build(): NetworkInterface
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var ipv4Address: String? = null
        override var ipv6Address: String? = null
        override var macAddress: String? = null

        constructor(x: NetworkInterface) : this() {
            this.ipv4Address = x.ipv4Address
            this.ipv6Address = x.ipv6Address
            this.macAddress = x.macAddress
        }

        override fun build(): NetworkInterface = NetworkInterface(this)
        override fun ipv4Address(ipv4Address: String): FluentBuilder = apply { this.ipv4Address = ipv4Address }
        override fun ipv6Address(ipv6Address: String): FluentBuilder = apply { this.ipv6Address = ipv6Address }
        override fun macAddress(macAddress: String): FluentBuilder = apply { this.macAddress = macAddress }
    }
}
