// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * A JSON object that contains one or more of the following fields:
 * ListVolumesInput$Limit
 * ListVolumesInput$Marker
 */
class ListVolumesRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Specifies that the list of volumes returned be limited to the specified number of
     * items.
     */
    val limit: Int? = builder.limit
    /**
     * A string that indicates the position at which to begin the returned list of volumes.
     * Obtain the marker from the response of a previous List iSCSI Volumes request.
     */
    val marker: String? = builder.marker

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListVolumesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListVolumesRequest(")
        append("gatewayArn=$gatewayArn,")
        append("limit=$limit,")
        append("marker=$marker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListVolumesRequest

        if (gatewayArn != other.gatewayArn) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListVolumesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListVolumesRequest
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Specifies that the list of volumes returned be limited to the specified number of
         * items.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * A string that indicates the position at which to begin the returned list of volumes.
         * Obtain the marker from the response of a previous List iSCSI Volumes request.
         */
        fun marker(marker: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Specifies that the list of volumes returned be limited to the specified number of
         * items.
         */
        var limit: Int?
        /**
         * A string that indicates the position at which to begin the returned list of volumes.
         * Obtain the marker from the response of a previous List iSCSI Volumes request.
         */
        var marker: String?

        fun build(): ListVolumesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null
        override var limit: Int? = null
        override var marker: String? = null

        constructor(x: ListVolumesRequest) : this() {
            this.gatewayArn = x.gatewayArn
            this.limit = x.limit
            this.marker = x.marker
        }

        override fun build(): ListVolumesRequest = ListVolumesRequest(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
    }
}
