// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * ListFileShareInput
 */
class ListFileSharesRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
     * this field is not present, all file shares under your account are listed.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The maximum number of file shares to return in the response. The value must be an
     * integer with a value greater than zero. Optional.
     */
    val limit: Int? = builder.limit
    /**
     * Opaque pagination token returned from a previous ListFileShares operation. If present,
     * Marker specifies where to continue the list from after a previous call to
     * ListFileShares. Optional.
     */
    val marker: String? = builder.marker

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListFileSharesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListFileSharesRequest(")
        append("gatewayArn=$gatewayArn,")
        append("limit=$limit,")
        append("marker=$marker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListFileSharesRequest

        if (gatewayArn != other.gatewayArn) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListFileSharesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListFileSharesRequest
        /**
         * The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
         * this field is not present, all file shares under your account are listed.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The maximum number of file shares to return in the response. The value must be an
         * integer with a value greater than zero. Optional.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * Opaque pagination token returned from a previous ListFileShares operation. If present,
         * Marker specifies where to continue the list from after a previous call to
         * ListFileShares. Optional.
         */
        fun marker(marker: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If
         * this field is not present, all file shares under your account are listed.
         */
        var gatewayArn: String?
        /**
         * The maximum number of file shares to return in the response. The value must be an
         * integer with a value greater than zero. Optional.
         */
        var limit: Int?
        /**
         * Opaque pagination token returned from a previous ListFileShares operation. If present,
         * Marker specifies where to continue the list from after a previous call to
         * ListFileShares. Optional.
         */
        var marker: String?

        fun build(): ListFileSharesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null
        override var limit: Int? = null
        override var marker: String? = null

        constructor(x: ListFileSharesRequest) : this() {
            this.gatewayArn = x.gatewayArn
            this.limit = x.limit
            this.marker = x.marker
        }

        override fun build(): ListFileSharesRequest = ListFileSharesRequest(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
    }
}
