// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * JoinDomainOutput
 */
class JoinDomainResponse private constructor(builder: BuilderImpl) {
    /**
     * Indicates the status of the gateway as a member of the Active Directory domain.
     * ACCESS_DENIED: Indicates that the JoinDomain operation
     * failed due to an authentication error.
     * DETACHED: Indicates that gateway is not joined to a domain.
     * JOINED: Indicates that the gateway has successfully joined a
     * domain.
     * JOINING: Indicates that a JoinDomain operation is in
     * progress.
     * NETWORK_ERROR: Indicates that JoinDomain operation
     * failed due to a network or connectivity error.
     * TIMEOUT: Indicates that the JoinDomain operation failed
     * because the operation didn't complete within the allotted time.
     * UNKNOWN_ERROR: Indicates that the JoinDomain operation
     * failed due to another type of error.
     */
    val activeDirectoryStatus: ActiveDirectoryStatus? = builder.activeDirectoryStatus
    /**
     * The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
     */
    val gatewayArn: String? = builder.gatewayArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): JoinDomainResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("JoinDomainResponse(")
        append("activeDirectoryStatus=$activeDirectoryStatus,")
        append("gatewayArn=$gatewayArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryStatus?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as JoinDomainResponse

        if (activeDirectoryStatus != other.activeDirectoryStatus) return false
        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): JoinDomainResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): JoinDomainResponse
        /**
         * Indicates the status of the gateway as a member of the Active Directory domain.
         * ACCESS_DENIED: Indicates that the JoinDomain operation
         * failed due to an authentication error.
         * DETACHED: Indicates that gateway is not joined to a domain.
         * JOINED: Indicates that the gateway has successfully joined a
         * domain.
         * JOINING: Indicates that a JoinDomain operation is in
         * progress.
         * NETWORK_ERROR: Indicates that JoinDomain operation
         * failed due to a network or connectivity error.
         * TIMEOUT: Indicates that the JoinDomain operation failed
         * because the operation didn't complete within the allotted time.
         * UNKNOWN_ERROR: Indicates that the JoinDomain operation
         * failed due to another type of error.
         */
        fun activeDirectoryStatus(activeDirectoryStatus: ActiveDirectoryStatus): FluentBuilder
        /**
         * The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates the status of the gateway as a member of the Active Directory domain.
         * ACCESS_DENIED: Indicates that the JoinDomain operation
         * failed due to an authentication error.
         * DETACHED: Indicates that gateway is not joined to a domain.
         * JOINED: Indicates that the gateway has successfully joined a
         * domain.
         * JOINING: Indicates that a JoinDomain operation is in
         * progress.
         * NETWORK_ERROR: Indicates that JoinDomain operation
         * failed due to a network or connectivity error.
         * TIMEOUT: Indicates that the JoinDomain operation failed
         * because the operation didn't complete within the allotted time.
         * UNKNOWN_ERROR: Indicates that the JoinDomain operation
         * failed due to another type of error.
         */
        var activeDirectoryStatus: ActiveDirectoryStatus?
        /**
         * The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
         */
        var gatewayArn: String?

        fun build(): JoinDomainResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activeDirectoryStatus: ActiveDirectoryStatus? = null
        override var gatewayArn: String? = null

        constructor(x: JoinDomainResponse) : this() {
            this.activeDirectoryStatus = x.activeDirectoryStatus
            this.gatewayArn = x.gatewayArn
        }

        override fun build(): JoinDomainResponse = JoinDomainResponse(this)
        override fun activeDirectoryStatus(activeDirectoryStatus: ActiveDirectoryStatus): FluentBuilder = apply { this.activeDirectoryStatus = activeDirectoryStatus }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
    }
}
