// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * JoinDomainInput
 */
class JoinDomainRequest private constructor(builder: BuilderImpl) {
    /**
     * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
     * to specify the port number include it after the colon (“:”). For example,
     * mydc.mydomain.com:389.
     */
    val domainControllers: List<String>? = builder.domainControllers
    /**
     * The name of the domain that you want the gateway to join.
     */
    val domainName: String? = builder.domainName
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The organizational unit (OU) is a container in an Active Directory that can hold users,
     * groups, computers, and other OUs and this parameter specifies the OU that the gateway will
     * join within the AD domain.
     */
    val organizationalUnit: String? = builder.organizationalUnit
    /**
     * Sets the password of the user who has permission to add the gateway to the Active
     * Directory domain.
     */
    val password: String? = builder.password
    /**
     * Specifies the time in seconds, in which the JoinDomain operation must
     * complete. The default is 20 seconds.
     */
    val timeoutInSeconds: Int? = builder.timeoutInSeconds
    /**
     * Sets the user name of user who has permission to add the gateway to the Active Directory
     * domain. The domain user account should be enabled to join computers to the domain. For
     * example, you can use the domain administrator account or an account with delegated
     * permissions to join computers to the domain.
     */
    val userName: String? = builder.userName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): JoinDomainRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("JoinDomainRequest(")
        append("domainControllers=$domainControllers,")
        append("domainName=$domainName,")
        append("gatewayArn=$gatewayArn,")
        append("organizationalUnit=$organizationalUnit,")
        append("password=*** Sensitive Data Redacted ***,")
        append("timeoutInSeconds=$timeoutInSeconds,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainControllers?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnit?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (timeoutInSeconds ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as JoinDomainRequest

        if (domainControllers != other.domainControllers) return false
        if (domainName != other.domainName) return false
        if (gatewayArn != other.gatewayArn) return false
        if (organizationalUnit != other.organizationalUnit) return false
        if (password != other.password) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false
        if (userName != other.userName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): JoinDomainRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): JoinDomainRequest
        /**
         * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
         * to specify the port number include it after the colon (“:”). For example,
         * mydc.mydomain.com:389.
         */
        fun domainControllers(domainControllers: List<String>): FluentBuilder
        /**
         * The name of the domain that you want the gateway to join.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The organizational unit (OU) is a container in an Active Directory that can hold users,
         * groups, computers, and other OUs and this parameter specifies the OU that the gateway will
         * join within the AD domain.
         */
        fun organizationalUnit(organizationalUnit: String): FluentBuilder
        /**
         * Sets the password of the user who has permission to add the gateway to the Active
         * Directory domain.
         */
        fun password(password: String): FluentBuilder
        /**
         * Specifies the time in seconds, in which the JoinDomain operation must
         * complete. The default is 20 seconds.
         */
        fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder
        /**
         * Sets the user name of user who has permission to add the gateway to the Active Directory
         * domain. The domain user account should be enabled to join computers to the domain. For
         * example, you can use the domain administrator account or an account with delegated
         * permissions to join computers to the domain.
         */
        fun userName(userName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need
         * to specify the port number include it after the colon (“:”). For example,
         * mydc.mydomain.com:389.
         */
        var domainControllers: List<String>?
        /**
         * The name of the domain that you want the gateway to join.
         */
        var domainName: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The organizational unit (OU) is a container in an Active Directory that can hold users,
         * groups, computers, and other OUs and this parameter specifies the OU that the gateway will
         * join within the AD domain.
         */
        var organizationalUnit: String?
        /**
         * Sets the password of the user who has permission to add the gateway to the Active
         * Directory domain.
         */
        var password: String?
        /**
         * Specifies the time in seconds, in which the JoinDomain operation must
         * complete. The default is 20 seconds.
         */
        var timeoutInSeconds: Int?
        /**
         * Sets the user name of user who has permission to add the gateway to the Active Directory
         * domain. The domain user account should be enabled to join computers to the domain. For
         * example, you can use the domain administrator account or an account with delegated
         * permissions to join computers to the domain.
         */
        var userName: String?

        fun build(): JoinDomainRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainControllers: List<String>? = null
        override var domainName: String? = null
        override var gatewayArn: String? = null
        override var organizationalUnit: String? = null
        override var password: String? = null
        override var timeoutInSeconds: Int? = null
        override var userName: String? = null

        constructor(x: JoinDomainRequest) : this() {
            this.domainControllers = x.domainControllers
            this.domainName = x.domainName
            this.gatewayArn = x.gatewayArn
            this.organizationalUnit = x.organizationalUnit
            this.password = x.password
            this.timeoutInSeconds = x.timeoutInSeconds
            this.userName = x.userName
        }

        override fun build(): JoinDomainRequest = JoinDomainRequest(this)
        override fun domainControllers(domainControllers: List<String>): FluentBuilder = apply { this.domainControllers = domainControllers }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun organizationalUnit(organizationalUnit: String): FluentBuilder = apply { this.organizationalUnit = organizationalUnit }
        override fun password(password: String): FluentBuilder = apply { this.password = password }
        override fun timeoutInSeconds(timeoutInSeconds: Int): FluentBuilder = apply { this.timeoutInSeconds = timeoutInSeconds }
        override fun userName(userName: String): FluentBuilder = apply { this.userName = userName }
    }
}
