// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a gateway object.
 */
class GatewayInfo private constructor(builder: BuilderImpl) {
    /**
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    val ec2InstanceId: String? = builder.ec2InstanceId
    /**
     * The Region where the Amazon EC2 instance is located.
     */
    val ec2InstanceRegion: String? = builder.ec2InstanceRegion
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The unique identifier assigned to your gateway during activation. This ID becomes part
     * of the gateway Amazon Resource Name (ARN), which you use as input for other
     * operations.
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * The name of the gateway.
     */
    val gatewayName: String? = builder.gatewayName
    /**
     * The state of the gateway.
     * Valid Values: DISABLED | ACTIVE
     */
    val gatewayOperationalState: String? = builder.gatewayOperationalState
    /**
     * The type of the gateway.
     */
    val gatewayType: String? = builder.gatewayType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GatewayInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayInfo(")
        append("ec2InstanceId=$ec2InstanceId,")
        append("ec2InstanceRegion=$ec2InstanceRegion,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayId=$gatewayId,")
        append("gatewayName=$gatewayName,")
        append("gatewayOperationalState=$gatewayOperationalState,")
        append("gatewayType=$gatewayType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2InstanceId?.hashCode() ?: 0
        result = 31 * result + (ec2InstanceRegion?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayOperationalState?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GatewayInfo

        if (ec2InstanceId != other.ec2InstanceId) return false
        if (ec2InstanceRegion != other.ec2InstanceRegion) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayId != other.gatewayId) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayOperationalState != other.gatewayOperationalState) return false
        if (gatewayType != other.gatewayType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GatewayInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GatewayInfo
        /**
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         */
        fun ec2InstanceId(ec2InstanceId: String): FluentBuilder
        /**
         * The Region where the Amazon EC2 instance is located.
         */
        fun ec2InstanceRegion(ec2InstanceRegion: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part
         * of the gateway Amazon Resource Name (ARN), which you use as input for other
         * operations.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * The name of the gateway.
         */
        fun gatewayName(gatewayName: String): FluentBuilder
        /**
         * The state of the gateway.
         * Valid Values: DISABLED | ACTIVE
         */
        fun gatewayOperationalState(gatewayOperationalState: String): FluentBuilder
        /**
         * The type of the gateway.
         */
        fun gatewayType(gatewayType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         */
        var ec2InstanceId: String?
        /**
         * The Region where the Amazon EC2 instance is located.
         */
        var ec2InstanceRegion: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part
         * of the gateway Amazon Resource Name (ARN), which you use as input for other
         * operations.
         */
        var gatewayId: String?
        /**
         * The name of the gateway.
         */
        var gatewayName: String?
        /**
         * The state of the gateway.
         * Valid Values: DISABLED | ACTIVE
         */
        var gatewayOperationalState: String?
        /**
         * The type of the gateway.
         */
        var gatewayType: String?

        fun build(): GatewayInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var ec2InstanceId: String? = null
        override var ec2InstanceRegion: String? = null
        override var gatewayArn: String? = null
        override var gatewayId: String? = null
        override var gatewayName: String? = null
        override var gatewayOperationalState: String? = null
        override var gatewayType: String? = null

        constructor(x: GatewayInfo) : this() {
            this.ec2InstanceId = x.ec2InstanceId
            this.ec2InstanceRegion = x.ec2InstanceRegion
            this.gatewayArn = x.gatewayArn
            this.gatewayId = x.gatewayId
            this.gatewayName = x.gatewayName
            this.gatewayOperationalState = x.gatewayOperationalState
            this.gatewayType = x.gatewayType
        }

        override fun build(): GatewayInfo = GatewayInfo(this)
        override fun ec2InstanceId(ec2InstanceId: String): FluentBuilder = apply { this.ec2InstanceId = ec2InstanceId }
        override fun ec2InstanceRegion(ec2InstanceRegion: String): FluentBuilder = apply { this.ec2InstanceRegion = ec2InstanceRegion }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun gatewayName(gatewayName: String): FluentBuilder = apply { this.gatewayName = gatewayName }
        override fun gatewayOperationalState(gatewayOperationalState: String): FluentBuilder = apply { this.gatewayOperationalState = gatewayOperationalState }
        override fun gatewayType(gatewayType: String): FluentBuilder = apply { this.gatewayType = gatewayType }
    }
}
