// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Gets the summary returned by ListFileSystemAssociation, which is a summary
 * of a created file system association.
 */
class FileSystemAssociationSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the file system association.
     */
    val fileSystemAssociationArn: String? = builder.fileSystemAssociationArn
    /**
     * The ID of the file system association.
     */
    val fileSystemAssociationId: String? = builder.fileSystemAssociationId
    /**
     * The status of the file share. Valid Values: AVAILABLE | CREATING | DELETING |
     * FORCE_DELETING | UPDATING | ERROR
     */
    val fileSystemAssociationStatus: String? = builder.fileSystemAssociationStatus
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FileSystemAssociationSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemAssociationSummary(")
        append("fileSystemAssociationArn=$fileSystemAssociationArn,")
        append("fileSystemAssociationId=$fileSystemAssociationId,")
        append("fileSystemAssociationStatus=$fileSystemAssociationStatus,")
        append("gatewayArn=$gatewayArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemAssociationArn?.hashCode() ?: 0
        result = 31 * result + (fileSystemAssociationId?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAssociationStatus?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FileSystemAssociationSummary

        if (fileSystemAssociationArn != other.fileSystemAssociationArn) return false
        if (fileSystemAssociationId != other.fileSystemAssociationId) return false
        if (fileSystemAssociationStatus != other.fileSystemAssociationStatus) return false
        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FileSystemAssociationSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FileSystemAssociationSummary
        /**
         * The Amazon Resource Name (ARN) of the file system association.
         */
        fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder
        /**
         * The ID of the file system association.
         */
        fun fileSystemAssociationId(fileSystemAssociationId: String): FluentBuilder
        /**
         * The status of the file share. Valid Values: AVAILABLE | CREATING | DELETING |
         * FORCE_DELETING | UPDATING | ERROR
         */
        fun fileSystemAssociationStatus(fileSystemAssociationStatus: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the file system association.
         */
        var fileSystemAssociationArn: String?
        /**
         * The ID of the file system association.
         */
        var fileSystemAssociationId: String?
        /**
         * The status of the file share. Valid Values: AVAILABLE | CREATING | DELETING |
         * FORCE_DELETING | UPDATING | ERROR
         */
        var fileSystemAssociationStatus: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?

        fun build(): FileSystemAssociationSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fileSystemAssociationArn: String? = null
        override var fileSystemAssociationId: String? = null
        override var fileSystemAssociationStatus: String? = null
        override var gatewayArn: String? = null

        constructor(x: FileSystemAssociationSummary) : this() {
            this.fileSystemAssociationArn = x.fileSystemAssociationArn
            this.fileSystemAssociationId = x.fileSystemAssociationId
            this.fileSystemAssociationStatus = x.fileSystemAssociationStatus
            this.gatewayArn = x.gatewayArn
        }

        override fun build(): FileSystemAssociationSummary = FileSystemAssociationSummary(this)
        override fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder = apply { this.fileSystemAssociationArn = fileSystemAssociationArn }
        override fun fileSystemAssociationId(fileSystemAssociationId: String): FluentBuilder = apply { this.fileSystemAssociationId = fileSystemAssociationId }
        override fun fileSystemAssociationStatus(fileSystemAssociationStatus: String): FluentBuilder = apply { this.fileSystemAssociationStatus = fileSystemAssociationStatus }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
    }
}
