// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes the object returned by DescribeFileSystemAssociations that
 * describes a created file system association.
 */
class FileSystemAssociationInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    val auditDestinationArn: String? = builder.auditDestinationArn
    /**
     * The refresh cache information for the file share or FSx file systems.
     */
    val cacheAttributes: CacheAttributes? = builder.cacheAttributes
    /**
     * Specifies network configuration information for the gateway associated with the
     * Amazon FSx file system.
     * If multiple file systems are associated with this gateway, this parameter's IpAddresses
     * field is required.
     */
    val endpointNetworkConfiguration: EndpointNetworkConfiguration? = builder.endpointNetworkConfiguration
    /**
     * The Amazon Resource Name (ARN) of the file system association.
     */
    val fileSystemAssociationArn: String? = builder.fileSystemAssociationArn
    /**
     * The status of the file system association.
     * Valid Values: AVAILABLE | CREATING | DELETING |
     * FORCE_DELETING | UPDATING | ERROR
     */
    val fileSystemAssociationStatus: String? = builder.fileSystemAssociationStatus
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The ARN of the backend Amazon FSx file system used for storing file data. For
     * information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem in the Amazon FSx
     * API Reference.
     */
    val locationArn: String? = builder.locationArn
    /**
     * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a key-value pair.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FileSystemAssociationInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemAssociationInfo(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("endpointNetworkConfiguration=$endpointNetworkConfiguration,")
        append("fileSystemAssociationArn=$fileSystemAssociationArn,")
        append("fileSystemAssociationStatus=$fileSystemAssociationStatus,")
        append("gatewayArn=$gatewayArn,")
        append("locationArn=$locationArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (endpointNetworkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAssociationStatus?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FileSystemAssociationInfo

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (endpointNetworkConfiguration != other.endpointNetworkConfiguration) return false
        if (fileSystemAssociationArn != other.fileSystemAssociationArn) return false
        if (fileSystemAssociationStatus != other.fileSystemAssociationStatus) return false
        if (gatewayArn != other.gatewayArn) return false
        if (locationArn != other.locationArn) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FileSystemAssociationInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FileSystemAssociationInfo
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        fun auditDestinationArn(auditDestinationArn: String): FluentBuilder
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder
        /**
         * Specifies network configuration information for the gateway associated with the
         * Amazon FSx file system.
         * If multiple file systems are associated with this gateway, this parameter's IpAddresses
         * field is required.
         */
        fun endpointNetworkConfiguration(endpointNetworkConfiguration: EndpointNetworkConfiguration): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the file system association.
         */
        fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder
        /**
         * The status of the file system association.
         * Valid Values: AVAILABLE | CREATING | DELETING |
         * FORCE_DELETING | UPDATING | ERROR
         */
        fun fileSystemAssociationStatus(fileSystemAssociationStatus: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The ARN of the backend Amazon FSx file system used for storing file data. For
         * information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem in the Amazon FSx
         * API Reference.
         */
        fun locationArn(locationArn: String): FluentBuilder
        /**
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a key-value pair.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        var auditDestinationArn: String?
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        var cacheAttributes: CacheAttributes?
        /**
         * Specifies network configuration information for the gateway associated with the
         * Amazon FSx file system.
         * If multiple file systems are associated with this gateway, this parameter's IpAddresses
         * field is required.
         */
        var endpointNetworkConfiguration: EndpointNetworkConfiguration?
        /**
         * The Amazon Resource Name (ARN) of the file system association.
         */
        var fileSystemAssociationArn: String?
        /**
         * The status of the file system association.
         * Valid Values: AVAILABLE | CREATING | DELETING |
         * FORCE_DELETING | UPDATING | ERROR
         */
        var fileSystemAssociationStatus: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The ARN of the backend Amazon FSx file system used for storing file data. For
         * information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem in the Amazon FSx
         * API Reference.
         */
        var locationArn: String?
        /**
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a key-value pair.
         */
        var tags: List<Tag>?

        fun build(): FileSystemAssociationInfo
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        fun cacheAttributes(block: CacheAttributes.DslBuilder.() -> kotlin.Unit) {
            this.cacheAttributes = CacheAttributes.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration] inside the given [block]
         */
        fun endpointNetworkConfiguration(block: EndpointNetworkConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.endpointNetworkConfiguration = EndpointNetworkConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var auditDestinationArn: String? = null
        override var cacheAttributes: CacheAttributes? = null
        override var endpointNetworkConfiguration: EndpointNetworkConfiguration? = null
        override var fileSystemAssociationArn: String? = null
        override var fileSystemAssociationStatus: String? = null
        override var gatewayArn: String? = null
        override var locationArn: String? = null
        override var tags: List<Tag>? = null

        constructor(x: FileSystemAssociationInfo) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.endpointNetworkConfiguration = x.endpointNetworkConfiguration
            this.fileSystemAssociationArn = x.fileSystemAssociationArn
            this.fileSystemAssociationStatus = x.fileSystemAssociationStatus
            this.gatewayArn = x.gatewayArn
            this.locationArn = x.locationArn
            this.tags = x.tags
        }

        override fun build(): FileSystemAssociationInfo = FileSystemAssociationInfo(this)
        override fun auditDestinationArn(auditDestinationArn: String): FluentBuilder = apply { this.auditDestinationArn = auditDestinationArn }
        override fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder = apply { this.cacheAttributes = cacheAttributes }
        override fun endpointNetworkConfiguration(endpointNetworkConfiguration: EndpointNetworkConfiguration): FluentBuilder = apply { this.endpointNetworkConfiguration = endpointNetworkConfiguration }
        override fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder = apply { this.fileSystemAssociationArn = fileSystemAssociationArn }
        override fun fileSystemAssociationStatus(fileSystemAssociationStatus: String): FluentBuilder = apply { this.fileSystemAssociationStatus = fileSystemAssociationStatus }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun locationArn(locationArn: String): FluentBuilder = apply { this.locationArn = locationArn }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
