// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a file share. Only supported S3 File Gateway.
 */
class FileShareInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the file share.
     */
    val fileShareArn: String? = builder.fileShareArn
    /**
     * The ID of the file share.
     */
    val fileShareId: String? = builder.fileShareId
    /**
     * The status of the file share.
     * Valid Values: CREATING | UPDATING | AVAILABLE |
     * DELETING
     */
    val fileShareStatus: String? = builder.fileShareStatus
    /**
     * The type of the file share.
     */
    val fileShareType: FileShareType? = builder.fileShareType
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FileShareInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FileShareInfo(")
        append("fileShareArn=$fileShareArn,")
        append("fileShareId=$fileShareId,")
        append("fileShareStatus=$fileShareStatus,")
        append("fileShareType=$fileShareType,")
        append("gatewayArn=$gatewayArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileShareArn?.hashCode() ?: 0
        result = 31 * result + (fileShareId?.hashCode() ?: 0)
        result = 31 * result + (fileShareStatus?.hashCode() ?: 0)
        result = 31 * result + (fileShareType?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FileShareInfo

        if (fileShareArn != other.fileShareArn) return false
        if (fileShareId != other.fileShareId) return false
        if (fileShareStatus != other.fileShareStatus) return false
        if (fileShareType != other.fileShareType) return false
        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FileShareInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FileShareInfo
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        fun fileShareArn(fileShareArn: String): FluentBuilder
        /**
         * The ID of the file share.
         */
        fun fileShareId(fileShareId: String): FluentBuilder
        /**
         * The status of the file share.
         * Valid Values: CREATING | UPDATING | AVAILABLE |
         * DELETING
         */
        fun fileShareStatus(fileShareStatus: String): FluentBuilder
        /**
         * The type of the file share.
         */
        fun fileShareType(fileShareType: FileShareType): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        var fileShareArn: String?
        /**
         * The ID of the file share.
         */
        var fileShareId: String?
        /**
         * The status of the file share.
         * Valid Values: CREATING | UPDATING | AVAILABLE |
         * DELETING
         */
        var fileShareStatus: String?
        /**
         * The type of the file share.
         */
        var fileShareType: FileShareType?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?

        fun build(): FileShareInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fileShareArn: String? = null
        override var fileShareId: String? = null
        override var fileShareStatus: String? = null
        override var fileShareType: FileShareType? = null
        override var gatewayArn: String? = null

        constructor(x: FileShareInfo) : this() {
            this.fileShareArn = x.fileShareArn
            this.fileShareId = x.fileShareId
            this.fileShareStatus = x.fileShareStatus
            this.fileShareType = x.fileShareType
            this.gatewayArn = x.gatewayArn
        }

        override fun build(): FileShareInfo = FileShareInfo(this)
        override fun fileShareArn(fileShareArn: String): FluentBuilder = apply { this.fileShareArn = fileShareArn }
        override fun fileShareId(fileShareId: String): FluentBuilder = apply { this.fileShareId = fileShareId }
        override fun fileShareStatus(fileShareStatus: String): FluentBuilder = apply { this.fileShareStatus = fileShareStatus }
        override fun fileShareType(fileShareType: FileShareType): FluentBuilder = apply { this.fileShareType = fileShareType }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
    }
}
