// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Represents a gateway's local disk.
 */
class Disk private constructor(builder: BuilderImpl) {
    /**
     * The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in
     * the response if the local disk is not defined as an iSCSI target. The format of this field
     * is targetIqn::LUNNumber::region-volumeId.
     */
    val diskAllocationResource: String? = builder.diskAllocationResource
    /**
     * One of the DiskAllocationType enumeration values that identifies how a
     * local disk is used.
     * Valid Values: UPLOAD_BUFFER | CACHE_STORAGE
     */
    val diskAllocationType: String? = builder.diskAllocationType
    /**
     * A list of values that represents attributes of a local disk.
     */
    val diskAttributeList: List<String>? = builder.diskAttributeList
    /**
     * The unique device ID or other distinguishing data that identifies a local disk.
     */
    val diskId: String? = builder.diskId
    /**
     * The device node of a local disk as assigned by the virtualization environment.
     */
    val diskNode: String? = builder.diskNode
    /**
     * The path of a local disk in the gateway virtual machine (VM).
     */
    val diskPath: String? = builder.diskPath
    /**
     * The local disk size in bytes.
     */
    val diskSizeInBytes: Long = builder.diskSizeInBytes
    /**
     * A value that represents the status of a local disk.
     */
    val diskStatus: String? = builder.diskStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Disk = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Disk(")
        append("diskAllocationResource=$diskAllocationResource,")
        append("diskAllocationType=$diskAllocationType,")
        append("diskAttributeList=$diskAttributeList,")
        append("diskId=$diskId,")
        append("diskNode=$diskNode,")
        append("diskPath=$diskPath,")
        append("diskSizeInBytes=$diskSizeInBytes,")
        append("diskStatus=$diskStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = diskAllocationResource?.hashCode() ?: 0
        result = 31 * result + (diskAllocationType?.hashCode() ?: 0)
        result = 31 * result + (diskAttributeList?.hashCode() ?: 0)
        result = 31 * result + (diskId?.hashCode() ?: 0)
        result = 31 * result + (diskNode?.hashCode() ?: 0)
        result = 31 * result + (diskPath?.hashCode() ?: 0)
        result = 31 * result + (diskSizeInBytes.hashCode())
        result = 31 * result + (diskStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Disk

        if (diskAllocationResource != other.diskAllocationResource) return false
        if (diskAllocationType != other.diskAllocationType) return false
        if (diskAttributeList != other.diskAttributeList) return false
        if (diskId != other.diskId) return false
        if (diskNode != other.diskNode) return false
        if (diskPath != other.diskPath) return false
        if (diskSizeInBytes != other.diskSizeInBytes) return false
        if (diskStatus != other.diskStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Disk = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Disk
        /**
         * The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in
         * the response if the local disk is not defined as an iSCSI target. The format of this field
         * is targetIqn::LUNNumber::region-volumeId.
         */
        fun diskAllocationResource(diskAllocationResource: String): FluentBuilder
        /**
         * One of the DiskAllocationType enumeration values that identifies how a
         * local disk is used.
         * Valid Values: UPLOAD_BUFFER | CACHE_STORAGE
         */
        fun diskAllocationType(diskAllocationType: String): FluentBuilder
        /**
         * A list of values that represents attributes of a local disk.
         */
        fun diskAttributeList(diskAttributeList: List<String>): FluentBuilder
        /**
         * The unique device ID or other distinguishing data that identifies a local disk.
         */
        fun diskId(diskId: String): FluentBuilder
        /**
         * The device node of a local disk as assigned by the virtualization environment.
         */
        fun diskNode(diskNode: String): FluentBuilder
        /**
         * The path of a local disk in the gateway virtual machine (VM).
         */
        fun diskPath(diskPath: String): FluentBuilder
        /**
         * The local disk size in bytes.
         */
        fun diskSizeInBytes(diskSizeInBytes: Long): FluentBuilder
        /**
         * A value that represents the status of a local disk.
         */
        fun diskStatus(diskStatus: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in
         * the response if the local disk is not defined as an iSCSI target. The format of this field
         * is targetIqn::LUNNumber::region-volumeId.
         */
        var diskAllocationResource: String?
        /**
         * One of the DiskAllocationType enumeration values that identifies how a
         * local disk is used.
         * Valid Values: UPLOAD_BUFFER | CACHE_STORAGE
         */
        var diskAllocationType: String?
        /**
         * A list of values that represents attributes of a local disk.
         */
        var diskAttributeList: List<String>?
        /**
         * The unique device ID or other distinguishing data that identifies a local disk.
         */
        var diskId: String?
        /**
         * The device node of a local disk as assigned by the virtualization environment.
         */
        var diskNode: String?
        /**
         * The path of a local disk in the gateway virtual machine (VM).
         */
        var diskPath: String?
        /**
         * The local disk size in bytes.
         */
        var diskSizeInBytes: Long
        /**
         * A value that represents the status of a local disk.
         */
        var diskStatus: String?

        fun build(): Disk
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var diskAllocationResource: String? = null
        override var diskAllocationType: String? = null
        override var diskAttributeList: List<String>? = null
        override var diskId: String? = null
        override var diskNode: String? = null
        override var diskPath: String? = null
        override var diskSizeInBytes: Long = 0L
        override var diskStatus: String? = null

        constructor(x: Disk) : this() {
            this.diskAllocationResource = x.diskAllocationResource
            this.diskAllocationType = x.diskAllocationType
            this.diskAttributeList = x.diskAttributeList
            this.diskId = x.diskId
            this.diskNode = x.diskNode
            this.diskPath = x.diskPath
            this.diskSizeInBytes = x.diskSizeInBytes
            this.diskStatus = x.diskStatus
        }

        override fun build(): Disk = Disk(this)
        override fun diskAllocationResource(diskAllocationResource: String): FluentBuilder = apply { this.diskAllocationResource = diskAllocationResource }
        override fun diskAllocationType(diskAllocationType: String): FluentBuilder = apply { this.diskAllocationType = diskAllocationType }
        override fun diskAttributeList(diskAttributeList: List<String>): FluentBuilder = apply { this.diskAttributeList = diskAttributeList }
        override fun diskId(diskId: String): FluentBuilder = apply { this.diskId = diskId }
        override fun diskNode(diskNode: String): FluentBuilder = apply { this.diskNode = diskNode }
        override fun diskPath(diskPath: String): FluentBuilder = apply { this.diskPath = diskPath }
        override fun diskSizeInBytes(diskSizeInBytes: Long): FluentBuilder = apply { this.diskSizeInBytes = diskSizeInBytes }
        override fun diskStatus(diskStatus: String): FluentBuilder = apply { this.diskStatus = diskStatus }
    }
}
