// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class DisassociateFileSystemRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the file system association to be deleted.
     */
    val fileSystemAssociationArn: String? = builder.fileSystemAssociationArn
    /**
     * If this value is set to true, the operation disassociates an Amazon FSx file system
     * immediately. It ends all data uploads to the file system, and the file system association
     * enters the FORCE_DELETING status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.
     */
    val forceDelete: Boolean = builder.forceDelete

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DisassociateFileSystemRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DisassociateFileSystemRequest(")
        append("fileSystemAssociationArn=$fileSystemAssociationArn,")
        append("forceDelete=$forceDelete)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemAssociationArn?.hashCode() ?: 0
        result = 31 * result + (forceDelete.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DisassociateFileSystemRequest

        if (fileSystemAssociationArn != other.fileSystemAssociationArn) return false
        if (forceDelete != other.forceDelete) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DisassociateFileSystemRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DisassociateFileSystemRequest
        /**
         * The Amazon Resource Name (ARN) of the file system association to be deleted.
         */
        fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder
        /**
         * If this value is set to true, the operation disassociates an Amazon FSx file system
         * immediately. It ends all data uploads to the file system, and the file system association
         * enters the FORCE_DELETING status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.
         */
        fun forceDelete(forceDelete: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the file system association to be deleted.
         */
        var fileSystemAssociationArn: String?
        /**
         * If this value is set to true, the operation disassociates an Amazon FSx file system
         * immediately. It ends all data uploads to the file system, and the file system association
         * enters the FORCE_DELETING status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.
         */
        var forceDelete: Boolean

        fun build(): DisassociateFileSystemRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fileSystemAssociationArn: String? = null
        override var forceDelete: Boolean = false

        constructor(x: DisassociateFileSystemRequest) : this() {
            this.fileSystemAssociationArn = x.fileSystemAssociationArn
            this.forceDelete = x.forceDelete
        }

        override fun build(): DisassociateFileSystemRequest = DisassociateFileSystemRequest(this)
        override fun fileSystemAssociationArn(fileSystemAssociationArn: String): FluentBuilder = apply { this.fileSystemAssociationArn = fileSystemAssociationArn }
        override fun forceDelete(forceDelete: Boolean): FluentBuilder = apply { this.forceDelete = forceDelete }
    }
}
