// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Lists iSCSI information about a VTL device.
 */
class DeviceiScsiAttributes private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether mutual CHAP is enabled for the iSCSI target.
     */
    val chapEnabled: Boolean = builder.chapEnabled
    /**
     * The network interface identifier of the VTL device.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The port used to communicate with iSCSI VTL device targets.
     */
    val networkInterfacePort: Int = builder.networkInterfacePort
    /**
     * Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified
     * name(iqn) of a tape drive or media changer target.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeviceiScsiAttributes = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceiScsiAttributes(")
        append("chapEnabled=$chapEnabled,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("networkInterfacePort=$networkInterfacePort,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = chapEnabled.hashCode()
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfacePort)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeviceiScsiAttributes

        if (chapEnabled != other.chapEnabled) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (networkInterfacePort != other.networkInterfacePort) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeviceiScsiAttributes = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeviceiScsiAttributes
        /**
         * Indicates whether mutual CHAP is enabled for the iSCSI target.
         */
        fun chapEnabled(chapEnabled: Boolean): FluentBuilder
        /**
         * The network interface identifier of the VTL device.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The port used to communicate with iSCSI VTL device targets.
         */
        fun networkInterfacePort(networkInterfacePort: Int): FluentBuilder
        /**
         * Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified
         * name(iqn) of a tape drive or media changer target.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether mutual CHAP is enabled for the iSCSI target.
         */
        var chapEnabled: Boolean
        /**
         * The network interface identifier of the VTL device.
         */
        var networkInterfaceId: String?
        /**
         * The port used to communicate with iSCSI VTL device targets.
         */
        var networkInterfacePort: Int
        /**
         * Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified
         * name(iqn) of a tape drive or media changer target.
         */
        var targetArn: String?

        fun build(): DeviceiScsiAttributes
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var chapEnabled: Boolean = false
        override var networkInterfaceId: String? = null
        override var networkInterfacePort: Int = 0
        override var targetArn: String? = null

        constructor(x: DeviceiScsiAttributes) : this() {
            this.chapEnabled = x.chapEnabled
            this.networkInterfaceId = x.networkInterfaceId
            this.networkInterfacePort = x.networkInterfacePort
            this.targetArn = x.targetArn
        }

        override fun build(): DeviceiScsiAttributes = DeviceiScsiAttributes(this)
        override fun chapEnabled(chapEnabled: Boolean): FluentBuilder = apply { this.chapEnabled = chapEnabled }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun networkInterfacePort(networkInterfacePort: Int): FluentBuilder = apply { this.networkInterfacePort = networkInterfacePort }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
