// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * DescribeVTLDevicesInput
 */
class DescribeVtlDevicesRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Specifies that the number of VTL devices described be limited to the specified
     * number.
     */
    val limit: Int? = builder.limit
    /**
     * An opaque string that indicates the position at which to begin describing the VTL
     * devices.
     */
    val marker: String? = builder.marker
    /**
     * An array of strings, where each string represents the Amazon Resource Name (ARN) of a
     * VTL device.
     * All of the specified VTL devices must be from the same gateway. If no VTL devices are
     * specified, the result will contain all devices on the specified gateway.
     */
    val vtlDeviceArNs: List<String>? = builder.vtlDeviceArNs

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeVtlDevicesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVtlDevicesRequest(")
        append("gatewayArn=$gatewayArn,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("vtlDeviceArNs=$vtlDeviceArNs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (vtlDeviceArNs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeVtlDevicesRequest

        if (gatewayArn != other.gatewayArn) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (vtlDeviceArNs != other.vtlDeviceArNs) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeVtlDevicesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeVtlDevicesRequest
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Specifies that the number of VTL devices described be limited to the specified
         * number.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * An opaque string that indicates the position at which to begin describing the VTL
         * devices.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * An array of strings, where each string represents the Amazon Resource Name (ARN) of a
         * VTL device.
         * All of the specified VTL devices must be from the same gateway. If no VTL devices are
         * specified, the result will contain all devices on the specified gateway.
         */
        fun vtlDeviceArNs(vtlDeviceArNs: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Specifies that the number of VTL devices described be limited to the specified
         * number.
         */
        var limit: Int?
        /**
         * An opaque string that indicates the position at which to begin describing the VTL
         * devices.
         */
        var marker: String?
        /**
         * An array of strings, where each string represents the Amazon Resource Name (ARN) of a
         * VTL device.
         * All of the specified VTL devices must be from the same gateway. If no VTL devices are
         * specified, the result will contain all devices on the specified gateway.
         */
        var vtlDeviceArNs: List<String>?

        fun build(): DescribeVtlDevicesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null
        override var limit: Int? = null
        override var marker: String? = null
        override var vtlDeviceArNs: List<String>? = null

        constructor(x: DescribeVtlDevicesRequest) : this() {
            this.gatewayArn = x.gatewayArn
            this.limit = x.limit
            this.marker = x.marker
            this.vtlDeviceArNs = x.vtlDeviceArNs
        }

        override fun build(): DescribeVtlDevicesRequest = DescribeVtlDevicesRequest(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun vtlDeviceArNs(vtlDeviceArNs: List<String>): FluentBuilder = apply { this.vtlDeviceArNs = vtlDeviceArNs }
    }
}
