// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * DescribeTapesInput
 */
class DescribeTapesRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Specifies that the number of virtual tapes described be limited to the specified
     * number.
     * Amazon Web Services may impose its own limit, if this field is not set.
     */
    val limit: Int? = builder.limit
    /**
     * A marker value, obtained in a previous call to DescribeTapes. This marker
     * indicates which page of results to retrieve.
     * If not specified, the first page of results is retrieved.
     */
    val marker: String? = builder.marker
    /**
     * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
     * tapes you want to describe. If this parameter is not specified, Tape gateway returns a
     * description of all virtual tapes associated with the specified gateway.
     */
    val tapeArNs: List<String>? = builder.tapeArNs

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeTapesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTapesRequest(")
        append("gatewayArn=$gatewayArn,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("tapeArNs=$tapeArNs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (tapeArNs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeTapesRequest

        if (gatewayArn != other.gatewayArn) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (tapeArNs != other.tapeArNs) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeTapesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeTapesRequest
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Specifies that the number of virtual tapes described be limited to the specified
         * number.
         * Amazon Web Services may impose its own limit, if this field is not set.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * A marker value, obtained in a previous call to DescribeTapes. This marker
         * indicates which page of results to retrieve.
         * If not specified, the first page of results is retrieved.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
         * tapes you want to describe. If this parameter is not specified, Tape gateway returns a
         * description of all virtual tapes associated with the specified gateway.
         */
        fun tapeArNs(tapeArNs: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Specifies that the number of virtual tapes described be limited to the specified
         * number.
         * Amazon Web Services may impose its own limit, if this field is not set.
         */
        var limit: Int?
        /**
         * A marker value, obtained in a previous call to DescribeTapes. This marker
         * indicates which page of results to retrieve.
         * If not specified, the first page of results is retrieved.
         */
        var marker: String?
        /**
         * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual
         * tapes you want to describe. If this parameter is not specified, Tape gateway returns a
         * description of all virtual tapes associated with the specified gateway.
         */
        var tapeArNs: List<String>?

        fun build(): DescribeTapesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null
        override var limit: Int? = null
        override var marker: String? = null
        override var tapeArNs: List<String>? = null

        constructor(x: DescribeTapesRequest) : this() {
            this.gatewayArn = x.gatewayArn
            this.limit = x.limit
            this.marker = x.marker
            this.tapeArNs = x.tapeArNs
        }

        override fun build(): DescribeTapesRequest = DescribeTapesRequest(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun tapeArNs(tapeArNs: List<String>): FluentBuilder = apply { this.tapeArNs = tapeArNs }
    }
}
