// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class DescribeSnapshotScheduleResponse private constructor(builder: BuilderImpl) {
    /**
     * The snapshot description.
     */
    val description: String? = builder.description
    /**
     * The number of hours between snapshots.
     */
    val recurrenceInHours: Int? = builder.recurrenceInHours
    /**
     * The hour of the day at which the snapshot schedule begins represented as
     * hh, where hh is the hour (0 to 23). The hour
     * of the day is in the time zone of the gateway.
     */
    val startAt: Int? = builder.startAt
    /**
     * A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key
     * name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
     * view all tags using the ListTagsForResource API operation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A value that indicates the time zone of the gateway.
     */
    val timezone: String? = builder.timezone
    /**
     * The Amazon Resource Name (ARN) of the volume that was specified in the request.
     */
    val volumeArn: String? = builder.volumeArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSnapshotScheduleResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSnapshotScheduleResponse(")
        append("description=$description,")
        append("recurrenceInHours=$recurrenceInHours,")
        append("startAt=$startAt,")
        append("tags=$tags,")
        append("timezone=$timezone,")
        append("volumeArn=$volumeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (recurrenceInHours ?: 0)
        result = 31 * result + (startAt ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSnapshotScheduleResponse

        if (description != other.description) return false
        if (recurrenceInHours != other.recurrenceInHours) return false
        if (startAt != other.startAt) return false
        if (tags != other.tags) return false
        if (timezone != other.timezone) return false
        if (volumeArn != other.volumeArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSnapshotScheduleResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSnapshotScheduleResponse
        /**
         * The snapshot description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The number of hours between snapshots.
         */
        fun recurrenceInHours(recurrenceInHours: Int): FluentBuilder
        /**
         * The hour of the day at which the snapshot schedule begins represented as
         * hh, where hh is the hour (0 to 23). The hour
         * of the day is in the time zone of the gateway.
         */
        fun startAt(startAt: Int): FluentBuilder
        /**
         * A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key
         * name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
         * view all tags using the ListTagsForResource API operation.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * A value that indicates the time zone of the gateway.
         */
        fun timezone(timezone: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the volume that was specified in the request.
         */
        fun volumeArn(volumeArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The snapshot description.
         */
        var description: String?
        /**
         * The number of hours between snapshots.
         */
        var recurrenceInHours: Int?
        /**
         * The hour of the day at which the snapshot schedule begins represented as
         * hh, where hh is the hour (0 to 23). The hour
         * of the day is in the time zone of the gateway.
         */
        var startAt: Int?
        /**
         * A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key
         * name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can
         * view all tags using the ListTagsForResource API operation.
         */
        var tags: List<Tag>?
        /**
         * A value that indicates the time zone of the gateway.
         */
        var timezone: String?
        /**
         * The Amazon Resource Name (ARN) of the volume that was specified in the request.
         */
        var volumeArn: String?

        fun build(): DescribeSnapshotScheduleResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var recurrenceInHours: Int? = null
        override var startAt: Int? = null
        override var tags: List<Tag>? = null
        override var timezone: String? = null
        override var volumeArn: String? = null

        constructor(x: DescribeSnapshotScheduleResponse) : this() {
            this.description = x.description
            this.recurrenceInHours = x.recurrenceInHours
            this.startAt = x.startAt
            this.tags = x.tags
            this.timezone = x.timezone
            this.volumeArn = x.volumeArn
        }

        override fun build(): DescribeSnapshotScheduleResponse = DescribeSnapshotScheduleResponse(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun recurrenceInHours(recurrenceInHours: Int): FluentBuilder = apply { this.recurrenceInHours = recurrenceInHours }
        override fun startAt(startAt: Int): FluentBuilder = apply { this.startAt = startAt }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun timezone(timezone: String): FluentBuilder = apply { this.timezone = timezone }
        override fun volumeArn(volumeArn: String): FluentBuilder = apply { this.volumeArn = volumeArn }
    }
}
