// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class DescribeSmbSettingsResponse private constructor(builder: BuilderImpl) {
    /**
     * Indicates the status of a gateway that is a member of the Active Directory
     * domain.
     * ACCESS_DENIED: Indicates that the JoinDomain operation
     * failed due to an authentication error.
     * DETACHED: Indicates that gateway is not joined to a domain.
     * JOINED: Indicates that the gateway has successfully joined a
     * domain.
     * JOINING: Indicates that a JoinDomain operation is in
     * progress.
     * NETWORK_ERROR: Indicates that JoinDomain operation
     * failed due to a network or connectivity error.
     * TIMEOUT: Indicates that the JoinDomain operation failed
     * because the operation didn't complete within the allotted time.
     * UNKNOWN_ERROR: Indicates that the JoinDomain operation
     * failed due to another type of error.
     */
    val activeDirectoryStatus: ActiveDirectoryStatus? = builder.activeDirectoryStatus
    /**
     * The name of the domain that the gateway is joined to.
     */
    val domainName: String? = builder.domainName
    /**
     * The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
     */
    val fileSharesVisible: Boolean? = builder.fileSharesVisible
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * This value is true if a password for the guest user smbguest
     * is set, otherwise false. Only supported for S3 File Gateways.
     * Valid Values: true | false
     */
    val smbGuestPasswordSet: Boolean? = builder.smbGuestPasswordSet
    /**
     * The type of security strategy that was specified for file gateway.
     * ClientSpecified: If you use this option, requests are established
     * based on what is negotiated by the client. This option is recommended when you want
     * to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.
     * MandatorySigning: If you use this option, file gateway only allows
     * connections from SMBv2 or SMBv3 clients that have signing enabled. This option works
     * with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.
     * MandatoryEncryption: If you use this option, file gateway only allows
     * connections from SMBv3 clients that have encryption enabled. This option is highly
     * recommended for environments that handle sensitive data. This option works with SMB
     * clients on Microsoft Windows 8, Windows Server 2012 or newer.
     */
    val smbSecurityStrategy: SmbSecurityStrategy? = builder.smbSecurityStrategy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSmbSettingsResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSmbSettingsResponse(")
        append("activeDirectoryStatus=$activeDirectoryStatus,")
        append("domainName=$domainName,")
        append("fileSharesVisible=$fileSharesVisible,")
        append("gatewayArn=$gatewayArn,")
        append("smbGuestPasswordSet=$smbGuestPasswordSet,")
        append("smbSecurityStrategy=$smbSecurityStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryStatus?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (fileSharesVisible?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (smbGuestPasswordSet?.hashCode() ?: 0)
        result = 31 * result + (smbSecurityStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSmbSettingsResponse

        if (activeDirectoryStatus != other.activeDirectoryStatus) return false
        if (domainName != other.domainName) return false
        if (fileSharesVisible != other.fileSharesVisible) return false
        if (gatewayArn != other.gatewayArn) return false
        if (smbGuestPasswordSet != other.smbGuestPasswordSet) return false
        if (smbSecurityStrategy != other.smbSecurityStrategy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSmbSettingsResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSmbSettingsResponse
        /**
         * Indicates the status of a gateway that is a member of the Active Directory
         * domain.
         * ACCESS_DENIED: Indicates that the JoinDomain operation
         * failed due to an authentication error.
         * DETACHED: Indicates that gateway is not joined to a domain.
         * JOINED: Indicates that the gateway has successfully joined a
         * domain.
         * JOINING: Indicates that a JoinDomain operation is in
         * progress.
         * NETWORK_ERROR: Indicates that JoinDomain operation
         * failed due to a network or connectivity error.
         * TIMEOUT: Indicates that the JoinDomain operation failed
         * because the operation didn't complete within the allotted time.
         * UNKNOWN_ERROR: Indicates that the JoinDomain operation
         * failed due to another type of error.
         */
        fun activeDirectoryStatus(activeDirectoryStatus: ActiveDirectoryStatus): FluentBuilder
        /**
         * The name of the domain that the gateway is joined to.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
         */
        fun fileSharesVisible(fileSharesVisible: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * This value is true if a password for the guest user smbguest
         * is set, otherwise false. Only supported for S3 File Gateways.
         * Valid Values: true | false
         */
        fun smbGuestPasswordSet(smbGuestPasswordSet: Boolean): FluentBuilder
        /**
         * The type of security strategy that was specified for file gateway.
         * ClientSpecified: If you use this option, requests are established
         * based on what is negotiated by the client. This option is recommended when you want
         * to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.
         * MandatorySigning: If you use this option, file gateway only allows
         * connections from SMBv2 or SMBv3 clients that have signing enabled. This option works
         * with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.
         * MandatoryEncryption: If you use this option, file gateway only allows
         * connections from SMBv3 clients that have encryption enabled. This option is highly
         * recommended for environments that handle sensitive data. This option works with SMB
         * clients on Microsoft Windows 8, Windows Server 2012 or newer.
         */
        fun smbSecurityStrategy(smbSecurityStrategy: SmbSecurityStrategy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates the status of a gateway that is a member of the Active Directory
         * domain.
         * ACCESS_DENIED: Indicates that the JoinDomain operation
         * failed due to an authentication error.
         * DETACHED: Indicates that gateway is not joined to a domain.
         * JOINED: Indicates that the gateway has successfully joined a
         * domain.
         * JOINING: Indicates that a JoinDomain operation is in
         * progress.
         * NETWORK_ERROR: Indicates that JoinDomain operation
         * failed due to a network or connectivity error.
         * TIMEOUT: Indicates that the JoinDomain operation failed
         * because the operation didn't complete within the allotted time.
         * UNKNOWN_ERROR: Indicates that the JoinDomain operation
         * failed due to another type of error.
         */
        var activeDirectoryStatus: ActiveDirectoryStatus?
        /**
         * The name of the domain that the gateway is joined to.
         */
        var domainName: String?
        /**
         * The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
         */
        var fileSharesVisible: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * This value is true if a password for the guest user smbguest
         * is set, otherwise false. Only supported for S3 File Gateways.
         * Valid Values: true | false
         */
        var smbGuestPasswordSet: Boolean?
        /**
         * The type of security strategy that was specified for file gateway.
         * ClientSpecified: If you use this option, requests are established
         * based on what is negotiated by the client. This option is recommended when you want
         * to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.
         * MandatorySigning: If you use this option, file gateway only allows
         * connections from SMBv2 or SMBv3 clients that have signing enabled. This option works
         * with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.
         * MandatoryEncryption: If you use this option, file gateway only allows
         * connections from SMBv3 clients that have encryption enabled. This option is highly
         * recommended for environments that handle sensitive data. This option works with SMB
         * clients on Microsoft Windows 8, Windows Server 2012 or newer.
         */
        var smbSecurityStrategy: SmbSecurityStrategy?

        fun build(): DescribeSmbSettingsResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activeDirectoryStatus: ActiveDirectoryStatus? = null
        override var domainName: String? = null
        override var fileSharesVisible: Boolean? = null
        override var gatewayArn: String? = null
        override var smbGuestPasswordSet: Boolean? = null
        override var smbSecurityStrategy: SmbSecurityStrategy? = null

        constructor(x: DescribeSmbSettingsResponse) : this() {
            this.activeDirectoryStatus = x.activeDirectoryStatus
            this.domainName = x.domainName
            this.fileSharesVisible = x.fileSharesVisible
            this.gatewayArn = x.gatewayArn
            this.smbGuestPasswordSet = x.smbGuestPasswordSet
            this.smbSecurityStrategy = x.smbSecurityStrategy
        }

        override fun build(): DescribeSmbSettingsResponse = DescribeSmbSettingsResponse(this)
        override fun activeDirectoryStatus(activeDirectoryStatus: ActiveDirectoryStatus): FluentBuilder = apply { this.activeDirectoryStatus = activeDirectoryStatus }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun fileSharesVisible(fileSharesVisible: Boolean): FluentBuilder = apply { this.fileSharesVisible = fileSharesVisible }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun smbGuestPasswordSet(smbGuestPasswordSet: Boolean): FluentBuilder = apply { this.smbGuestPasswordSet = smbGuestPasswordSet }
        override fun smbSecurityStrategy(smbSecurityStrategy: SmbSecurityStrategy): FluentBuilder = apply { this.smbSecurityStrategy = smbSecurityStrategy }
    }
}
