// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * A JSON object containing the following fields:
 * DescribeMaintenanceStartTimeOutput$DayOfMonth
 * DescribeMaintenanceStartTimeOutput$DayOfWeek
 * DescribeMaintenanceStartTimeOutput$HourOfDay
 * DescribeMaintenanceStartTimeOutput$MinuteOfHour
 * DescribeMaintenanceStartTimeOutput$Timezone
 */
class DescribeMaintenanceStartTimeResponse private constructor(builder: BuilderImpl) {
    /**
     * The day of the month component of the maintenance start time represented as an ordinal
     * number from 1 to 28, where 1 represents the first day of the month and 28 represents the
     * last day of the month.
     */
    val dayOfMonth: Int? = builder.dayOfMonth
    /**
     * An ordinal number between 0 and 6 that represents the day of the week, where 0
     * represents Sunday and 6 represents Saturday. The day of week is in the time zone of the
     * gateway.
     */
    val dayOfWeek: Int? = builder.dayOfWeek
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The hour component of the maintenance start time represented as hh,
     * where hh is the hour (0 to 23). The hour of the day is in the time
     * zone of the gateway.
     */
    val hourOfDay: Int? = builder.hourOfDay
    /**
     * The minute component of the maintenance start time represented as
     * mm, where mm is the minute (0 to 59). The
     * minute of the hour is in the time zone of the gateway.
     */
    val minuteOfHour: Int? = builder.minuteOfHour
    /**
     * A value that indicates the time zone that is set for the gateway. The start time and day
     * of week specified should be in the time zone of the gateway.
     */
    val timezone: String? = builder.timezone

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeMaintenanceStartTimeResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeMaintenanceStartTimeResponse(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("gatewayArn=$gatewayArn,")
        append("hourOfDay=$hourOfDay,")
        append("minuteOfHour=$minuteOfHour,")
        append("timezone=$timezone)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth ?: 0
        result = 31 * result + (dayOfWeek ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (hourOfDay ?: 0)
        result = 31 * result + (minuteOfHour ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeMaintenanceStartTimeResponse

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (gatewayArn != other.gatewayArn) return false
        if (hourOfDay != other.hourOfDay) return false
        if (minuteOfHour != other.minuteOfHour) return false
        if (timezone != other.timezone) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeMaintenanceStartTimeResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeMaintenanceStartTimeResponse
        /**
         * The day of the month component of the maintenance start time represented as an ordinal
         * number from 1 to 28, where 1 represents the first day of the month and 28 represents the
         * last day of the month.
         */
        fun dayOfMonth(dayOfMonth: Int): FluentBuilder
        /**
         * An ordinal number between 0 and 6 that represents the day of the week, where 0
         * represents Sunday and 6 represents Saturday. The day of week is in the time zone of the
         * gateway.
         */
        fun dayOfWeek(dayOfWeek: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The hour component of the maintenance start time represented as hh,
         * where hh is the hour (0 to 23). The hour of the day is in the time
         * zone of the gateway.
         */
        fun hourOfDay(hourOfDay: Int): FluentBuilder
        /**
         * The minute component of the maintenance start time represented as
         * mm, where mm is the minute (0 to 59). The
         * minute of the hour is in the time zone of the gateway.
         */
        fun minuteOfHour(minuteOfHour: Int): FluentBuilder
        /**
         * A value that indicates the time zone that is set for the gateway. The start time and day
         * of week specified should be in the time zone of the gateway.
         */
        fun timezone(timezone: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The day of the month component of the maintenance start time represented as an ordinal
         * number from 1 to 28, where 1 represents the first day of the month and 28 represents the
         * last day of the month.
         */
        var dayOfMonth: Int?
        /**
         * An ordinal number between 0 and 6 that represents the day of the week, where 0
         * represents Sunday and 6 represents Saturday. The day of week is in the time zone of the
         * gateway.
         */
        var dayOfWeek: Int?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The hour component of the maintenance start time represented as hh,
         * where hh is the hour (0 to 23). The hour of the day is in the time
         * zone of the gateway.
         */
        var hourOfDay: Int?
        /**
         * The minute component of the maintenance start time represented as
         * mm, where mm is the minute (0 to 59). The
         * minute of the hour is in the time zone of the gateway.
         */
        var minuteOfHour: Int?
        /**
         * A value that indicates the time zone that is set for the gateway. The start time and day
         * of week specified should be in the time zone of the gateway.
         */
        var timezone: String?

        fun build(): DescribeMaintenanceStartTimeResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dayOfMonth: Int? = null
        override var dayOfWeek: Int? = null
        override var gatewayArn: String? = null
        override var hourOfDay: Int? = null
        override var minuteOfHour: Int? = null
        override var timezone: String? = null

        constructor(x: DescribeMaintenanceStartTimeResponse) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.gatewayArn = x.gatewayArn
            this.hourOfDay = x.hourOfDay
            this.minuteOfHour = x.minuteOfHour
            this.timezone = x.timezone
        }

        override fun build(): DescribeMaintenanceStartTimeResponse = DescribeMaintenanceStartTimeResponse(this)
        override fun dayOfMonth(dayOfMonth: Int): FluentBuilder = apply { this.dayOfMonth = dayOfMonth }
        override fun dayOfWeek(dayOfWeek: Int): FluentBuilder = apply { this.dayOfWeek = dayOfWeek }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun hourOfDay(hourOfDay: Int): FluentBuilder = apply { this.hourOfDay = hourOfDay }
        override fun minuteOfHour(minuteOfHour: Int): FluentBuilder = apply { this.minuteOfHour = minuteOfHour }
        override fun timezone(timezone: String): FluentBuilder = apply { this.timezone = timezone }
    }
}
