// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * A JSON object containing the following fields:
 */
class DescribeGatewayInformationResponse private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to
     * monitor events in the gateway.
     */
    val cloudWatchLogGroupArn: String? = builder.cloudWatchLogGroupArn
    /**
     * Date after which this gateway will not receive software updates for new features and bug
     * fixes.
     */
    val deprecationDate: String? = builder.deprecationDate
    /**
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    val ec2InstanceId: String? = builder.ec2InstanceId
    /**
     * The Region where the Amazon EC2 instance is located.
     */
    val ec2InstanceRegion: String? = builder.ec2InstanceRegion
    /**
     * The type of endpoint for your gateway.
     * Valid Values: STANDARD | FIPS
     */
    val endpointType: String? = builder.endpointType
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Specifies the size of the gateway's metadata cache.
     */
    val gatewayCapacity: GatewayCapacity? = builder.gatewayCapacity
    /**
     * The unique identifier assigned to your gateway during activation. This ID becomes part
     * of the gateway Amazon Resource Name (ARN), which you use as input for other
     * operations.
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * The name you configured for your gateway.
     */
    val gatewayName: String? = builder.gatewayName
    /**
     * A NetworkInterface array that contains descriptions of the gateway
     * network interfaces.
     */
    val gatewayNetworkInterfaces: List<NetworkInterface>? = builder.gatewayNetworkInterfaces
    /**
     * A value that indicates the operating state of the gateway.
     */
    val gatewayState: String? = builder.gatewayState
    /**
     * A value that indicates the time zone configured for the gateway.
     */
    val gatewayTimezone: String? = builder.gatewayTimezone
    /**
     * The type of the gateway.
     */
    val gatewayType: String? = builder.gatewayType
    /**
     * The type of hypervisor environment used by the host.
     */
    val hostEnvironment: HostEnvironment? = builder.hostEnvironment
    /**
     * The date on which the last software update was applied to the gateway. If the gateway
     * has never been updated, this field does not return a value in the response.
     */
    val lastSoftwareUpdate: String? = builder.lastSoftwareUpdate
    /**
     * The date on which an update to the gateway is available. This date is in the time zone
     * of the gateway. If the gateway is not available for an update this field is not returned in
     * the response.
     */
    val nextUpdateAvailabilityDate: String? = builder.nextUpdateAvailabilityDate
    /**
     * Date after which this gateway will not receive software updates for new features.
     */
    val softwareUpdatesEndDate: String? = builder.softwareUpdatesEndDate
    /**
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     */
    val supportedGatewayCapacities: List<GatewayCapacity>? = builder.supportedGatewayCapacities
    /**
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each
     * tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all
     * tags using the ListTagsForResource API operation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The configuration settings for the virtual private cloud (VPC) endpoint for your
     * gateway.
     */
    val vpcEndpoint: String? = builder.vpcEndpoint

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeGatewayInformationResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGatewayInformationResponse(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("deprecationDate=$deprecationDate,")
        append("ec2InstanceId=$ec2InstanceId,")
        append("ec2InstanceRegion=$ec2InstanceRegion,")
        append("endpointType=$endpointType,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayCapacity=$gatewayCapacity,")
        append("gatewayId=$gatewayId,")
        append("gatewayName=$gatewayName,")
        append("gatewayNetworkInterfaces=$gatewayNetworkInterfaces,")
        append("gatewayState=$gatewayState,")
        append("gatewayTimezone=$gatewayTimezone,")
        append("gatewayType=$gatewayType,")
        append("hostEnvironment=$hostEnvironment,")
        append("lastSoftwareUpdate=$lastSoftwareUpdate,")
        append("nextUpdateAvailabilityDate=$nextUpdateAvailabilityDate,")
        append("softwareUpdatesEndDate=$softwareUpdatesEndDate,")
        append("supportedGatewayCapacities=$supportedGatewayCapacities,")
        append("tags=$tags,")
        append("vpcEndpoint=$vpcEndpoint)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (deprecationDate?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceId?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceRegion?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayCapacity?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayNetworkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (gatewayState?.hashCode() ?: 0)
        result = 31 * result + (gatewayTimezone?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (hostEnvironment?.hashCode() ?: 0)
        result = 31 * result + (lastSoftwareUpdate?.hashCode() ?: 0)
        result = 31 * result + (nextUpdateAvailabilityDate?.hashCode() ?: 0)
        result = 31 * result + (softwareUpdatesEndDate?.hashCode() ?: 0)
        result = 31 * result + (supportedGatewayCapacities?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeGatewayInformationResponse

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (deprecationDate != other.deprecationDate) return false
        if (ec2InstanceId != other.ec2InstanceId) return false
        if (ec2InstanceRegion != other.ec2InstanceRegion) return false
        if (endpointType != other.endpointType) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayCapacity != other.gatewayCapacity) return false
        if (gatewayId != other.gatewayId) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayNetworkInterfaces != other.gatewayNetworkInterfaces) return false
        if (gatewayState != other.gatewayState) return false
        if (gatewayTimezone != other.gatewayTimezone) return false
        if (gatewayType != other.gatewayType) return false
        if (hostEnvironment != other.hostEnvironment) return false
        if (lastSoftwareUpdate != other.lastSoftwareUpdate) return false
        if (nextUpdateAvailabilityDate != other.nextUpdateAvailabilityDate) return false
        if (softwareUpdatesEndDate != other.softwareUpdatesEndDate) return false
        if (supportedGatewayCapacities != other.supportedGatewayCapacities) return false
        if (tags != other.tags) return false
        if (vpcEndpoint != other.vpcEndpoint) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeGatewayInformationResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeGatewayInformationResponse
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to
         * monitor events in the gateway.
         */
        fun cloudWatchLogGroupArn(cloudWatchLogGroupArn: String): FluentBuilder
        /**
         * Date after which this gateway will not receive software updates for new features and bug
         * fixes.
         */
        fun deprecationDate(deprecationDate: String): FluentBuilder
        /**
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         */
        fun ec2InstanceId(ec2InstanceId: String): FluentBuilder
        /**
         * The Region where the Amazon EC2 instance is located.
         */
        fun ec2InstanceRegion(ec2InstanceRegion: String): FluentBuilder
        /**
         * The type of endpoint for your gateway.
         * Valid Values: STANDARD | FIPS
         */
        fun endpointType(endpointType: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Specifies the size of the gateway's metadata cache.
         */
        fun gatewayCapacity(gatewayCapacity: GatewayCapacity): FluentBuilder
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part
         * of the gateway Amazon Resource Name (ARN), which you use as input for other
         * operations.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * The name you configured for your gateway.
         */
        fun gatewayName(gatewayName: String): FluentBuilder
        /**
         * A NetworkInterface array that contains descriptions of the gateway
         * network interfaces.
         */
        fun gatewayNetworkInterfaces(gatewayNetworkInterfaces: List<NetworkInterface>): FluentBuilder
        /**
         * A value that indicates the operating state of the gateway.
         */
        fun gatewayState(gatewayState: String): FluentBuilder
        /**
         * A value that indicates the time zone configured for the gateway.
         */
        fun gatewayTimezone(gatewayTimezone: String): FluentBuilder
        /**
         * The type of the gateway.
         */
        fun gatewayType(gatewayType: String): FluentBuilder
        /**
         * The type of hypervisor environment used by the host.
         */
        fun hostEnvironment(hostEnvironment: HostEnvironment): FluentBuilder
        /**
         * The date on which the last software update was applied to the gateway. If the gateway
         * has never been updated, this field does not return a value in the response.
         */
        fun lastSoftwareUpdate(lastSoftwareUpdate: String): FluentBuilder
        /**
         * The date on which an update to the gateway is available. This date is in the time zone
         * of the gateway. If the gateway is not available for an update this field is not returned in
         * the response.
         */
        fun nextUpdateAvailabilityDate(nextUpdateAvailabilityDate: String): FluentBuilder
        /**
         * Date after which this gateway will not receive software updates for new features.
         */
        fun softwareUpdatesEndDate(softwareUpdatesEndDate: String): FluentBuilder
        /**
         * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
         */
        fun supportedGatewayCapacities(supportedGatewayCapacities: List<GatewayCapacity>): FluentBuilder
        /**
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each
         * tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all
         * tags using the ListTagsForResource API operation.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The configuration settings for the virtual private cloud (VPC) endpoint for your
         * gateway.
         */
        fun vpcEndpoint(vpcEndpoint: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to
         * monitor events in the gateway.
         */
        var cloudWatchLogGroupArn: String?
        /**
         * Date after which this gateway will not receive software updates for new features and bug
         * fixes.
         */
        var deprecationDate: String?
        /**
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         */
        var ec2InstanceId: String?
        /**
         * The Region where the Amazon EC2 instance is located.
         */
        var ec2InstanceRegion: String?
        /**
         * The type of endpoint for your gateway.
         * Valid Values: STANDARD | FIPS
         */
        var endpointType: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Specifies the size of the gateway's metadata cache.
         */
        var gatewayCapacity: GatewayCapacity?
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part
         * of the gateway Amazon Resource Name (ARN), which you use as input for other
         * operations.
         */
        var gatewayId: String?
        /**
         * The name you configured for your gateway.
         */
        var gatewayName: String?
        /**
         * A NetworkInterface array that contains descriptions of the gateway
         * network interfaces.
         */
        var gatewayNetworkInterfaces: List<NetworkInterface>?
        /**
         * A value that indicates the operating state of the gateway.
         */
        var gatewayState: String?
        /**
         * A value that indicates the time zone configured for the gateway.
         */
        var gatewayTimezone: String?
        /**
         * The type of the gateway.
         */
        var gatewayType: String?
        /**
         * The type of hypervisor environment used by the host.
         */
        var hostEnvironment: HostEnvironment?
        /**
         * The date on which the last software update was applied to the gateway. If the gateway
         * has never been updated, this field does not return a value in the response.
         */
        var lastSoftwareUpdate: String?
        /**
         * The date on which an update to the gateway is available. This date is in the time zone
         * of the gateway. If the gateway is not available for an update this field is not returned in
         * the response.
         */
        var nextUpdateAvailabilityDate: String?
        /**
         * Date after which this gateway will not receive software updates for new features.
         */
        var softwareUpdatesEndDate: String?
        /**
         * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
         */
        var supportedGatewayCapacities: List<GatewayCapacity>?
        /**
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each
         * tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all
         * tags using the ListTagsForResource API operation.
         */
        var tags: List<Tag>?
        /**
         * The configuration settings for the virtual private cloud (VPC) endpoint for your
         * gateway.
         */
        var vpcEndpoint: String?

        fun build(): DescribeGatewayInformationResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cloudWatchLogGroupArn: String? = null
        override var deprecationDate: String? = null
        override var ec2InstanceId: String? = null
        override var ec2InstanceRegion: String? = null
        override var endpointType: String? = null
        override var gatewayArn: String? = null
        override var gatewayCapacity: GatewayCapacity? = null
        override var gatewayId: String? = null
        override var gatewayName: String? = null
        override var gatewayNetworkInterfaces: List<NetworkInterface>? = null
        override var gatewayState: String? = null
        override var gatewayTimezone: String? = null
        override var gatewayType: String? = null
        override var hostEnvironment: HostEnvironment? = null
        override var lastSoftwareUpdate: String? = null
        override var nextUpdateAvailabilityDate: String? = null
        override var softwareUpdatesEndDate: String? = null
        override var supportedGatewayCapacities: List<GatewayCapacity>? = null
        override var tags: List<Tag>? = null
        override var vpcEndpoint: String? = null

        constructor(x: DescribeGatewayInformationResponse) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.deprecationDate = x.deprecationDate
            this.ec2InstanceId = x.ec2InstanceId
            this.ec2InstanceRegion = x.ec2InstanceRegion
            this.endpointType = x.endpointType
            this.gatewayArn = x.gatewayArn
            this.gatewayCapacity = x.gatewayCapacity
            this.gatewayId = x.gatewayId
            this.gatewayName = x.gatewayName
            this.gatewayNetworkInterfaces = x.gatewayNetworkInterfaces
            this.gatewayState = x.gatewayState
            this.gatewayTimezone = x.gatewayTimezone
            this.gatewayType = x.gatewayType
            this.hostEnvironment = x.hostEnvironment
            this.lastSoftwareUpdate = x.lastSoftwareUpdate
            this.nextUpdateAvailabilityDate = x.nextUpdateAvailabilityDate
            this.softwareUpdatesEndDate = x.softwareUpdatesEndDate
            this.supportedGatewayCapacities = x.supportedGatewayCapacities
            this.tags = x.tags
            this.vpcEndpoint = x.vpcEndpoint
        }

        override fun build(): DescribeGatewayInformationResponse = DescribeGatewayInformationResponse(this)
        override fun cloudWatchLogGroupArn(cloudWatchLogGroupArn: String): FluentBuilder = apply { this.cloudWatchLogGroupArn = cloudWatchLogGroupArn }
        override fun deprecationDate(deprecationDate: String): FluentBuilder = apply { this.deprecationDate = deprecationDate }
        override fun ec2InstanceId(ec2InstanceId: String): FluentBuilder = apply { this.ec2InstanceId = ec2InstanceId }
        override fun ec2InstanceRegion(ec2InstanceRegion: String): FluentBuilder = apply { this.ec2InstanceRegion = ec2InstanceRegion }
        override fun endpointType(endpointType: String): FluentBuilder = apply { this.endpointType = endpointType }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun gatewayCapacity(gatewayCapacity: GatewayCapacity): FluentBuilder = apply { this.gatewayCapacity = gatewayCapacity }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun gatewayName(gatewayName: String): FluentBuilder = apply { this.gatewayName = gatewayName }
        override fun gatewayNetworkInterfaces(gatewayNetworkInterfaces: List<NetworkInterface>): FluentBuilder = apply { this.gatewayNetworkInterfaces = gatewayNetworkInterfaces }
        override fun gatewayState(gatewayState: String): FluentBuilder = apply { this.gatewayState = gatewayState }
        override fun gatewayTimezone(gatewayTimezone: String): FluentBuilder = apply { this.gatewayTimezone = gatewayTimezone }
        override fun gatewayType(gatewayType: String): FluentBuilder = apply { this.gatewayType = gatewayType }
        override fun hostEnvironment(hostEnvironment: HostEnvironment): FluentBuilder = apply { this.hostEnvironment = hostEnvironment }
        override fun lastSoftwareUpdate(lastSoftwareUpdate: String): FluentBuilder = apply { this.lastSoftwareUpdate = lastSoftwareUpdate }
        override fun nextUpdateAvailabilityDate(nextUpdateAvailabilityDate: String): FluentBuilder = apply { this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate }
        override fun softwareUpdatesEndDate(softwareUpdatesEndDate: String): FluentBuilder = apply { this.softwareUpdatesEndDate = softwareUpdatesEndDate }
        override fun supportedGatewayCapacities(supportedGatewayCapacities: List<GatewayCapacity>): FluentBuilder = apply { this.supportedGatewayCapacities = supportedGatewayCapacities }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcEndpoint(vpcEndpoint: String): FluentBuilder = apply { this.vpcEndpoint = vpcEndpoint }
    }
}
