// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class DescribeCacheResponse private constructor(builder: BuilderImpl) {
    /**
     * The amount of cache in bytes allocated to a gateway.
     */
    val cacheAllocatedInBytes: Long = builder.cacheAllocatedInBytes
    /**
     * The file share's contribution to the overall percentage of the gateway's cache
     * that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting
     * period.
     */
    val cacheDirtyPercentage: Double = builder.cacheDirtyPercentage
    /**
     * Percent of application read operations from the file shares that are served from cache.
     * The sample is taken at the end of the reporting period.
     */
    val cacheHitPercentage: Double = builder.cacheHitPercentage
    /**
     * Percent of application read operations from the file shares that are not served from
     * cache. The sample is taken at the end of the reporting period.
     */
    val cacheMissPercentage: Double = builder.cacheMissPercentage
    /**
     * Percent use of the gateway's cache storage. This metric applies only to the
     * gateway-cached volume setup. The sample is taken at the end of the reporting period.
     */
    val cacheUsedPercentage: Double = builder.cacheUsedPercentage
    /**
     * An array of strings that identify disks that are to be configured as working storage.
     * Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
     * from the ListLocalDisks API.
     */
    val diskIds: List<String>? = builder.diskIds
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeCacheResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCacheResponse(")
        append("cacheAllocatedInBytes=$cacheAllocatedInBytes,")
        append("cacheDirtyPercentage=$cacheDirtyPercentage,")
        append("cacheHitPercentage=$cacheHitPercentage,")
        append("cacheMissPercentage=$cacheMissPercentage,")
        append("cacheUsedPercentage=$cacheUsedPercentage,")
        append("diskIds=$diskIds,")
        append("gatewayArn=$gatewayArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheAllocatedInBytes.hashCode()
        result = 31 * result + (cacheDirtyPercentage.hashCode())
        result = 31 * result + (cacheHitPercentage.hashCode())
        result = 31 * result + (cacheMissPercentage.hashCode())
        result = 31 * result + (cacheUsedPercentage.hashCode())
        result = 31 * result + (diskIds?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeCacheResponse

        if (cacheAllocatedInBytes != other.cacheAllocatedInBytes) return false
        if (cacheDirtyPercentage != other.cacheDirtyPercentage) return false
        if (cacheHitPercentage != other.cacheHitPercentage) return false
        if (cacheMissPercentage != other.cacheMissPercentage) return false
        if (cacheUsedPercentage != other.cacheUsedPercentage) return false
        if (diskIds != other.diskIds) return false
        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeCacheResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeCacheResponse
        /**
         * The amount of cache in bytes allocated to a gateway.
         */
        fun cacheAllocatedInBytes(cacheAllocatedInBytes: Long): FluentBuilder
        /**
         * The file share's contribution to the overall percentage of the gateway's cache
         * that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting
         * period.
         */
        fun cacheDirtyPercentage(cacheDirtyPercentage: Double): FluentBuilder
        /**
         * Percent of application read operations from the file shares that are served from cache.
         * The sample is taken at the end of the reporting period.
         */
        fun cacheHitPercentage(cacheHitPercentage: Double): FluentBuilder
        /**
         * Percent of application read operations from the file shares that are not served from
         * cache. The sample is taken at the end of the reporting period.
         */
        fun cacheMissPercentage(cacheMissPercentage: Double): FluentBuilder
        /**
         * Percent use of the gateway's cache storage. This metric applies only to the
         * gateway-cached volume setup. The sample is taken at the end of the reporting period.
         */
        fun cacheUsedPercentage(cacheUsedPercentage: Double): FluentBuilder
        /**
         * An array of strings that identify disks that are to be configured as working storage.
         * Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
         * from the ListLocalDisks API.
         */
        fun diskIds(diskIds: List<String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The amount of cache in bytes allocated to a gateway.
         */
        var cacheAllocatedInBytes: Long
        /**
         * The file share's contribution to the overall percentage of the gateway's cache
         * that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting
         * period.
         */
        var cacheDirtyPercentage: Double
        /**
         * Percent of application read operations from the file shares that are served from cache.
         * The sample is taken at the end of the reporting period.
         */
        var cacheHitPercentage: Double
        /**
         * Percent of application read operations from the file shares that are not served from
         * cache. The sample is taken at the end of the reporting period.
         */
        var cacheMissPercentage: Double
        /**
         * Percent use of the gateway's cache storage. This metric applies only to the
         * gateway-cached volume setup. The sample is taken at the end of the reporting period.
         */
        var cacheUsedPercentage: Double
        /**
         * An array of strings that identify disks that are to be configured as working storage.
         * Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs
         * from the ListLocalDisks API.
         */
        var diskIds: List<String>?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?

        fun build(): DescribeCacheResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cacheAllocatedInBytes: Long = 0L
        override var cacheDirtyPercentage: Double = 0.0
        override var cacheHitPercentage: Double = 0.0
        override var cacheMissPercentage: Double = 0.0
        override var cacheUsedPercentage: Double = 0.0
        override var diskIds: List<String>? = null
        override var gatewayArn: String? = null

        constructor(x: DescribeCacheResponse) : this() {
            this.cacheAllocatedInBytes = x.cacheAllocatedInBytes
            this.cacheDirtyPercentage = x.cacheDirtyPercentage
            this.cacheHitPercentage = x.cacheHitPercentage
            this.cacheMissPercentage = x.cacheMissPercentage
            this.cacheUsedPercentage = x.cacheUsedPercentage
            this.diskIds = x.diskIds
            this.gatewayArn = x.gatewayArn
        }

        override fun build(): DescribeCacheResponse = DescribeCacheResponse(this)
        override fun cacheAllocatedInBytes(cacheAllocatedInBytes: Long): FluentBuilder = apply { this.cacheAllocatedInBytes = cacheAllocatedInBytes }
        override fun cacheDirtyPercentage(cacheDirtyPercentage: Double): FluentBuilder = apply { this.cacheDirtyPercentage = cacheDirtyPercentage }
        override fun cacheHitPercentage(cacheHitPercentage: Double): FluentBuilder = apply { this.cacheHitPercentage = cacheHitPercentage }
        override fun cacheMissPercentage(cacheMissPercentage: Double): FluentBuilder = apply { this.cacheMissPercentage = cacheMissPercentage }
        override fun cacheUsedPercentage(cacheUsedPercentage: Double): FluentBuilder = apply { this.cacheUsedPercentage = cacheUsedPercentage }
        override fun diskIds(diskIds: List<String>): FluentBuilder = apply { this.diskIds = diskIds }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
    }
}
