// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * DeleteTapeInput
 */
class DeleteTapeRequest private constructor(builder: BuilderImpl) {
    /**
     * Set to TRUE to delete an archived tape that belongs to a custom pool with
     * tape retention lock. Only archived tapes with tape retention lock set to
     * governance can be deleted. Archived tapes with tape retention lock set to
     * compliance can't be deleted.
     */
    val bypassGovernanceRetention: Boolean = builder.bypassGovernanceRetention
    /**
     * The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
     * associated with. Use the ListGateways operation to return a list of
     * gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The Amazon Resource Name (ARN) of the virtual tape to delete.
     */
    val tapeArn: String? = builder.tapeArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteTapeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteTapeRequest(")
        append("bypassGovernanceRetention=$bypassGovernanceRetention,")
        append("gatewayArn=$gatewayArn,")
        append("tapeArn=$tapeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassGovernanceRetention.hashCode()
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteTapeRequest

        if (bypassGovernanceRetention != other.bypassGovernanceRetention) return false
        if (gatewayArn != other.gatewayArn) return false
        if (tapeArn != other.tapeArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteTapeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteTapeRequest
        /**
         * Set to TRUE to delete an archived tape that belongs to a custom pool with
         * tape retention lock. Only archived tapes with tape retention lock set to
         * governance can be deleted. Archived tapes with tape retention lock set to
         * compliance can't be deleted.
         */
        fun bypassGovernanceRetention(bypassGovernanceRetention: Boolean): FluentBuilder
        /**
         * The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
         * associated with. Use the ListGateways operation to return a list of
         * gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the virtual tape to delete.
         */
        fun tapeArn(tapeArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Set to TRUE to delete an archived tape that belongs to a custom pool with
         * tape retention lock. Only archived tapes with tape retention lock set to
         * governance can be deleted. Archived tapes with tape retention lock set to
         * compliance can't be deleted.
         */
        var bypassGovernanceRetention: Boolean
        /**
         * The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is
         * associated with. Use the ListGateways operation to return a list of
         * gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The Amazon Resource Name (ARN) of the virtual tape to delete.
         */
        var tapeArn: String?

        fun build(): DeleteTapeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bypassGovernanceRetention: Boolean = false
        override var gatewayArn: String? = null
        override var tapeArn: String? = null

        constructor(x: DeleteTapeRequest) : this() {
            this.bypassGovernanceRetention = x.bypassGovernanceRetention
            this.gatewayArn = x.gatewayArn
            this.tapeArn = x.tapeArn
        }

        override fun build(): DeleteTapeRequest = DeleteTapeRequest(this)
        override fun bypassGovernanceRetention(bypassGovernanceRetention: Boolean): FluentBuilder = apply { this.bypassGovernanceRetention = bypassGovernanceRetention }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun tapeArn(tapeArn: String): FluentBuilder = apply { this.tapeArn = tapeArn }
    }
}
