// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * DeleteTapeArchiveInput
 */
class DeleteTapeArchiveRequest private constructor(builder: BuilderImpl) {
    /**
     * Set to TRUE to delete an archived tape that belongs to a custom pool with
     * tape retention lock. Only archived tapes with tape retention lock set to
     * governance can be deleted. Archived tapes with tape retention lock set to
     * compliance can't be deleted.
     */
    val bypassGovernanceRetention: Boolean = builder.bypassGovernanceRetention
    /**
     * The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
     * (VTS).
     */
    val tapeArn: String? = builder.tapeArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteTapeArchiveRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteTapeArchiveRequest(")
        append("bypassGovernanceRetention=$bypassGovernanceRetention,")
        append("tapeArn=$tapeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassGovernanceRetention.hashCode()
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteTapeArchiveRequest

        if (bypassGovernanceRetention != other.bypassGovernanceRetention) return false
        if (tapeArn != other.tapeArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteTapeArchiveRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteTapeArchiveRequest
        /**
         * Set to TRUE to delete an archived tape that belongs to a custom pool with
         * tape retention lock. Only archived tapes with tape retention lock set to
         * governance can be deleted. Archived tapes with tape retention lock set to
         * compliance can't be deleted.
         */
        fun bypassGovernanceRetention(bypassGovernanceRetention: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
         * (VTS).
         */
        fun tapeArn(tapeArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Set to TRUE to delete an archived tape that belongs to a custom pool with
         * tape retention lock. Only archived tapes with tape retention lock set to
         * governance can be deleted. Archived tapes with tape retention lock set to
         * compliance can't be deleted.
         */
        var bypassGovernanceRetention: Boolean
        /**
         * The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf
         * (VTS).
         */
        var tapeArn: String?

        fun build(): DeleteTapeArchiveRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bypassGovernanceRetention: Boolean = false
        override var tapeArn: String? = null

        constructor(x: DeleteTapeArchiveRequest) : this() {
            this.bypassGovernanceRetention = x.bypassGovernanceRetention
            this.tapeArn = x.tapeArn
        }

        override fun build(): DeleteTapeArchiveRequest = DeleteTapeArchiveRequest(this)
        override fun bypassGovernanceRetention(bypassGovernanceRetention: Boolean): FluentBuilder = apply { this.bypassGovernanceRetention = bypassGovernanceRetention }
        override fun tapeArn(tapeArn: String): FluentBuilder = apply { this.tapeArn = tapeArn }
    }
}
