// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * DeleteFileShareInput
 */
class DeleteFileShareRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the file share to be deleted.
     */
    val fileShareArn: String? = builder.fileShareArn
    /**
     * If this value is set to true, the operation deletes a file share
     * immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted
     * until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the
     * file share enters the FORCE_DELETING status.
     * Valid Values: true | false
     */
    val forceDelete: Boolean = builder.forceDelete

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteFileShareRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteFileShareRequest(")
        append("fileShareArn=$fileShareArn,")
        append("forceDelete=$forceDelete)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileShareArn?.hashCode() ?: 0
        result = 31 * result + (forceDelete.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteFileShareRequest

        if (fileShareArn != other.fileShareArn) return false
        if (forceDelete != other.forceDelete) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteFileShareRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteFileShareRequest
        /**
         * The Amazon Resource Name (ARN) of the file share to be deleted.
         */
        fun fileShareArn(fileShareArn: String): FluentBuilder
        /**
         * If this value is set to true, the operation deletes a file share
         * immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted
         * until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the
         * file share enters the FORCE_DELETING status.
         * Valid Values: true | false
         */
        fun forceDelete(forceDelete: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the file share to be deleted.
         */
        var fileShareArn: String?
        /**
         * If this value is set to true, the operation deletes a file share
         * immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted
         * until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the
         * file share enters the FORCE_DELETING status.
         * Valid Values: true | false
         */
        var forceDelete: Boolean

        fun build(): DeleteFileShareRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fileShareArn: String? = null
        override var forceDelete: Boolean = false

        constructor(x: DeleteFileShareRequest) : this() {
            this.fileShareArn = x.fileShareArn
            this.forceDelete = x.forceDelete
        }

        override fun build(): DeleteFileShareRequest = DeleteFileShareRequest(this)
        override fun fileShareArn(fileShareArn: String): FluentBuilder = apply { this.fileShareArn = fileShareArn }
        override fun forceDelete(forceDelete: Boolean): FluentBuilder = apply { this.forceDelete = forceDelete }
    }
}
