// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * CreateTapesInput
 */
class CreateTapesRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique identifier that you use to retry a request. If you retry a request, use the
     * same ClientToken you specified in the initial request.
     * Using the same ClientToken prevents creating the tape multiple
     * times.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The unique Amazon Resource Name (ARN) that represents the gateway to associate the
     * virtual tapes with. Use the ListGateways operation to return a list of
     * gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Set to true to use Amazon S3 server-side encryption with your own KMS
     * key, or false to use a key managed by Amazon S3. Optional.
     * Valid Values: true | false
     */
    val kmsEncrypted: Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The number of virtual tapes that you want to create.
     */
    val numTapesToCreate: Int? = builder.numTapesToCreate
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this
     * pool is archived in the S3 storage class that is associated with the pool. When you use
     * your backup application to eject the tape, the tape is archived directly into the storage
     * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    val poolId: String? = builder.poolId
    /**
     * A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
     * pair.
     * Valid characters for key and value are letters, spaces, and numbers representable in
     * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
     * of a tag's key is 128 characters, and the maximum length for a tag's value is
     * 256.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A prefix that you append to the barcode of the virtual tape you are creating. This
     * prefix makes the barcode unique.
     * The prefix must be 1-4 characters in length and must be one of the uppercase letters
     * from A to Z.
     */
    val tapeBarcodePrefix: String? = builder.tapeBarcodePrefix
    /**
     * The size, in bytes, of the virtual tapes that you want to create.
     * The size must be aligned by gigabyte (1024*1024*1024 bytes).
     */
    val tapeSizeInBytes: Long? = builder.tapeSizeInBytes
    /**
     * Set to TRUE if the tape you are creating is to be configured as a
     * write-once-read-many (WORM) tape.
     */
    val worm: Boolean = builder.worm

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateTapesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTapesRequest(")
        append("clientToken=$clientToken,")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("numTapesToCreate=$numTapesToCreate,")
        append("poolId=$poolId,")
        append("tags=$tags,")
        append("tapeBarcodePrefix=$tapeBarcodePrefix,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("worm=$worm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (numTapesToCreate ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcodePrefix?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateTapesRequest

        if (clientToken != other.clientToken) return false
        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (numTapesToCreate != other.numTapesToCreate) return false
        if (poolId != other.poolId) return false
        if (tags != other.tags) return false
        if (tapeBarcodePrefix != other.tapeBarcodePrefix) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateTapesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateTapesRequest
        /**
         * A unique identifier that you use to retry a request. If you retry a request, use the
         * same ClientToken you specified in the initial request.
         * Using the same ClientToken prevents creating the tape multiple
         * times.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the
         * virtual tapes with. Use the ListGateways operation to return a list of
         * gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The number of virtual tapes that you want to create.
         */
        fun numTapesToCreate(numTapesToCreate: Int): FluentBuilder
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * A prefix that you append to the barcode of the virtual tape you are creating. This
         * prefix makes the barcode unique.
         * The prefix must be 1-4 characters in length and must be one of the uppercase letters
         * from A to Z.
         */
        fun tapeBarcodePrefix(tapeBarcodePrefix: String): FluentBuilder
        /**
         * The size, in bytes, of the virtual tapes that you want to create.
         * The size must be aligned by gigabyte (1024*1024*1024 bytes).
         */
        fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder
        /**
         * Set to TRUE if the tape you are creating is to be configured as a
         * write-once-read-many (WORM) tape.
         */
        fun worm(worm: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique identifier that you use to retry a request. If you retry a request, use the
         * same ClientToken you specified in the initial request.
         * Using the same ClientToken prevents creating the tape multiple
         * times.
         */
        var clientToken: String?
        /**
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the
         * virtual tapes with. Use the ListGateways operation to return a list of
         * gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        var kmsEncrypted: Boolean?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The number of virtual tapes that you want to create.
         */
        var numTapesToCreate: Int?
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        var poolId: String?
        /**
         * A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        var tags: List<Tag>?
        /**
         * A prefix that you append to the barcode of the virtual tape you are creating. This
         * prefix makes the barcode unique.
         * The prefix must be 1-4 characters in length and must be one of the uppercase letters
         * from A to Z.
         */
        var tapeBarcodePrefix: String?
        /**
         * The size, in bytes, of the virtual tapes that you want to create.
         * The size must be aligned by gigabyte (1024*1024*1024 bytes).
         */
        var tapeSizeInBytes: Long?
        /**
         * Set to TRUE if the tape you are creating is to be configured as a
         * write-once-read-many (WORM) tape.
         */
        var worm: Boolean

        fun build(): CreateTapesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var gatewayArn: String? = null
        override var kmsEncrypted: Boolean? = null
        override var kmsKey: String? = null
        override var numTapesToCreate: Int? = null
        override var poolId: String? = null
        override var tags: List<Tag>? = null
        override var tapeBarcodePrefix: String? = null
        override var tapeSizeInBytes: Long? = null
        override var worm: Boolean = false

        constructor(x: CreateTapesRequest) : this() {
            this.clientToken = x.clientToken
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.numTapesToCreate = x.numTapesToCreate
            this.poolId = x.poolId
            this.tags = x.tags
            this.tapeBarcodePrefix = x.tapeBarcodePrefix
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.worm = x.worm
        }

        override fun build(): CreateTapesRequest = CreateTapesRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder = apply { this.kmsEncrypted = kmsEncrypted }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun numTapesToCreate(numTapesToCreate: Int): FluentBuilder = apply { this.numTapesToCreate = numTapesToCreate }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun tapeBarcodePrefix(tapeBarcodePrefix: String): FluentBuilder = apply { this.tapeBarcodePrefix = tapeBarcodePrefix }
        override fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder = apply { this.tapeSizeInBytes = tapeSizeInBytes }
        override fun worm(worm: Boolean): FluentBuilder = apply { this.worm = worm }
    }
}
