// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * CreateTapeWithBarcodeInput
 */
class CreateTapeWithBarcodeRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique Amazon Resource Name (ARN) that represents the gateway to associate the
     * virtual tape with. Use the ListGateways operation to return a list of
     * gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Set to true to use Amazon S3 server-side encryption with your own KMS
     * key, or false to use a key managed by Amazon S3. Optional.
     * Valid Values: true | false
     */
    val kmsEncrypted: Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this
     * pool is archived in the S3 storage class that is associated with the pool. When you use
     * your backup application to eject the tape, the tape is archived directly into the storage
     * class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    val poolId: String? = builder.poolId
    /**
     * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
     * tag is a key-value pair.
     * Valid characters for key and value are letters, spaces, and numbers representable in
     * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
     * of a tag's key is 128 characters, and the maximum length for a tag's value is
     * 256.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The barcode that you want to assign to the tape.
     * Barcodes cannot be reused. This includes barcodes used for tapes that have been
     * deleted.
     */
    val tapeBarcode: String? = builder.tapeBarcode
    /**
     * The size, in bytes, of the virtual tape that you want to create.
     * The size must be aligned by gigabyte (1024*1024*1024 bytes).
     */
    val tapeSizeInBytes: Long? = builder.tapeSizeInBytes
    /**
     * Set to TRUE if the tape you are creating is to be configured as a
     * write-once-read-many (WORM) tape.
     */
    val worm: Boolean = builder.worm

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateTapeWithBarcodeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTapeWithBarcodeRequest(")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("poolId=$poolId,")
        append("tags=$tags,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("worm=$worm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateTapeWithBarcodeRequest

        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (poolId != other.poolId) return false
        if (tags != other.tags) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateTapeWithBarcodeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateTapeWithBarcodeRequest
        /**
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the
         * virtual tape with. Use the ListGateways operation to return a list of
         * gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
         * tag is a key-value pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The barcode that you want to assign to the tape.
         * Barcodes cannot be reused. This includes barcodes used for tapes that have been
         * deleted.
         */
        fun tapeBarcode(tapeBarcode: String): FluentBuilder
        /**
         * The size, in bytes, of the virtual tape that you want to create.
         * The size must be aligned by gigabyte (1024*1024*1024 bytes).
         */
        fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder
        /**
         * Set to TRUE if the tape you are creating is to be configured as a
         * write-once-read-many (WORM) tape.
         */
        fun worm(worm: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the
         * virtual tape with. Use the ListGateways operation to return a list of
         * gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        var kmsEncrypted: Boolean?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        var poolId: String?
        /**
         * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each
         * tag is a key-value pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        var tags: List<Tag>?
        /**
         * The barcode that you want to assign to the tape.
         * Barcodes cannot be reused. This includes barcodes used for tapes that have been
         * deleted.
         */
        var tapeBarcode: String?
        /**
         * The size, in bytes, of the virtual tape that you want to create.
         * The size must be aligned by gigabyte (1024*1024*1024 bytes).
         */
        var tapeSizeInBytes: Long?
        /**
         * Set to TRUE if the tape you are creating is to be configured as a
         * write-once-read-many (WORM) tape.
         */
        var worm: Boolean

        fun build(): CreateTapeWithBarcodeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null
        override var kmsEncrypted: Boolean? = null
        override var kmsKey: String? = null
        override var poolId: String? = null
        override var tags: List<Tag>? = null
        override var tapeBarcode: String? = null
        override var tapeSizeInBytes: Long? = null
        override var worm: Boolean = false

        constructor(x: CreateTapeWithBarcodeRequest) : this() {
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.poolId = x.poolId
            this.tags = x.tags
            this.tapeBarcode = x.tapeBarcode
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.worm = x.worm
        }

        override fun build(): CreateTapeWithBarcodeRequest = CreateTapeWithBarcodeRequest(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder = apply { this.kmsEncrypted = kmsEncrypted }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun tapeBarcode(tapeBarcode: String): FluentBuilder = apply { this.tapeBarcode = tapeBarcode }
        override fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder = apply { this.tapeSizeInBytes = tapeSizeInBytes }
        override fun worm(worm: Boolean): FluentBuilder = apply { this.worm = worm }
    }
}
