// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class CreateTapePoolRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the new custom tape pool.
     */
    val poolName: String? = builder.poolName
    /**
     * Tape retention lock time is set in days. Tape retention lock can be enabled for up to
     * 100 years (36,500 days).
     */
    val retentionLockTimeInDays: Int? = builder.retentionLockTimeInDays
    /**
     * Tape retention lock can be configured in two modes. When configured in governance mode,
     * accounts with specific IAM permissions are authorized to remove the tape retention lock
     * from archived virtual tapes. When configured in compliance mode, the tape retention lock
     * cannot be removed by any user, including the root account.
     */
    val retentionLockType: RetentionLockType? = builder.retentionLockType
    /**
     * The storage class that is associated with the new custom pool. When you use your backup
     * application to eject the tape, the tape is archived directly into the storage class (S3
     * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    val storageClass: TapeStorageClass? = builder.storageClass
    /**
     * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value
     * pair.
     * Valid characters for key and value are letters, spaces, and numbers representable in
     * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
     * of a tag's key is 128 characters, and the maximum length for a tag's value is
     * 256.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateTapePoolRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTapePoolRequest(")
        append("poolName=$poolName,")
        append("retentionLockTimeInDays=$retentionLockTimeInDays,")
        append("retentionLockType=$retentionLockType,")
        append("storageClass=$storageClass,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = poolName?.hashCode() ?: 0
        result = 31 * result + (retentionLockTimeInDays ?: 0)
        result = 31 * result + (retentionLockType?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateTapePoolRequest

        if (poolName != other.poolName) return false
        if (retentionLockTimeInDays != other.retentionLockTimeInDays) return false
        if (retentionLockType != other.retentionLockType) return false
        if (storageClass != other.storageClass) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateTapePoolRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateTapePoolRequest
        /**
         * The name of the new custom tape pool.
         */
        fun poolName(poolName: String): FluentBuilder
        /**
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to
         * 100 years (36,500 days).
         */
        fun retentionLockTimeInDays(retentionLockTimeInDays: Int): FluentBuilder
        /**
         * Tape retention lock can be configured in two modes. When configured in governance mode,
         * accounts with specific IAM permissions are authorized to remove the tape retention lock
         * from archived virtual tapes. When configured in compliance mode, the tape retention lock
         * cannot be removed by any user, including the root account.
         */
        fun retentionLockType(retentionLockType: RetentionLockType): FluentBuilder
        /**
         * The storage class that is associated with the new custom pool. When you use your backup
         * application to eject the tape, the tape is archived directly into the storage class (S3
         * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        fun storageClass(storageClass: TapeStorageClass): FluentBuilder
        /**
         * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the new custom tape pool.
         */
        var poolName: String?
        /**
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to
         * 100 years (36,500 days).
         */
        var retentionLockTimeInDays: Int?
        /**
         * Tape retention lock can be configured in two modes. When configured in governance mode,
         * accounts with specific IAM permissions are authorized to remove the tape retention lock
         * from archived virtual tapes. When configured in compliance mode, the tape retention lock
         * cannot be removed by any user, including the root account.
         */
        var retentionLockType: RetentionLockType?
        /**
         * The storage class that is associated with the new custom pool. When you use your backup
         * application to eject the tape, the tape is archived directly into the storage class (S3
         * Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        var storageClass: TapeStorageClass?
        /**
         * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        var tags: List<Tag>?

        fun build(): CreateTapePoolRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var poolName: String? = null
        override var retentionLockTimeInDays: Int? = null
        override var retentionLockType: RetentionLockType? = null
        override var storageClass: TapeStorageClass? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateTapePoolRequest) : this() {
            this.poolName = x.poolName
            this.retentionLockTimeInDays = x.retentionLockTimeInDays
            this.retentionLockType = x.retentionLockType
            this.storageClass = x.storageClass
            this.tags = x.tags
        }

        override fun build(): CreateTapePoolRequest = CreateTapePoolRequest(this)
        override fun poolName(poolName: String): FluentBuilder = apply { this.poolName = poolName }
        override fun retentionLockTimeInDays(retentionLockTimeInDays: Int): FluentBuilder = apply { this.retentionLockTimeInDays = retentionLockTimeInDays }
        override fun retentionLockType(retentionLockType: RetentionLockType): FluentBuilder = apply { this.retentionLockType = retentionLockType }
        override fun storageClass(storageClass: TapeStorageClass): FluentBuilder = apply { this.storageClass = storageClass }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
