// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * A JSON object containing one or more of the following fields:
 * CreateStorediSCSIVolumeInput$DiskId
 * CreateStorediSCSIVolumeInput$NetworkInterfaceId
 * CreateStorediSCSIVolumeInput$PreserveExistingData
 * CreateStorediSCSIVolumeInput$SnapshotId
 * CreateStorediSCSIVolumeInput$TargetName
 */
class CreateStorediScsiVolumeRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the gateway local disk that is configured as a stored volume.
     * Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks to
     * list disk IDs for a gateway.
     */
    val diskId: String? = builder.diskId
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Set to true to use Amazon S3 server-side encryption with your own KMS
     * key, or false to use a key managed by Amazon S3. Optional.
     * Valid Values: true | false
     */
    val kmsEncrypted: Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
     * addresses are accepted. Use DescribeGatewayInformation to get a list of
     * the network interfaces available on a gateway.
     * Valid Values: A valid IP address.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * Set to true if you want to preserve the data on the local disk. Otherwise,
     * set to false to create an empty volume.
     * Valid Values: true | false
     */
    val preserveExistingData: Boolean = builder.preserveExistingData
    /**
     * The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored
     * volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
     * otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots in the Amazon Elastic Compute Cloud API
     * Reference.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value
     * pair.
     * Valid characters for key and value are letters, spaces, and numbers representable in
     * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
     * of a tag's key is 128 characters, and the maximum length for a tag's value is
     * 256.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a
     * suffix for the target ARN. For example, specifying TargetName as
     * myvolume results in the target ARN of
     * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
     * The target name must be unique across all volumes on a gateway.
     * If you don't specify a value, Storage Gateway uses the value that was previously
     * used for this volume as the new target name.
     */
    val targetName: String? = builder.targetName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateStorediScsiVolumeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStorediScsiVolumeRequest(")
        append("diskId=$diskId,")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("preserveExistingData=$preserveExistingData,")
        append("snapshotId=$snapshotId,")
        append("tags=$tags,")
        append("targetName=$targetName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = diskId?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (preserveExistingData.hashCode())
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateStorediScsiVolumeRequest

        if (diskId != other.diskId) return false
        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (preserveExistingData != other.preserveExistingData) return false
        if (snapshotId != other.snapshotId) return false
        if (tags != other.tags) return false
        if (targetName != other.targetName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateStorediScsiVolumeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateStorediScsiVolumeRequest
        /**
         * The unique identifier for the gateway local disk that is configured as a stored volume.
         * Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks to
         * list disk IDs for a gateway.
         */
        fun diskId(diskId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
         * addresses are accepted. Use DescribeGatewayInformation to get a list of
         * the network interfaces available on a gateway.
         * Valid Values: A valid IP address.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * Set to true if you want to preserve the data on the local disk. Otherwise,
         * set to false to create an empty volume.
         * Valid Values: true | false
         */
        fun preserveExistingData(preserveExistingData: Boolean): FluentBuilder
        /**
         * The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored
         * volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
         * otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots in the Amazon Elastic Compute Cloud API
         * Reference.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        fun targetName(targetName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the gateway local disk that is configured as a stored volume.
         * Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks to
         * list disk IDs for a gateway.
         */
        var diskId: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        var kmsEncrypted: Boolean?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
         * addresses are accepted. Use DescribeGatewayInformation to get a list of
         * the network interfaces available on a gateway.
         * Valid Values: A valid IP address.
         */
        var networkInterfaceId: String?
        /**
         * Set to true if you want to preserve the data on the local disk. Otherwise,
         * set to false to create an empty volume.
         * Valid Values: true | false
         */
        var preserveExistingData: Boolean
        /**
         * The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored
         * volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
         * otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots in the Amazon Elastic Compute Cloud API
         * Reference.
         */
        var snapshotId: String?
        /**
         * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        var tags: List<Tag>?
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        var targetName: String?

        fun build(): CreateStorediScsiVolumeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var diskId: String? = null
        override var gatewayArn: String? = null
        override var kmsEncrypted: Boolean? = null
        override var kmsKey: String? = null
        override var networkInterfaceId: String? = null
        override var preserveExistingData: Boolean = false
        override var snapshotId: String? = null
        override var tags: List<Tag>? = null
        override var targetName: String? = null

        constructor(x: CreateStorediScsiVolumeRequest) : this() {
            this.diskId = x.diskId
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.networkInterfaceId = x.networkInterfaceId
            this.preserveExistingData = x.preserveExistingData
            this.snapshotId = x.snapshotId
            this.tags = x.tags
            this.targetName = x.targetName
        }

        override fun build(): CreateStorediScsiVolumeRequest = CreateStorediScsiVolumeRequest(this)
        override fun diskId(diskId: String): FluentBuilder = apply { this.diskId = diskId }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder = apply { this.kmsEncrypted = kmsEncrypted }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun preserveExistingData(preserveExistingData: Boolean): FluentBuilder = apply { this.preserveExistingData = preserveExistingData }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun targetName(targetName: String): FluentBuilder = apply { this.targetName = targetName }
    }
}
