// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class CreateCachediScsiVolumeRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique identifier that you use to retry a request. If you retry a request, use the
     * same ClientToken you specified in the initial request.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Set to true to use Amazon S3 server-side encryption with your own KMS
     * key, or false to use a key managed by Amazon S3. Optional.
     * Valid Values: true | false
     */
    val kmsEncrypted: Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
     * addresses are accepted. Use DescribeGatewayInformation to get a list of
     * the network interfaces available on a gateway.
     * Valid Values: A valid IP address.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached
     * volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
     * otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots in the Amazon Elastic Compute Cloud API
     * Reference.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact
     * copy of the specified existing volume's latest recovery point. The
     * VolumeSizeInBytes value for this new volume must be equal to or larger than
     * the size of the existing volume, in bytes.
     */
    val sourceVolumeArn: String? = builder.sourceVolumeArn
    /**
     * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value
     * pair.
     * Valid characters for key and value are letters, spaces, and numbers that you can
     * represent in UTF-8 format, and the following special characters: + - = . _ : / @. The
     * maximum length of a tag's key is 128 characters, and the maximum length for a
     * tag's value is 256 characters.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a
     * suffix for the target ARN. For example, specifying TargetName as
     * myvolume results in the target ARN of
     * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
     * The target name must be unique across all volumes on a gateway.
     * If you don't specify a value, Storage Gateway uses the value that was previously
     * used for this volume as the new target name.
     */
    val targetName: String? = builder.targetName
    /**
     * The size of the volume in bytes.
     */
    val volumeSizeInBytes: Long = builder.volumeSizeInBytes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateCachediScsiVolumeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCachediScsiVolumeRequest(")
        append("clientToken=$clientToken,")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("snapshotId=$snapshotId,")
        append("sourceVolumeArn=$sourceVolumeArn,")
        append("tags=$tags,")
        append("targetName=$targetName,")
        append("volumeSizeInBytes=$volumeSizeInBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (sourceVolumeArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateCachediScsiVolumeRequest

        if (clientToken != other.clientToken) return false
        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (snapshotId != other.snapshotId) return false
        if (sourceVolumeArn != other.sourceVolumeArn) return false
        if (tags != other.tags) return false
        if (targetName != other.targetName) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateCachediScsiVolumeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateCachediScsiVolumeRequest
        /**
         * A unique identifier that you use to retry a request. If you retry a request, use the
         * same ClientToken you specified in the initial request.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
         * addresses are accepted. Use DescribeGatewayInformation to get a list of
         * the network interfaces available on a gateway.
         * Valid Values: A valid IP address.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached
         * volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
         * otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots in the Amazon Elastic Compute Cloud API
         * Reference.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact
         * copy of the specified existing volume's latest recovery point. The
         * VolumeSizeInBytes value for this new volume must be equal to or larger than
         * the size of the existing volume, in bytes.
         */
        fun sourceVolumeArn(sourceVolumeArn: String): FluentBuilder
        /**
         * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers that you can
         * represent in UTF-8 format, and the following special characters: + - = . _ : / @. The
         * maximum length of a tag's key is 128 characters, and the maximum length for a
         * tag's value is 256 characters.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        fun targetName(targetName: String): FluentBuilder
        /**
         * The size of the volume in bytes.
         */
        fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique identifier that you use to retry a request. If you retry a request, use the
         * same ClientToken you specified in the initial request.
         */
        var clientToken: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        var kmsEncrypted: Boolean?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
         * addresses are accepted. Use DescribeGatewayInformation to get a list of
         * the network interfaces available on a gateway.
         * Valid Values: A valid IP address.
         */
        var networkInterfaceId: String?
        /**
         * The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached
         * volume. Specify this field if you want to create the iSCSI storage volume from a snapshot;
         * otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots in the Amazon Elastic Compute Cloud API
         * Reference.
         */
        var snapshotId: String?
        /**
         * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact
         * copy of the specified existing volume's latest recovery point. The
         * VolumeSizeInBytes value for this new volume must be equal to or larger than
         * the size of the existing volume, in bytes.
         */
        var sourceVolumeArn: String?
        /**
         * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers that you can
         * represent in UTF-8 format, and the following special characters: + - = . _ : / @. The
         * maximum length of a tag's key is 128 characters, and the maximum length for a
         * tag's value is 256 characters.
         */
        var tags: List<Tag>?
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        var targetName: String?
        /**
         * The size of the volume in bytes.
         */
        var volumeSizeInBytes: Long

        fun build(): CreateCachediScsiVolumeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var gatewayArn: String? = null
        override var kmsEncrypted: Boolean? = null
        override var kmsKey: String? = null
        override var networkInterfaceId: String? = null
        override var snapshotId: String? = null
        override var sourceVolumeArn: String? = null
        override var tags: List<Tag>? = null
        override var targetName: String? = null
        override var volumeSizeInBytes: Long = 0L

        constructor(x: CreateCachediScsiVolumeRequest) : this() {
            this.clientToken = x.clientToken
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.networkInterfaceId = x.networkInterfaceId
            this.snapshotId = x.snapshotId
            this.sourceVolumeArn = x.sourceVolumeArn
            this.tags = x.tags
            this.targetName = x.targetName
            this.volumeSizeInBytes = x.volumeSizeInBytes
        }

        override fun build(): CreateCachediScsiVolumeRequest = CreateCachediScsiVolumeRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder = apply { this.kmsEncrypted = kmsEncrypted }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun sourceVolumeArn(sourceVolumeArn: String): FluentBuilder = apply { this.sourceVolumeArn = sourceVolumeArn }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun targetName(targetName: String): FluentBuilder = apply { this.targetName = targetName }
        override fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder = apply { this.volumeSizeInBytes = volumeSizeInBytes }
    }
}
