// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes Challenge-Handshake Authentication Protocol (CHAP) information that supports
 * authentication between your gateway and iSCSI initiators.
 */
class ChapInfo private constructor(builder: BuilderImpl) {
    /**
     * The iSCSI initiator that connects to the target.
     */
    val initiatorName: String? = builder.initiatorName
    /**
     * The secret key that the initiator (for example, the Windows client) must provide to
     * participate in mutual CHAP with the target.
     */
    val secretToAuthenticateInitiator: String? = builder.secretToAuthenticateInitiator
    /**
     * The secret key that the target must provide to participate in mutual CHAP with the
     * initiator (e.g., Windows client).
     */
    val secretToAuthenticateTarget: String? = builder.secretToAuthenticateTarget
    /**
     * The Amazon Resource Name (ARN) of the volume.
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChapInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChapInfo(")
        append("initiatorName=$initiatorName,")
        append("secretToAuthenticateInitiator=*** Sensitive Data Redacted ***,")
        append("secretToAuthenticateTarget=*** Sensitive Data Redacted ***,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = initiatorName?.hashCode() ?: 0
        result = 31 * result + (secretToAuthenticateInitiator?.hashCode() ?: 0)
        result = 31 * result + (secretToAuthenticateTarget?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChapInfo

        if (initiatorName != other.initiatorName) return false
        if (secretToAuthenticateInitiator != other.secretToAuthenticateInitiator) return false
        if (secretToAuthenticateTarget != other.secretToAuthenticateTarget) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChapInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChapInfo
        /**
         * The iSCSI initiator that connects to the target.
         */
        fun initiatorName(initiatorName: String): FluentBuilder
        /**
         * The secret key that the initiator (for example, the Windows client) must provide to
         * participate in mutual CHAP with the target.
         */
        fun secretToAuthenticateInitiator(secretToAuthenticateInitiator: String): FluentBuilder
        /**
         * The secret key that the target must provide to participate in mutual CHAP with the
         * initiator (e.g., Windows client).
         */
        fun secretToAuthenticateTarget(secretToAuthenticateTarget: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the volume.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The iSCSI initiator that connects to the target.
         */
        var initiatorName: String?
        /**
         * The secret key that the initiator (for example, the Windows client) must provide to
         * participate in mutual CHAP with the target.
         */
        var secretToAuthenticateInitiator: String?
        /**
         * The secret key that the target must provide to participate in mutual CHAP with the
         * initiator (e.g., Windows client).
         */
        var secretToAuthenticateTarget: String?
        /**
         * The Amazon Resource Name (ARN) of the volume.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        var targetArn: String?

        fun build(): ChapInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var initiatorName: String? = null
        override var secretToAuthenticateInitiator: String? = null
        override var secretToAuthenticateTarget: String? = null
        override var targetArn: String? = null

        constructor(x: ChapInfo) : this() {
            this.initiatorName = x.initiatorName
            this.secretToAuthenticateInitiator = x.secretToAuthenticateInitiator
            this.secretToAuthenticateTarget = x.secretToAuthenticateTarget
            this.targetArn = x.targetArn
        }

        override fun build(): ChapInfo = ChapInfo(this)
        override fun initiatorName(initiatorName: String): FluentBuilder = apply { this.initiatorName = initiatorName }
        override fun secretToAuthenticateInitiator(secretToAuthenticateInitiator: String): FluentBuilder = apply { this.secretToAuthenticateInitiator = secretToAuthenticateInitiator }
        override fun secretToAuthenticateTarget(secretToAuthenticateTarget: String): FluentBuilder = apply { this.secretToAuthenticateTarget = secretToAuthenticateTarget }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
