// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a bandwidth rate limit interval for a gateway. A bandwidth
 * rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit
 * interval defines a period of time on one or more days of the week, during which bandwidth rate
 * limits are specified for uploading, downloading, or both.
 */
class BandwidthRateLimitInterval private constructor(builder: BuilderImpl) {
    /**
     * The average download rate limit component of the bandwidth rate limit interval,
     * in bits per second. This field does not appear in the response if the download rate limit is not set.
     */
    val averageDownloadRateLimitInBitsPerSec: Long? = builder.averageDownloadRateLimitInBitsPerSec
    /**
     * The average upload rate limit component of the bandwidth rate limit interval,
     * in bits per second. This field does not appear in the response if the upload rate limit is not set.
     */
    val averageUploadRateLimitInBitsPerSec: Long? = builder.averageUploadRateLimitInBitsPerSec
    /**
     * The days of the week component of the bandwidth rate limit interval, represented as
     * ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
     */
    val daysOfWeek: List<Int>? = builder.daysOfWeek
    /**
     * The hour of the day to end the bandwidth rate limit interval.
     */
    val endHourOfDay: Int? = builder.endHourOfDay
    /**
     * The minute of the hour to end the bandwidth rate limit interval.
     * The bandwidth rate limit interval ends at the end of the minute. To end an interval
     * at the end of an hour, use the value 59.
     */
    val endMinuteOfHour: Int? = builder.endMinuteOfHour
    /**
     * The hour of the day to start the bandwidth rate limit interval.
     */
    val startHourOfDay: Int? = builder.startHourOfDay
    /**
     * The minute of the hour to start the bandwidth rate limit interval.
     * The interval begins at the start of that minute. To begin an interval exactly at
     * the start of the hour, use the value 0.
     */
    val startMinuteOfHour: Int? = builder.startMinuteOfHour

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BandwidthRateLimitInterval = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BandwidthRateLimitInterval(")
        append("averageDownloadRateLimitInBitsPerSec=$averageDownloadRateLimitInBitsPerSec,")
        append("averageUploadRateLimitInBitsPerSec=$averageUploadRateLimitInBitsPerSec,")
        append("daysOfWeek=$daysOfWeek,")
        append("endHourOfDay=$endHourOfDay,")
        append("endMinuteOfHour=$endMinuteOfHour,")
        append("startHourOfDay=$startHourOfDay,")
        append("startMinuteOfHour=$startMinuteOfHour)")
    }

    override fun hashCode(): kotlin.Int {
        var result = averageDownloadRateLimitInBitsPerSec?.hashCode() ?: 0
        result = 31 * result + (averageUploadRateLimitInBitsPerSec?.hashCode() ?: 0)
        result = 31 * result + (daysOfWeek?.hashCode() ?: 0)
        result = 31 * result + (endHourOfDay ?: 0)
        result = 31 * result + (endMinuteOfHour ?: 0)
        result = 31 * result + (startHourOfDay ?: 0)
        result = 31 * result + (startMinuteOfHour ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BandwidthRateLimitInterval

        if (averageDownloadRateLimitInBitsPerSec != other.averageDownloadRateLimitInBitsPerSec) return false
        if (averageUploadRateLimitInBitsPerSec != other.averageUploadRateLimitInBitsPerSec) return false
        if (daysOfWeek != other.daysOfWeek) return false
        if (endHourOfDay != other.endHourOfDay) return false
        if (endMinuteOfHour != other.endMinuteOfHour) return false
        if (startHourOfDay != other.startHourOfDay) return false
        if (startMinuteOfHour != other.startMinuteOfHour) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BandwidthRateLimitInterval = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BandwidthRateLimitInterval
        /**
         * The average download rate limit component of the bandwidth rate limit interval,
         * in bits per second. This field does not appear in the response if the download rate limit is not set.
         */
        fun averageDownloadRateLimitInBitsPerSec(averageDownloadRateLimitInBitsPerSec: Long): FluentBuilder
        /**
         * The average upload rate limit component of the bandwidth rate limit interval,
         * in bits per second. This field does not appear in the response if the upload rate limit is not set.
         */
        fun averageUploadRateLimitInBitsPerSec(averageUploadRateLimitInBitsPerSec: Long): FluentBuilder
        /**
         * The days of the week component of the bandwidth rate limit interval, represented as
         * ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
         */
        fun daysOfWeek(daysOfWeek: List<Int>): FluentBuilder
        /**
         * The hour of the day to end the bandwidth rate limit interval.
         */
        fun endHourOfDay(endHourOfDay: Int): FluentBuilder
        /**
         * The minute of the hour to end the bandwidth rate limit interval.
         * The bandwidth rate limit interval ends at the end of the minute. To end an interval
         * at the end of an hour, use the value 59.
         */
        fun endMinuteOfHour(endMinuteOfHour: Int): FluentBuilder
        /**
         * The hour of the day to start the bandwidth rate limit interval.
         */
        fun startHourOfDay(startHourOfDay: Int): FluentBuilder
        /**
         * The minute of the hour to start the bandwidth rate limit interval.
         * The interval begins at the start of that minute. To begin an interval exactly at
         * the start of the hour, use the value 0.
         */
        fun startMinuteOfHour(startMinuteOfHour: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The average download rate limit component of the bandwidth rate limit interval,
         * in bits per second. This field does not appear in the response if the download rate limit is not set.
         */
        var averageDownloadRateLimitInBitsPerSec: Long?
        /**
         * The average upload rate limit component of the bandwidth rate limit interval,
         * in bits per second. This field does not appear in the response if the upload rate limit is not set.
         */
        var averageUploadRateLimitInBitsPerSec: Long?
        /**
         * The days of the week component of the bandwidth rate limit interval, represented as
         * ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
         */
        var daysOfWeek: List<Int>?
        /**
         * The hour of the day to end the bandwidth rate limit interval.
         */
        var endHourOfDay: Int?
        /**
         * The minute of the hour to end the bandwidth rate limit interval.
         * The bandwidth rate limit interval ends at the end of the minute. To end an interval
         * at the end of an hour, use the value 59.
         */
        var endMinuteOfHour: Int?
        /**
         * The hour of the day to start the bandwidth rate limit interval.
         */
        var startHourOfDay: Int?
        /**
         * The minute of the hour to start the bandwidth rate limit interval.
         * The interval begins at the start of that minute. To begin an interval exactly at
         * the start of the hour, use the value 0.
         */
        var startMinuteOfHour: Int?

        fun build(): BandwidthRateLimitInterval
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var averageDownloadRateLimitInBitsPerSec: Long? = null
        override var averageUploadRateLimitInBitsPerSec: Long? = null
        override var daysOfWeek: List<Int>? = null
        override var endHourOfDay: Int? = null
        override var endMinuteOfHour: Int? = null
        override var startHourOfDay: Int? = null
        override var startMinuteOfHour: Int? = null

        constructor(x: BandwidthRateLimitInterval) : this() {
            this.averageDownloadRateLimitInBitsPerSec = x.averageDownloadRateLimitInBitsPerSec
            this.averageUploadRateLimitInBitsPerSec = x.averageUploadRateLimitInBitsPerSec
            this.daysOfWeek = x.daysOfWeek
            this.endHourOfDay = x.endHourOfDay
            this.endMinuteOfHour = x.endMinuteOfHour
            this.startHourOfDay = x.startHourOfDay
            this.startMinuteOfHour = x.startMinuteOfHour
        }

        override fun build(): BandwidthRateLimitInterval = BandwidthRateLimitInterval(this)
        override fun averageDownloadRateLimitInBitsPerSec(averageDownloadRateLimitInBitsPerSec: Long): FluentBuilder = apply { this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec }
        override fun averageUploadRateLimitInBitsPerSec(averageUploadRateLimitInBitsPerSec: Long): FluentBuilder = apply { this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec }
        override fun daysOfWeek(daysOfWeek: List<Int>): FluentBuilder = apply { this.daysOfWeek = daysOfWeek }
        override fun endHourOfDay(endHourOfDay: Int): FluentBuilder = apply { this.endHourOfDay = endHourOfDay }
        override fun endMinuteOfHour(endMinuteOfHour: Int): FluentBuilder = apply { this.endMinuteOfHour = endMinuteOfHour }
        override fun startHourOfDay(startHourOfDay: Int): FluentBuilder = apply { this.startHourOfDay = startHourOfDay }
        override fun startMinuteOfHour(startMinuteOfHour: Int): FluentBuilder = apply { this.startMinuteOfHour = startMinuteOfHour }
    }
}
