// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * An automatic tape creation policy consists of automatic tape creation rules where each
 * rule defines when and how to create new tapes. For more information about automatic tape
 * creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically.
 */
class AutomaticTapeCreationRule private constructor(builder: BuilderImpl) {
    /**
     * The minimum number of available virtual tapes that the gateway maintains at all times.
     * If the number of tapes on the gateway goes below this value, the gateway creates as many
     * new tapes as are needed to have MinimumNumTapes on the gateway. For more
     * information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically.
     */
    val minimumNumTapes: Int? = builder.minimumNumTapes
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this
     * pool is archived in the Amazon S3 storage class that is associated with the pool. When you
     * use your backup application to eject the tape, the tape is archived directly into the
     * storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    val poolId: String? = builder.poolId
    /**
     * A prefix that you append to the barcode of the virtual tape that you are creating. This
     * prefix makes the barcode unique.
     * The prefix must be 1-4 characters in length and must be one of the uppercase letters
     * from A to Z.
     */
    val tapeBarcodePrefix: String? = builder.tapeBarcodePrefix
    /**
     * The size, in bytes, of the virtual tape capacity.
     */
    val tapeSizeInBytes: Long? = builder.tapeSizeInBytes
    /**
     * Set to true to indicate that tapes are to be archived as
     * write-once-read-many (WORM). Set to false when WORM is not enabled for
     * tapes.
     */
    val worm: Boolean = builder.worm

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AutomaticTapeCreationRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AutomaticTapeCreationRule(")
        append("minimumNumTapes=$minimumNumTapes,")
        append("poolId=$poolId,")
        append("tapeBarcodePrefix=$tapeBarcodePrefix,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("worm=$worm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = minimumNumTapes ?: 0
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcodePrefix?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AutomaticTapeCreationRule

        if (minimumNumTapes != other.minimumNumTapes) return false
        if (poolId != other.poolId) return false
        if (tapeBarcodePrefix != other.tapeBarcodePrefix) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AutomaticTapeCreationRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AutomaticTapeCreationRule
        /**
         * The minimum number of available virtual tapes that the gateway maintains at all times.
         * If the number of tapes on the gateway goes below this value, the gateway creates as many
         * new tapes as are needed to have MinimumNumTapes on the gateway. For more
         * information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically.
         */
        fun minimumNumTapes(minimumNumTapes: Int): FluentBuilder
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the Amazon S3 storage class that is associated with the pool. When you
         * use your backup application to eject the tape, the tape is archived directly into the
         * storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * A prefix that you append to the barcode of the virtual tape that you are creating. This
         * prefix makes the barcode unique.
         * The prefix must be 1-4 characters in length and must be one of the uppercase letters
         * from A to Z.
         */
        fun tapeBarcodePrefix(tapeBarcodePrefix: String): FluentBuilder
        /**
         * The size, in bytes, of the virtual tape capacity.
         */
        fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder
        /**
         * Set to true to indicate that tapes are to be archived as
         * write-once-read-many (WORM). Set to false when WORM is not enabled for
         * tapes.
         */
        fun worm(worm: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The minimum number of available virtual tapes that the gateway maintains at all times.
         * If the number of tapes on the gateway goes below this value, the gateway creates as many
         * new tapes as are needed to have MinimumNumTapes on the gateway. For more
         * information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically.
         */
        var minimumNumTapes: Int?
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the Amazon S3 storage class that is associated with the pool. When you
         * use your backup application to eject the tape, the tape is archived directly into the
         * storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        var poolId: String?
        /**
         * A prefix that you append to the barcode of the virtual tape that you are creating. This
         * prefix makes the barcode unique.
         * The prefix must be 1-4 characters in length and must be one of the uppercase letters
         * from A to Z.
         */
        var tapeBarcodePrefix: String?
        /**
         * The size, in bytes, of the virtual tape capacity.
         */
        var tapeSizeInBytes: Long?
        /**
         * Set to true to indicate that tapes are to be archived as
         * write-once-read-many (WORM). Set to false when WORM is not enabled for
         * tapes.
         */
        var worm: Boolean

        fun build(): AutomaticTapeCreationRule
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var minimumNumTapes: Int? = null
        override var poolId: String? = null
        override var tapeBarcodePrefix: String? = null
        override var tapeSizeInBytes: Long? = null
        override var worm: Boolean = false

        constructor(x: AutomaticTapeCreationRule) : this() {
            this.minimumNumTapes = x.minimumNumTapes
            this.poolId = x.poolId
            this.tapeBarcodePrefix = x.tapeBarcodePrefix
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.worm = x.worm
        }

        override fun build(): AutomaticTapeCreationRule = AutomaticTapeCreationRule(this)
        override fun minimumNumTapes(minimumNumTapes: Int): FluentBuilder = apply { this.minimumNumTapes = minimumNumTapes }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun tapeBarcodePrefix(tapeBarcodePrefix: String): FluentBuilder = apply { this.tapeBarcodePrefix = tapeBarcodePrefix }
        override fun tapeSizeInBytes(tapeSizeInBytes: Long): FluentBuilder = apply { this.tapeSizeInBytes = tapeSizeInBytes }
        override fun worm(worm: Boolean): FluentBuilder = apply { this.worm = worm }
    }
}
