// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * AttachVolumeInput
 */
class AttachVolumeRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique device ID or other distinguishing data that identifies the local disk used to
     * create the volume. This value is only required when you are attaching a stored
     * volume.
     */
    val diskId: String? = builder.diskId
    /**
     * The Amazon Resource Name (ARN) of the gateway that you want to attach the volume
     * to.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
     * addresses are accepted. Use DescribeGatewayInformation to get a list of
     * the network interfaces available on a gateway.
     * Valid Values: A valid IP address.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a
     * suffix for the target ARN. For example, specifying TargetName as
     * myvolume results in the target ARN of
     * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
     * The target name must be unique across all volumes on a gateway.
     * If you don't specify a value, Storage Gateway uses the value that was previously
     * used for this volume as the new target name.
     */
    val targetName: String? = builder.targetName
    /**
     * The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
     */
    val volumeArn: String? = builder.volumeArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AttachVolumeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AttachVolumeRequest(")
        append("diskId=$diskId,")
        append("gatewayArn=$gatewayArn,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("targetName=$targetName,")
        append("volumeArn=$volumeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = diskId?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AttachVolumeRequest

        if (diskId != other.diskId) return false
        if (gatewayArn != other.gatewayArn) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (targetName != other.targetName) return false
        if (volumeArn != other.volumeArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AttachVolumeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AttachVolumeRequest
        /**
         * The unique device ID or other distinguishing data that identifies the local disk used to
         * create the volume. This value is only required when you are attaching a stored
         * volume.
         */
        fun diskId(diskId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway that you want to attach the volume
         * to.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
         * addresses are accepted. Use DescribeGatewayInformation to get a list of
         * the network interfaces available on a gateway.
         * Valid Values: A valid IP address.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        fun targetName(targetName: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
         */
        fun volumeArn(volumeArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique device ID or other distinguishing data that identifies the local disk used to
         * create the volume. This value is only required when you are attaching a stored
         * volume.
         */
        var diskId: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway that you want to attach the volume
         * to.
         */
        var gatewayArn: String?
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4
         * addresses are accepted. Use DescribeGatewayInformation to get a list of
         * the network interfaces available on a gateway.
         * Valid Values: A valid IP address.
         */
        var networkInterfaceId: String?
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a
         * suffix for the target ARN. For example, specifying TargetName as
         * myvolume results in the target ARN of
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
         * The target name must be unique across all volumes on a gateway.
         * If you don't specify a value, Storage Gateway uses the value that was previously
         * used for this volume as the new target name.
         */
        var targetName: String?
        /**
         * The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
         */
        var volumeArn: String?

        fun build(): AttachVolumeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var diskId: String? = null
        override var gatewayArn: String? = null
        override var networkInterfaceId: String? = null
        override var targetName: String? = null
        override var volumeArn: String? = null

        constructor(x: AttachVolumeRequest) : this() {
            this.diskId = x.diskId
            this.gatewayArn = x.gatewayArn
            this.networkInterfaceId = x.networkInterfaceId
            this.targetName = x.targetName
            this.volumeArn = x.volumeArn
        }

        override fun build(): AttachVolumeRequest = AttachVolumeRequest(this)
        override fun diskId(diskId: String): FluentBuilder = apply { this.diskId = diskId }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun targetName(targetName: String): FluentBuilder = apply { this.targetName = targetName }
        override fun volumeArn(volumeArn: String): FluentBuilder = apply { this.volumeArn = volumeArn }
    }
}
