// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class AssociateFileSystemRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    val auditDestinationArn: String? = builder.auditDestinationArn
    /**
     * The refresh cache information for the file share or FSx file systems.
     */
    val cacheAttributes: CacheAttributes? = builder.cacheAttributes
    /**
     * A unique string value that you supply that is used by the FSx File Gateway to ensure
     * idempotent file system association creation.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
     * If multiple file systems are associated with this gateway, this parameter's IpAddresses field is required.
     */
    val endpointNetworkConfiguration: EndpointNetworkConfiguration? = builder.endpointNetworkConfiguration
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the
     * FSx File Gateway.
     */
    val locationArn: String? = builder.locationArn
    /**
     * The password of the user credential.
     */
    val password: String? = builder.password
    /**
     * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The user name of the user credential that has permission to access the root share D$ of
     * the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin
     * user group.
     */
    val userName: String? = builder.userName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssociateFileSystemRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateFileSystemRequest(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("clientToken=$clientToken,")
        append("endpointNetworkConfiguration=$endpointNetworkConfiguration,")
        append("gatewayArn=$gatewayArn,")
        append("locationArn=$locationArn,")
        append("password=*** Sensitive Data Redacted ***,")
        append("tags=$tags,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (endpointNetworkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssociateFileSystemRequest

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (clientToken != other.clientToken) return false
        if (endpointNetworkConfiguration != other.endpointNetworkConfiguration) return false
        if (gatewayArn != other.gatewayArn) return false
        if (locationArn != other.locationArn) return false
        if (password != other.password) return false
        if (tags != other.tags) return false
        if (userName != other.userName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssociateFileSystemRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssociateFileSystemRequest
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        fun auditDestinationArn(auditDestinationArn: String): FluentBuilder
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder
        /**
         * A unique string value that you supply that is used by the FSx File Gateway to ensure
         * idempotent file system association creation.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
         * If multiple file systems are associated with this gateway, this parameter's IpAddresses field is required.
         */
        fun endpointNetworkConfiguration(endpointNetworkConfiguration: EndpointNetworkConfiguration): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the
         * FSx File Gateway.
         */
        fun locationArn(locationArn: String): FluentBuilder
        /**
         * The password of the user credential.
         */
        fun password(password: String): FluentBuilder
        /**
         * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The user name of the user credential that has permission to access the root share D$ of
         * the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin
         * user group.
         */
        fun userName(userName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        var auditDestinationArn: String?
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        var cacheAttributes: CacheAttributes?
        /**
         * A unique string value that you supply that is used by the FSx File Gateway to ensure
         * idempotent file system association creation.
         */
        var clientToken: String?
        /**
         * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
         * If multiple file systems are associated with this gateway, this parameter's IpAddresses field is required.
         */
        var endpointNetworkConfiguration: EndpointNetworkConfiguration?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the
         * FSx File Gateway.
         */
        var locationArn: String?
        /**
         * The password of the user credential.
         */
        var password: String?
        /**
         * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
         */
        var tags: List<Tag>?
        /**
         * The user name of the user credential that has permission to access the root share D$ of
         * the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin
         * user group.
         */
        var userName: String?

        fun build(): AssociateFileSystemRequest
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        fun cacheAttributes(block: CacheAttributes.DslBuilder.() -> kotlin.Unit) {
            this.cacheAttributes = CacheAttributes.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration] inside the given [block]
         */
        fun endpointNetworkConfiguration(block: EndpointNetworkConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.endpointNetworkConfiguration = EndpointNetworkConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var auditDestinationArn: String? = null
        override var cacheAttributes: CacheAttributes? = null
        override var clientToken: String? = null
        override var endpointNetworkConfiguration: EndpointNetworkConfiguration? = null
        override var gatewayArn: String? = null
        override var locationArn: String? = null
        override var password: String? = null
        override var tags: List<Tag>? = null
        override var userName: String? = null

        constructor(x: AssociateFileSystemRequest) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.clientToken = x.clientToken
            this.endpointNetworkConfiguration = x.endpointNetworkConfiguration
            this.gatewayArn = x.gatewayArn
            this.locationArn = x.locationArn
            this.password = x.password
            this.tags = x.tags
            this.userName = x.userName
        }

        override fun build(): AssociateFileSystemRequest = AssociateFileSystemRequest(this)
        override fun auditDestinationArn(auditDestinationArn: String): FluentBuilder = apply { this.auditDestinationArn = auditDestinationArn }
        override fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder = apply { this.cacheAttributes = cacheAttributes }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun endpointNetworkConfiguration(endpointNetworkConfiguration: EndpointNetworkConfiguration): FluentBuilder = apply { this.endpointNetworkConfiguration = endpointNetworkConfiguration }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun locationArn(locationArn: String): FluentBuilder = apply { this.locationArn = locationArn }
        override fun password(password: String): FluentBuilder = apply { this.password = password }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun userName(userName: String): FluentBuilder = apply { this.userName = userName }
    }
}
