// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class AssignTapePoolRequest private constructor(builder: BuilderImpl) {
    /**
     * Set permissions to bypass governance retention. If the lock type of the archived tape is
     * Governance, the tape's archived age is not older than
     * RetentionLockInDays, and the user does not already have
     * BypassGovernanceRetention, setting this to TRUE enables the user to bypass
     * the retention lock. This parameter is set to true by default for calls from the
     * console.
     * Valid values: TRUE | FALSE
     */
    val bypassGovernanceRetention: Boolean = builder.bypassGovernanceRetention
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this
     * pool is archived in the S3 storage class that is associated with the pool. When you use
     * your backup application to eject the tape, the tape is archived directly into the storage
     * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    val poolId: String? = builder.poolId
    /**
     * The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the
     * tape pool.
     */
    val tapeArn: String? = builder.tapeArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssignTapePoolRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssignTapePoolRequest(")
        append("bypassGovernanceRetention=$bypassGovernanceRetention,")
        append("poolId=$poolId,")
        append("tapeArn=$tapeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassGovernanceRetention.hashCode()
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssignTapePoolRequest

        if (bypassGovernanceRetention != other.bypassGovernanceRetention) return false
        if (poolId != other.poolId) return false
        if (tapeArn != other.tapeArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssignTapePoolRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssignTapePoolRequest
        /**
         * Set permissions to bypass governance retention. If the lock type of the archived tape is
         * Governance, the tape's archived age is not older than
         * RetentionLockInDays, and the user does not already have
         * BypassGovernanceRetention, setting this to TRUE enables the user to bypass
         * the retention lock. This parameter is set to true by default for calls from the
         * console.
         * Valid values: TRUE | FALSE
         */
        fun bypassGovernanceRetention(bypassGovernanceRetention: Boolean): FluentBuilder
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        fun poolId(poolId: String): FluentBuilder
        /**
         * The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the
         * tape pool.
         */
        fun tapeArn(tapeArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Set permissions to bypass governance retention. If the lock type of the archived tape is
         * Governance, the tape's archived age is not older than
         * RetentionLockInDays, and the user does not already have
         * BypassGovernanceRetention, setting this to TRUE enables the user to bypass
         * the retention lock. This parameter is set to true by default for calls from the
         * console.
         * Valid values: TRUE | FALSE
         */
        var bypassGovernanceRetention: Boolean
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this
         * pool is archived in the S3 storage class that is associated with the pool. When you use
         * your backup application to eject the tape, the tape is archived directly into the storage
         * class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         * Valid Values: GLACIER | DEEP_ARCHIVE
         */
        var poolId: String?
        /**
         * The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the
         * tape pool.
         */
        var tapeArn: String?

        fun build(): AssignTapePoolRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bypassGovernanceRetention: Boolean = false
        override var poolId: String? = null
        override var tapeArn: String? = null

        constructor(x: AssignTapePoolRequest) : this() {
            this.bypassGovernanceRetention = x.bypassGovernanceRetention
            this.poolId = x.poolId
            this.tapeArn = x.tapeArn
        }

        override fun build(): AssignTapePoolRequest = AssignTapePoolRequest(this)
        override fun bypassGovernanceRetention(bypassGovernanceRetention: Boolean): FluentBuilder = apply { this.bypassGovernanceRetention = bypassGovernanceRetention }
        override fun poolId(poolId: String): FluentBuilder = apply { this.poolId = poolId }
        override fun tapeArn(tapeArn: String): FluentBuilder = apply { this.tapeArn = tapeArn }
    }
}
