// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Storage Gateway returns the Amazon Resource Name (ARN) of the activated gateway. It
 * is a string made of information such as your account, gateway name, and Region. This
 * ARN is used to reference the gateway in other API operations as well as resource-based
 * authorization.
 * For gateways activated prior to September 02, 2015, the gateway ARN contains the
 * gateway name rather than the gateway ID. Changing the name of the gateway has no effect
 * on the gateway ARN.
 */
class ActivateGatewayResponse private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ActivateGatewayResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ActivateGatewayResponse(")
        append("gatewayArn=$gatewayArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ActivateGatewayResponse

        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ActivateGatewayResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ActivateGatewayResponse
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?

        fun build(): ActivateGatewayResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null

        constructor(x: ActivateGatewayResponse) : this() {
            this.gatewayArn = x.gatewayArn
        }

        override fun build(): ActivateGatewayResponse = ActivateGatewayResponse(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
    }
}
