// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * A JSON object containing one or more of the following fields:
 * ActivateGatewayInput$ActivationKey
 * ActivateGatewayInput$GatewayName
 * ActivateGatewayInput$GatewayRegion
 * ActivateGatewayInput$GatewayTimezone
 * ActivateGatewayInput$GatewayType
 * ActivateGatewayInput$MediumChangerType
 * ActivateGatewayInput$TapeDriveType
 */
class ActivateGatewayRequest private constructor(builder: BuilderImpl) {
    /**
     * Your gateway activation key. You can obtain the activation key by sending an HTTP GET
     * request with redirects enabled to the gateway IP address (port 80). The redirect URL
     * returned in the response provides you the activation key for your gateway in the query
     * string parameter activationKey. It may also include other activation-related
     * parameters, however, these are merely defaults -- the arguments you pass to the
     * ActivateGateway API call determine the actual configuration of your
     * gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
     * key in the Storage Gateway User Guide.
     */
    val activationKey: String? = builder.activationKey
    /**
     * The name you configured for your gateway.
     */
    val gatewayName: String? = builder.gatewayName
    /**
     * A value that indicates the Region where you want to store your data.
     * The gateway Region specified must be the same Region
     * as the Region in your Host
     * header in the request. For more information about available Regions and endpoints for
     * Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
     * Storage Gateway endpoints and quotas in the Amazon Web Services General
     * Reference.
     * Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
     * Storage Gateway endpoints and quotas in the Amazon Web Services General
     * Reference.
     */
    val gatewayRegion: String? = builder.gatewayRegion
    /**
     * A value that indicates the time zone you want to set for the gateway. The time zone is
     * of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4
     * hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is
     * used, for example, for scheduling snapshots and your gateway's maintenance
     * schedule.
     */
    val gatewayTimezone: String? = builder.gatewayTimezone
    /**
     * A value that defines the type of gateway to activate. The type specified is critical to
     * all later functions of the gateway and cannot be changed after activation. The default
     * value is CACHED.
     * Valid Values: STORED | CACHED | VTL |
     * FILE_S3 | FILE_FSX_SMB|
     */
    val gatewayType: String? = builder.gatewayType
    /**
     * The value that indicates the type of medium changer to use for tape gateway. This field
     * is optional.
     * Valid Values: STK-L700 | AWS-Gateway-VTL |
     * IBM-03584L32-0402
     */
    val mediumChangerType: String? = builder.mediumChangerType
    /**
     * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value
     * pair.
     * Valid characters for key and value are letters, spaces, and numbers that can be
     * represented in UTF-8 format, and the following special characters: + - = . _ : / @. The
     * maximum length of a tag's key is 128 characters, and the maximum length for a
     * tag's value is 256 characters.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The value that indicates the type of tape drive to use for tape gateway. This field is
     * optional.
     * Valid Values: IBM-ULT3580-TD5
     */
    val tapeDriveType: String? = builder.tapeDriveType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ActivateGatewayRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ActivateGatewayRequest(")
        append("activationKey=$activationKey,")
        append("gatewayName=$gatewayName,")
        append("gatewayRegion=$gatewayRegion,")
        append("gatewayTimezone=$gatewayTimezone,")
        append("gatewayType=$gatewayType,")
        append("mediumChangerType=$mediumChangerType,")
        append("tags=$tags,")
        append("tapeDriveType=$tapeDriveType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationKey?.hashCode() ?: 0
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayRegion?.hashCode() ?: 0)
        result = 31 * result + (gatewayTimezone?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (mediumChangerType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tapeDriveType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ActivateGatewayRequest

        if (activationKey != other.activationKey) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayRegion != other.gatewayRegion) return false
        if (gatewayTimezone != other.gatewayTimezone) return false
        if (gatewayType != other.gatewayType) return false
        if (mediumChangerType != other.mediumChangerType) return false
        if (tags != other.tags) return false
        if (tapeDriveType != other.tapeDriveType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ActivateGatewayRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ActivateGatewayRequest
        /**
         * Your gateway activation key. You can obtain the activation key by sending an HTTP GET
         * request with redirects enabled to the gateway IP address (port 80). The redirect URL
         * returned in the response provides you the activation key for your gateway in the query
         * string parameter activationKey. It may also include other activation-related
         * parameters, however, these are merely defaults -- the arguments you pass to the
         * ActivateGateway API call determine the actual configuration of your
         * gateway.
         * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
         * key in the Storage Gateway User Guide.
         */
        fun activationKey(activationKey: String): FluentBuilder
        /**
         * The name you configured for your gateway.
         */
        fun gatewayName(gatewayName: String): FluentBuilder
        /**
         * A value that indicates the Region where you want to store your data.
         * The gateway Region specified must be the same Region
         * as the Region in your Host
         * header in the request. For more information about available Regions and endpoints for
         * Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
         * Storage Gateway endpoints and quotas in the Amazon Web Services General
         * Reference.
         * Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
         * Storage Gateway endpoints and quotas in the Amazon Web Services General
         * Reference.
         */
        fun gatewayRegion(gatewayRegion: String): FluentBuilder
        /**
         * A value that indicates the time zone you want to set for the gateway. The time zone is
         * of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4
         * hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is
         * used, for example, for scheduling snapshots and your gateway's maintenance
         * schedule.
         */
        fun gatewayTimezone(gatewayTimezone: String): FluentBuilder
        /**
         * A value that defines the type of gateway to activate. The type specified is critical to
         * all later functions of the gateway and cannot be changed after activation. The default
         * value is CACHED.
         * Valid Values: STORED | CACHED | VTL |
         * FILE_S3 | FILE_FSX_SMB|
         */
        fun gatewayType(gatewayType: String): FluentBuilder
        /**
         * The value that indicates the type of medium changer to use for tape gateway. This field
         * is optional.
         * Valid Values: STK-L700 | AWS-Gateway-VTL |
         * IBM-03584L32-0402
         */
        fun mediumChangerType(mediumChangerType: String): FluentBuilder
        /**
         * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers that can be
         * represented in UTF-8 format, and the following special characters: + - = . _ : / @. The
         * maximum length of a tag's key is 128 characters, and the maximum length for a
         * tag's value is 256 characters.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The value that indicates the type of tape drive to use for tape gateway. This field is
         * optional.
         * Valid Values: IBM-ULT3580-TD5
         */
        fun tapeDriveType(tapeDriveType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Your gateway activation key. You can obtain the activation key by sending an HTTP GET
         * request with redirects enabled to the gateway IP address (port 80). The redirect URL
         * returned in the response provides you the activation key for your gateway in the query
         * string parameter activationKey. It may also include other activation-related
         * parameters, however, these are merely defaults -- the arguments you pass to the
         * ActivateGateway API call determine the actual configuration of your
         * gateway.
         * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
         * key in the Storage Gateway User Guide.
         */
        var activationKey: String?
        /**
         * The name you configured for your gateway.
         */
        var gatewayName: String?
        /**
         * A value that indicates the Region where you want to store your data.
         * The gateway Region specified must be the same Region
         * as the Region in your Host
         * header in the request. For more information about available Regions and endpoints for
         * Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
         * Storage Gateway endpoints and quotas in the Amazon Web Services General
         * Reference.
         * Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">
         * Storage Gateway endpoints and quotas in the Amazon Web Services General
         * Reference.
         */
        var gatewayRegion: String?
        /**
         * A value that indicates the time zone you want to set for the gateway. The time zone is
         * of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4
         * hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is
         * used, for example, for scheduling snapshots and your gateway's maintenance
         * schedule.
         */
        var gatewayTimezone: String?
        /**
         * A value that defines the type of gateway to activate. The type specified is critical to
         * all later functions of the gateway and cannot be changed after activation. The default
         * value is CACHED.
         * Valid Values: STORED | CACHED | VTL |
         * FILE_S3 | FILE_FSX_SMB|
         */
        var gatewayType: String?
        /**
         * The value that indicates the type of medium changer to use for tape gateway. This field
         * is optional.
         * Valid Values: STK-L700 | AWS-Gateway-VTL |
         * IBM-03584L32-0402
         */
        var mediumChangerType: String?
        /**
         * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers that can be
         * represented in UTF-8 format, and the following special characters: + - = . _ : / @. The
         * maximum length of a tag's key is 128 characters, and the maximum length for a
         * tag's value is 256 characters.
         */
        var tags: List<Tag>?
        /**
         * The value that indicates the type of tape drive to use for tape gateway. This field is
         * optional.
         * Valid Values: IBM-ULT3580-TD5
         */
        var tapeDriveType: String?

        fun build(): ActivateGatewayRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activationKey: String? = null
        override var gatewayName: String? = null
        override var gatewayRegion: String? = null
        override var gatewayTimezone: String? = null
        override var gatewayType: String? = null
        override var mediumChangerType: String? = null
        override var tags: List<Tag>? = null
        override var tapeDriveType: String? = null

        constructor(x: ActivateGatewayRequest) : this() {
            this.activationKey = x.activationKey
            this.gatewayName = x.gatewayName
            this.gatewayRegion = x.gatewayRegion
            this.gatewayTimezone = x.gatewayTimezone
            this.gatewayType = x.gatewayType
            this.mediumChangerType = x.mediumChangerType
            this.tags = x.tags
            this.tapeDriveType = x.tapeDriveType
        }

        override fun build(): ActivateGatewayRequest = ActivateGatewayRequest(this)
        override fun activationKey(activationKey: String): FluentBuilder = apply { this.activationKey = activationKey }
        override fun gatewayName(gatewayName: String): FluentBuilder = apply { this.gatewayName = gatewayName }
        override fun gatewayRegion(gatewayRegion: String): FluentBuilder = apply { this.gatewayRegion = gatewayRegion }
        override fun gatewayTimezone(gatewayTimezone: String): FluentBuilder = apply { this.gatewayTimezone = gatewayTimezone }
        override fun gatewayType(gatewayType: String): FluentBuilder = apply { this.gatewayType = gatewayType }
        override fun mediumChangerType(mediumChangerType: String): FluentBuilder = apply { this.mediumChangerType = mediumChangerType }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun tapeDriveType(tapeDriveType: String): FluentBuilder = apply { this.tapeDriveType = tapeDriveType }
    }
}
