// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.regions.resolveRegionForOperation
import aws.sdk.kotlin.services.storagegateway.model.*
import aws.sdk.kotlin.services.storagegateway.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Storage Gateway"
const val ServiceApiVersion: String = "2013-06-30"
const val SdkVersion: String = "0.6.0-alpha"

internal class DefaultStorageGatewayClient(override val config: StorageGatewayClient.Config) : StorageGatewayClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine(HttpClientEngineConfig())
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Activates the gateway you previously deployed on your host. In the activation process,
     * you specify information such as the Region that you want to use for storing snapshots
     * or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an
     * activation key, and a name for your gateway. The activation process also associates your
     * gateway with your account. For more information, see UpdateGatewayInformation.
     * You must turn on the gateway VM before you can activate your gateway.
     */
    override suspend fun activateGateway(input: ActivateGatewayRequest): ActivateGatewayResponse {
        val op = SdkHttpOperation.build<ActivateGatewayRequest, ActivateGatewayResponse> {
            serializer = ActivateGatewayOperationSerializer()
            deserializer = ActivateGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ActivateGateway"
            }
        }
        registerActivateGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures one or more gateway local disks as cache for a gateway. This operation is
     * only supported in the cached volume, tape, and file gateway type (see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">How Storage Gateway works (architecture).
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to
     * add cache, and one or more disk IDs that you want to configure as cache.
     */
    override suspend fun addCache(input: AddCacheRequest): AddCacheResponse {
        val op = SdkHttpOperation.build<AddCacheRequest, AddCacheResponse> {
            serializer = AddCacheOperationSerializer()
            deserializer = AddCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddCache"
            }
        }
        registerAddCacheMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to the specified resource. You use tags to add metadata to
     * resources, which you can use to categorize these resources. For example, you can categorize
     * resources by purpose, owner, environment, or team. Each tag consists of a key and a value,
     * which you define. You can add tags to the following Storage Gateway resources:
     * Storage gateways of all types
     * Storage volumes
     * Virtual tapes
     * NFS and SMB file shares
     * File System associations
     * You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes
     * that are recovered to a new gateway maintain their tags.
     */
    override suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse {
        val op = SdkHttpOperation.build<AddTagsToResourceRequest, AddTagsToResourceResponse> {
            serializer = AddTagsToResourceOperationSerializer()
            deserializer = AddTagsToResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTagsToResource"
            }
        }
        registerAddTagsToResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures one or more gateway local disks as upload buffer for a specified gateway.
     * This operation is supported for the stored volume, cached volume, and tape gateway
     * types.
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to
     * add upload buffer, and one or more disk IDs that you want to configure as upload
     * buffer.
     */
    override suspend fun addUploadBuffer(input: AddUploadBufferRequest): AddUploadBufferResponse {
        val op = SdkHttpOperation.build<AddUploadBufferRequest, AddUploadBufferResponse> {
            serializer = AddUploadBufferOperationSerializer()
            deserializer = AddUploadBufferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddUploadBuffer"
            }
        }
        registerAddUploadBufferMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures one or more gateway local disks as working storage for a gateway. This
     * operation is only supported in the stored volume gateway type. This operation is deprecated
     * in cached volume API version 20120630. Use AddUploadBuffer
     * instead.
     * Working storage is also referred to as upload buffer. You can also use the AddUploadBuffer operation to add upload buffer to a stored volume
     * gateway.
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to
     * add working storage, and one or more disk IDs that you want to configure as working
     * storage.
     */
    override suspend fun addWorkingStorage(input: AddWorkingStorageRequest): AddWorkingStorageResponse {
        val op = SdkHttpOperation.build<AddWorkingStorageRequest, AddWorkingStorageResponse> {
            serializer = AddWorkingStorageOperationSerializer()
            deserializer = AddWorkingStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddWorkingStorage"
            }
        }
        registerAddWorkingStorageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in
     * the S3 storage class that is associated with the pool. When you use your backup application
     * to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or
     * S3 Glacier Deep Archive) that corresponds to the pool.
     * Valid Values: GLACIER | DEEP_ARCHIVE
     */
    override suspend fun assignTapePool(input: AssignTapePoolRequest): AssignTapePoolResponse {
        val op = SdkHttpOperation.build<AssignTapePoolRequest, AssignTapePoolResponse> {
            serializer = AssignTapePoolOperationSerializer()
            deserializer = AssignTapePoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssignTapePool"
            }
        }
        registerAssignTapePoolMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Associate an Amazon FSx file system with the FSx File Gateway. After the
     * association process is complete, the file shares on the Amazon FSx file system are
     * available for access through the gateway. This operation only supports the FSx File
     * Gateway type.
     */
    override suspend fun associateFileSystem(input: AssociateFileSystemRequest): AssociateFileSystemResponse {
        val op = SdkHttpOperation.build<AssociateFileSystemRequest, AssociateFileSystemResponse> {
            serializer = AssociateFileSystemOperationSerializer()
            deserializer = AssociateFileSystemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateFileSystem"
            }
        }
        registerAssociateFileSystemMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Connects a volume to an iSCSI connection and then attaches the volume to the specified
     * gateway. Detaching and attaching a volume enables you to recover your data from one gateway
     * to a different gateway without creating a snapshot. It also makes it easier to move your
     * volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.
     */
    override suspend fun attachVolume(input: AttachVolumeRequest): AttachVolumeResponse {
        val op = SdkHttpOperation.build<AttachVolumeRequest, AttachVolumeResponse> {
            serializer = AttachVolumeOperationSerializer()
            deserializer = AttachVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachVolume"
            }
        }
        registerAttachVolumeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving
     * process is initiated. This operation is only supported in the tape gateway type.
     */
    override suspend fun cancelArchival(input: CancelArchivalRequest): CancelArchivalResponse {
        val op = SdkHttpOperation.build<CancelArchivalRequest, CancelArchivalResponse> {
            serializer = CancelArchivalOperationSerializer()
            deserializer = CancelArchivalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelArchival"
            }
        }
        registerCancelArchivalMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after
     * the retrieval process is initiated. The virtual tape is returned to the VTS. This operation
     * is only supported in the tape gateway type.
     */
    override suspend fun cancelRetrieval(input: CancelRetrievalRequest): CancelRetrievalResponse {
        val op = SdkHttpOperation.build<CancelRetrievalRequest, CancelRetrievalResponse> {
            serializer = CancelRetrievalOperationSerializer()
            deserializer = CancelRetrievalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelRetrieval"
            }
        }
        registerCancelRetrievalMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a cached volume on a specified cached volume gateway. This operation is only
     * supported in the cached volume gateway type.
     * Cache storage must be allocated to the gateway before you can create a cached volume.
     * Use the AddCache operation to add cache storage to a gateway.
     * In the request, you must specify the gateway, size of the volume in bytes, the iSCSI
     * target name, an IP address on which to expose the target, and a unique client token. In
     * response, the gateway creates the volume and returns information about it. This information
     * includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that
     * initiators can use to connect to the volume target.
     * Optionally, you can provide the ARN for an existing volume as the
     * SourceVolumeARN for this cached volume, which creates an exact copy of the
     * existing volume’s latest recovery point. The VolumeSizeInBytes value must be
     * equal to or larger than the size of the copied volume, in bytes.
     */
    override suspend fun createCachediScsiVolume(input: CreateCachediScsiVolumeRequest): CreateCachediScsiVolumeResponse {
        val op = SdkHttpOperation.build<CreateCachediScsiVolumeRequest, CreateCachediScsiVolumeResponse> {
            serializer = CreateCachediSCSIVolumeOperationSerializer()
            deserializer = CreateCachediSCSIVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCachediSCSIVolume"
            }
        }
        registerCreateCachediScsiVolumeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage
     * Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage.
     * Storage Gateway exposes file shares using an NFS interface. This operation is only
     * supported for S3 File Gateways.
     * S3 File gateway requires Security Token Service (STS) to be activated to enable
     * you to create a file share. Make sure STS is activated in the Region you are
     * creating your S3 File Gateway in. If STS is not activated in the Region, activate
     * it. For information about how to activate STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating STS in an Region in the
     * Identity and Access Management User Guide.
     * S3 File Gateways do not support creating hard or symbolic links on a file share.
     */
    override suspend fun createNfsFileShare(input: CreateNfsFileShareRequest): CreateNfsFileShareResponse {
        val op = SdkHttpOperation.build<CreateNfsFileShareRequest, CreateNfsFileShareResponse> {
            serializer = CreateNFSFileShareOperationSerializer()
            deserializer = CreateNFSFileShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNFSFileShare"
            }
        }
        registerCreateNfsFileShareMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage
     * Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage.
     * Storage Gateway exposes file shares using an SMB interface. This operation is only
     * supported for S3 File Gateways.
     * S3 File Gateways require Security Token Service (STS) to be activated to enable
     * you to create a file share. Make sure that STS is activated in the Region you
     * are creating your S3 File Gateway in. If STS is not activated in this Region,
     * activate it. For information about how to activate STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating STS in an Region in the
     * Identity and Access Management User Guide.
     * File gateways don't support creating hard or symbolic links on a file
     * share.
     */
    override suspend fun createSmbFileShare(input: CreateSmbFileShareRequest): CreateSmbFileShareResponse {
        val op = SdkHttpOperation.build<CreateSmbFileShareRequest, CreateSmbFileShareResponse> {
            serializer = CreateSMBFileShareOperationSerializer()
            deserializer = CreateSMBFileShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSMBFileShare"
            }
        }
        registerCreateSmbFileShareMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates a snapshot of a volume.
     * Storage Gateway provides the ability to back up point-in-time snapshots of your data
     * to Amazon Simple Storage (Amazon S3) for durable off-site recovery, and also import the
     * data to an Amazon Elastic Block Store (EBS) volume in Amazon Elastic Compute Cloud (EC2).
     * You can take snapshots of your gateway volume on a scheduled or ad hoc basis. This API
     * enables you to take an ad hoc snapshot. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot">Editing a
     * snapshot schedule.
     * In the CreateSnapshot request, you identify the volume by providing its
     * Amazon Resource Name (ARN). You must also provide description for the snapshot. When
     * Storage Gateway takes the snapshot of specified volume, the snapshot and description
     * appears in the Storage Gateway console. In response, Storage Gateway returns you a
     * snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it
     * when you want to create a volume from a snapshot. This operation is only supported in
     * stored and cached volume gateway type.
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots
     * or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot in the Amazon Elastic Compute Cloud API
     * Reference.
     * Volume and snapshot IDs are changing to a longer length ID format. For more
     * information, see the important note on the <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome page.
     */
    override suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse {
        val op = SdkHttpOperation.build<CreateSnapshotRequest, CreateSnapshotResponse> {
            serializer = CreateSnapshotOperationSerializer()
            deserializer = CreateSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshot"
            }
        }
        registerCreateSnapshotMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates a snapshot of a gateway from a volume recovery point. This operation is only
     * supported in the cached volume gateway type.
     * A volume recovery point is a point in time at which all data of the volume is consistent
     * and from which you can create a snapshot. To get a list of volume recovery point for cached
     * volume gateway, use ListVolumeRecoveryPoints.
     * In the CreateSnapshotFromVolumeRecoveryPoint request, you identify the
     * volume by providing its Amazon Resource Name (ARN). You must also provide a description for
     * the snapshot. When the gateway takes a snapshot of the specified volume, the snapshot and
     * its description appear in the Storage Gateway console.
     * In response, the gateway returns
     * you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use
     * it when you want to create a volume from a snapshot.
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots
     * or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot in the Amazon Elastic Compute Cloud API
     * Reference.
     */
    override suspend fun createSnapshotFromVolumeRecoveryPoint(input: CreateSnapshotFromVolumeRecoveryPointRequest): CreateSnapshotFromVolumeRecoveryPointResponse {
        val op = SdkHttpOperation.build<CreateSnapshotFromVolumeRecoveryPointRequest, CreateSnapshotFromVolumeRecoveryPointResponse> {
            serializer = CreateSnapshotFromVolumeRecoveryPointOperationSerializer()
            deserializer = CreateSnapshotFromVolumeRecoveryPointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshotFromVolumeRecoveryPoint"
            }
        }
        registerCreateSnapshotFromVolumeRecoveryPointMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a volume on a specified gateway. This operation is only supported in the stored
     * volume gateway type.
     * The size of the volume to create is inferred from the disk size. You can choose to
     * preserve existing data on the disk, create volume from an existing snapshot, or create an
     * empty volume. If you choose to create an empty gateway volume, then any existing data on
     * the disk is erased.
     * In the request, you must specify the gateway and the disk information on which you are
     * creating the volume. In response, the gateway creates the volume and returns volume
     * information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target
     * ARN that initiators can use to connect to the volume target.
     */
    override suspend fun createStorediScsiVolume(input: CreateStorediScsiVolumeRequest): CreateStorediScsiVolumeResponse {
        val op = SdkHttpOperation.build<CreateStorediScsiVolumeRequest, CreateStorediScsiVolumeResponse> {
            serializer = CreateStorediSCSIVolumeOperationSerializer()
            deserializer = CreateStorediSCSIVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStorediSCSIVolume"
            }
        }
        registerCreateStorediScsiVolumeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom tape pool. You can use custom tape pool to enable tape retention
     * lock on tapes that are archived in the custom pool.
     */
    override suspend fun createTapePool(input: CreateTapePoolRequest): CreateTapePoolResponse {
        val op = SdkHttpOperation.build<CreateTapePoolRequest, CreateTapePoolResponse> {
            serializer = CreateTapePoolOperationSerializer()
            deserializer = CreateTapePoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTapePool"
            }
        }
        registerCreateTapePoolMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a virtual tape by using your own barcode. You write data to the virtual tape and
     * then archive the tape. A barcode is unique and cannot be reused if it has already been used
     * on a tape. This applies to barcodes used on deleted tapes. This operation is only supported
     * in the tape gateway type.
     * Cache storage must be allocated to the gateway before you can create a virtual tape.
     * Use the AddCache operation to add cache storage to a gateway.
     */
    override suspend fun createTapeWithBarcode(input: CreateTapeWithBarcodeRequest): CreateTapeWithBarcodeResponse {
        val op = SdkHttpOperation.build<CreateTapeWithBarcodeRequest, CreateTapeWithBarcodeResponse> {
            serializer = CreateTapeWithBarcodeOperationSerializer()
            deserializer = CreateTapeWithBarcodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTapeWithBarcode"
            }
        }
        registerCreateTapeWithBarcodeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates one or more virtual tapes. You write data to the virtual tapes and then archive
     * the tapes. This operation is only supported in the tape gateway type.
     * Cache storage must be allocated to the gateway before you can create virtual tapes.
     * Use the AddCache operation to add cache storage to a gateway.
     */
    override suspend fun createTapes(input: CreateTapesRequest): CreateTapesResponse {
        val op = SdkHttpOperation.build<CreateTapesRequest, CreateTapesResponse> {
            serializer = CreateTapesOperationSerializer()
            deserializer = CreateTapesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTapes"
            }
        }
        registerCreateTapesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the automatic tape creation policy of a gateway. If you delete this policy, new
     * virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway
     * in your request to remove the policy.
     */
    override suspend fun deleteAutomaticTapeCreationPolicy(input: DeleteAutomaticTapeCreationPolicyRequest): DeleteAutomaticTapeCreationPolicyResponse {
        val op = SdkHttpOperation.build<DeleteAutomaticTapeCreationPolicyRequest, DeleteAutomaticTapeCreationPolicyResponse> {
            serializer = DeleteAutomaticTapeCreationPolicyOperationSerializer()
            deserializer = DeleteAutomaticTapeCreationPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAutomaticTapeCreationPolicy"
            }
        }
        registerDeleteAutomaticTapeCreationPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the bandwidth rate limits of a gateway. You can delete either the upload and
     * download bandwidth rate limit, or you can delete both. If you delete only one of the
     * limits, the other limit remains unchanged. To specify which gateway to work with, use the
     * Amazon Resource Name (ARN) of the gateway in your request. This operation is supported for
     * the stored volume, cached volume and tape gateway types.
     */
    override suspend fun deleteBandwidthRateLimit(input: DeleteBandwidthRateLimitRequest): DeleteBandwidthRateLimitResponse {
        val op = SdkHttpOperation.build<DeleteBandwidthRateLimitRequest, DeleteBandwidthRateLimitResponse> {
            serializer = DeleteBandwidthRateLimitOperationSerializer()
            deserializer = DeleteBandwidthRateLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBandwidthRateLimit"
            }
        }
        registerDeleteBandwidthRateLimitMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified
     * iSCSI target and initiator pair. This operation is supported in volume and tape gateway
     * types.
     */
    override suspend fun deleteChapCredentials(input: DeleteChapCredentialsRequest): DeleteChapCredentialsResponse {
        val op = SdkHttpOperation.build<DeleteChapCredentialsRequest, DeleteChapCredentialsResponse> {
            serializer = DeleteChapCredentialsOperationSerializer()
            deserializer = DeleteChapCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteChapCredentials"
            }
        }
        registerDeleteChapCredentialsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File
     * Gateways.
     */
    override suspend fun deleteFileShare(input: DeleteFileShareRequest): DeleteFileShareResponse {
        val op = SdkHttpOperation.build<DeleteFileShareRequest, DeleteFileShareResponse> {
            serializer = DeleteFileShareOperationSerializer()
            deserializer = DeleteFileShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFileShare"
            }
        }
        registerDeleteFileShareMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name
     * (ARN) of the gateway in your request. The operation deletes the gateway; however, it does
     * not delete the gateway virtual machine (VM) from your host computer.
     * After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway
     * volumes are not deleted upon deleting the gateway, however, pending snapshots will not
     * complete. After you delete a gateway, your next step is to remove it from your
     * environment.
     * You no longer pay software charges after the gateway is deleted; however, your
     * existing Amazon EBS snapshots persist and you will continue to be billed for these
     * snapshots. You can choose to remove all remaining Amazon EBS snapshots by canceling your
     * Amazon EC2 subscription.  If you prefer not to cancel your Amazon EC2 subscription, you
     * can delete your snapshots using the Amazon EC2 console. For more information, see the
     * <a href="http://aws.amazon.com/storagegateway">Storage Gateway detail
     * page.
     */
    override suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse {
        val op = SdkHttpOperation.build<DeleteGatewayRequest, DeleteGatewayResponse> {
            serializer = DeleteGatewayOperationSerializer()
            deserializer = DeleteGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGateway"
            }
        }
        registerDeleteGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a snapshot of a volume.
     * You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API
     * action enables you to delete a snapshot schedule for a volume. For more information, see
     * <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html">Backing up your
     * volumes. In the DeleteSnapshotSchedule request, you identify the
     * volume by providing its Amazon Resource Name (ARN). This operation is only supported in
     * stored and cached volume gateway types.
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
     * go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots
     * in the Amazon Elastic Compute Cloud API Reference.
     */
    override suspend fun deleteSnapshotSchedule(input: DeleteSnapshotScheduleRequest): DeleteSnapshotScheduleResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotScheduleRequest, DeleteSnapshotScheduleResponse> {
            serializer = DeleteSnapshotScheduleOperationSerializer()
            deserializer = DeleteSnapshotScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSnapshotSchedule"
            }
        }
        registerDeleteSnapshotScheduleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified virtual tape. This operation is only supported in the tape gateway
     * type.
     */
    override suspend fun deleteTape(input: DeleteTapeRequest): DeleteTapeResponse {
        val op = SdkHttpOperation.build<DeleteTapeRequest, DeleteTapeResponse> {
            serializer = DeleteTapeOperationSerializer()
            deserializer = DeleteTapeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTape"
            }
        }
        registerDeleteTapeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is
     * only supported in the tape gateway type.
     */
    override suspend fun deleteTapeArchive(input: DeleteTapeArchiveRequest): DeleteTapeArchiveResponse {
        val op = SdkHttpOperation.build<DeleteTapeArchiveRequest, DeleteTapeArchiveResponse> {
            serializer = DeleteTapeArchiveOperationSerializer()
            deserializer = DeleteTapeArchiveOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTapeArchive"
            }
        }
        registerDeleteTapeArchiveMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes
     * in the pool and if there are no automatic tape creation policies that reference the custom
     * tape pool.
     */
    override suspend fun deleteTapePool(input: DeleteTapePoolRequest): DeleteTapePoolResponse {
        val op = SdkHttpOperation.build<DeleteTapePoolRequest, DeleteTapePoolResponse> {
            serializer = DeleteTapePoolOperationSerializer()
            deserializer = DeleteTapePoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTapePool"
            }
        }
        registerDeleteTapePoolMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified storage volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API.
     * This operation is only supported in the cached volume and stored volume types. For stored
     * volume gateways, the local disk that was configured as the storage volume is not deleted.
     * You can reuse the local disk to create another storage volume.
     * Before you delete a volume, make sure there are no iSCSI connections to the volume you
     * are deleting. You should also make sure there is no snapshot in progress. You can use the
     * Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are
     * deleting and check the snapshot status. For more information, go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots in the Amazon Elastic Compute Cloud API
     * Reference.
     * In the request, you must provide the Amazon Resource Name (ARN) of the storage volume
     * you want to delete.
     */
    override suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse {
        val op = SdkHttpOperation.build<DeleteVolumeRequest, DeleteVolumeResponse> {
            serializer = DeleteVolumeOperationSerializer()
            deserializer = DeleteVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVolume"
            }
        }
        registerDeleteVolumeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the most recent high availability monitoring test that was
     * performed on the host in a cluster. If a test isn't performed, the status and start
     * time in the response would be null.
     */
    override suspend fun describeAvailabilityMonitorTest(input: DescribeAvailabilityMonitorTestRequest): DescribeAvailabilityMonitorTestResponse {
        val op = SdkHttpOperation.build<DescribeAvailabilityMonitorTestRequest, DescribeAvailabilityMonitorTestResponse> {
            serializer = DescribeAvailabilityMonitorTestOperationSerializer()
            deserializer = DescribeAvailabilityMonitorTestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAvailabilityMonitorTest"
            }
        }
        registerDescribeAvailabilityMonitorTestMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the bandwidth rate limits of a gateway. By default, these limits are not set,
     * which means no bandwidth rate limiting is in effect. This operation is supported for the
     * stored volume, cached volume, and tape gateway types.
     * This operation only returns a value for a bandwidth rate limit only if the limit is set.
     * If no limits are set for the gateway, then this operation returns only the gateway ARN in
     * the response body. To specify which gateway to describe, use the Amazon Resource Name (ARN)
     * of the gateway in your request.
     */
    override suspend fun describeBandwidthRateLimit(input: DescribeBandwidthRateLimitRequest): DescribeBandwidthRateLimitResponse {
        val op = SdkHttpOperation.build<DescribeBandwidthRateLimitRequest, DescribeBandwidthRateLimitResponse> {
            serializer = DescribeBandwidthRateLimitOperationSerializer()
            deserializer = DescribeBandwidthRateLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBandwidthRateLimit"
            }
        }
        registerDescribeBandwidthRateLimitMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do
     * not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This
     * operation is supported only in the volume and tape gateway types.
     * This operation returns information about a gateway's bandwidth rate limit schedule. A bandwidth
     * rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit
     * interval defines a period of time on one or more days of the week, during which bandwidth rate
     * limits are specified for uploading, downloading, or both.
     * A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute,
     * an ending hour and minute, and bandwidth rate limits for uploading and downloading
     * If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an
     * empty response. To specify which gateway to describe, use the Amazon Resource Name (ARN)
     * of the gateway in your request.
     */
    override suspend fun describeBandwidthRateLimitSchedule(input: DescribeBandwidthRateLimitScheduleRequest): DescribeBandwidthRateLimitScheduleResponse {
        val op = SdkHttpOperation.build<DescribeBandwidthRateLimitScheduleRequest, DescribeBandwidthRateLimitScheduleResponse> {
            serializer = DescribeBandwidthRateLimitScheduleOperationSerializer()
            deserializer = DescribeBandwidthRateLimitScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBandwidthRateLimitSchedule"
            }
        }
        registerDescribeBandwidthRateLimitScheduleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the cache of a gateway. This operation is only supported in
     * the cached volume, tape, and file gateway types.
     * The response includes disk IDs that are configured as cache, and it includes the amount
     * of cache allocated and used.
     */
    override suspend fun describeCache(input: DescribeCacheRequest): DescribeCacheResponse {
        val op = SdkHttpOperation.build<DescribeCacheRequest, DescribeCacheResponse> {
            serializer = DescribeCacheOperationSerializer()
            deserializer = DescribeCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCache"
            }
        }
        registerDescribeCacheMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the gateway volumes specified in the request. This operation is
     * only supported in the cached volume gateway types.
     * The list of gateway volumes in the request must be from one gateway. In the response,
     * Storage Gateway returns volume information sorted by volume Amazon Resource Name
     * (ARN).
     */
    override suspend fun describeCachediScsiVolumes(input: DescribeCachediScsiVolumesRequest): DescribeCachediScsiVolumesResponse {
        val op = SdkHttpOperation.build<DescribeCachediScsiVolumesRequest, DescribeCachediScsiVolumesResponse> {
            serializer = DescribeCachediSCSIVolumesOperationSerializer()
            deserializer = DescribeCachediSCSIVolumesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCachediSCSIVolumes"
            }
        }
        registerDescribeCachediScsiVolumesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials
     * information for a specified iSCSI target, one for each target-initiator pair. This
     * operation is supported in the volume and tape gateway types.
     */
    override suspend fun describeChapCredentials(input: DescribeChapCredentialsRequest): DescribeChapCredentialsResponse {
        val op = SdkHttpOperation.build<DescribeChapCredentialsRequest, DescribeChapCredentialsResponse> {
            serializer = DescribeChapCredentialsOperationSerializer()
            deserializer = DescribeChapCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChapCredentials"
            }
        }
        registerDescribeChapCredentialsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the file system association information. This operation is only supported for
     * FSx File Gateways.
     */
    override suspend fun describeFileSystemAssociations(input: DescribeFileSystemAssociationsRequest): DescribeFileSystemAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeFileSystemAssociationsRequest, DescribeFileSystemAssociationsResponse> {
            serializer = DescribeFileSystemAssociationsOperationSerializer()
            deserializer = DescribeFileSystemAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFileSystemAssociations"
            }
        }
        registerDescribeFileSystemAssociationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about a gateway such as its name, network interfaces, configured time
     * zone, and the state (whether the gateway is running or not). To specify which gateway to
     * describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     */
    override suspend fun describeGatewayInformation(input: DescribeGatewayInformationRequest): DescribeGatewayInformationResponse {
        val op = SdkHttpOperation.build<DescribeGatewayInformationRequest, DescribeGatewayInformationResponse> {
            serializer = DescribeGatewayInformationOperationSerializer()
            deserializer = DescribeGatewayInformationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGatewayInformation"
            }
        }
        registerDescribeGatewayInformationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns your gateway's weekly maintenance start time including the day and time of
     * the week. Note that values are in terms of the gateway's time zone.
     */
    override suspend fun describeMaintenanceStartTime(input: DescribeMaintenanceStartTimeRequest): DescribeMaintenanceStartTimeResponse {
        val op = SdkHttpOperation.build<DescribeMaintenanceStartTimeRequest, DescribeMaintenanceStartTimeResponse> {
            serializer = DescribeMaintenanceStartTimeOperationSerializer()
            deserializer = DescribeMaintenanceStartTimeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMaintenanceStartTime"
            }
        }
        registerDescribeMaintenanceStartTimeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a description for one or more Network File System (NFS) file shares from an S3 File
     * Gateway. This operation is only supported for S3 File Gateways.
     */
    override suspend fun describeNfsFileShares(input: DescribeNfsFileSharesRequest): DescribeNfsFileSharesResponse {
        val op = SdkHttpOperation.build<DescribeNfsFileSharesRequest, DescribeNfsFileSharesResponse> {
            serializer = DescribeNFSFileSharesOperationSerializer()
            deserializer = DescribeNFSFileSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNFSFileShares"
            }
        }
        registerDescribeNfsFileSharesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a description for one or more Server Message Block (SMB) file shares from a S3 File
     * Gateway. This operation is only supported for S3 File Gateways.
     */
    override suspend fun describeSmbFileShares(input: DescribeSmbFileSharesRequest): DescribeSmbFileSharesResponse {
        val op = SdkHttpOperation.build<DescribeSmbFileSharesRequest, DescribeSmbFileSharesResponse> {
            serializer = DescribeSMBFileSharesOperationSerializer()
            deserializer = DescribeSMBFileSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSMBFileShares"
            }
        }
        registerDescribeSmbFileSharesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a description of a Server Message Block (SMB) file share settings from a file
     * gateway. This operation is only supported for file gateways.
     */
    override suspend fun describeSmbSettings(input: DescribeSmbSettingsRequest): DescribeSmbSettingsResponse {
        val op = SdkHttpOperation.build<DescribeSmbSettingsRequest, DescribeSmbSettingsResponse> {
            serializer = DescribeSMBSettingsOperationSerializer()
            deserializer = DescribeSMBSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSMBSettings"
            }
        }
        registerDescribeSmbSettingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the snapshot schedule for the specified gateway volume. The snapshot schedule
     * information includes intervals at which snapshots are automatically initiated on the
     * volume. This operation is only supported in the cached volume and stored volume
     * types.
     */
    override suspend fun describeSnapshotSchedule(input: DescribeSnapshotScheduleRequest): DescribeSnapshotScheduleResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotScheduleRequest, DescribeSnapshotScheduleResponse> {
            serializer = DescribeSnapshotScheduleOperationSerializer()
            deserializer = DescribeSnapshotScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshotSchedule"
            }
        }
        registerDescribeSnapshotScheduleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of the gateway volumes specified in the request. The list of
     * gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported
     * in stored volume gateway type.
     */
    override suspend fun describeStorediScsiVolumes(input: DescribeStorediScsiVolumesRequest): DescribeStorediScsiVolumesResponse {
        val op = SdkHttpOperation.build<DescribeStorediScsiVolumesRequest, DescribeStorediScsiVolumesResponse> {
            serializer = DescribeStorediSCSIVolumesOperationSerializer()
            deserializer = DescribeStorediSCSIVolumesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStorediSCSIVolumes"
            }
        }
        registerDescribeStorediScsiVolumesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This
     * operation is only supported in the tape gateway type.
     * If a specific TapeARN is not specified, Storage Gateway returns a
     * description of all virtual tapes found in the VTS associated with your account.
     */
    override suspend fun describeTapeArchives(input: DescribeTapeArchivesRequest): DescribeTapeArchivesResponse {
        val op = SdkHttpOperation.build<DescribeTapeArchivesRequest, DescribeTapeArchivesResponse> {
            serializer = DescribeTapeArchivesOperationSerializer()
            deserializer = DescribeTapeArchivesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTapeArchives"
            }
        }
        registerDescribeTapeArchivesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of virtual tape recovery points that are available for the specified tape
     * gateway.
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the
     * virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery
     * points can be recovered to a new gateway. This operation is only supported in the tape
     * gateway type.
     */
    override suspend fun describeTapeRecoveryPoints(input: DescribeTapeRecoveryPointsRequest): DescribeTapeRecoveryPointsResponse {
        val op = SdkHttpOperation.build<DescribeTapeRecoveryPointsRequest, DescribeTapeRecoveryPointsResponse> {
            serializer = DescribeTapeRecoveryPointsOperationSerializer()
            deserializer = DescribeTapeRecoveryPointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTapeRecoveryPoints"
            }
        }
        registerDescribeTapeRecoveryPointsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a
     * TapeARN is not specified, returns a description of all virtual tapes
     * associated with the specified gateway. This operation is only supported in the tape gateway
     * type.
     */
    override suspend fun describeTapes(input: DescribeTapesRequest): DescribeTapesResponse {
        val op = SdkHttpOperation.build<DescribeTapesRequest, DescribeTapesResponse> {
            serializer = DescribeTapesOperationSerializer()
            deserializer = DescribeTapesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTapes"
            }
        }
        registerDescribeTapesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the upload buffer of a gateway. This operation is supported
     * for the stored volume, cached volume, and tape gateway types.
     * The response includes disk IDs that are configured as upload buffer space, and it
     * includes the amount of upload buffer space allocated and used.
     */
    override suspend fun describeUploadBuffer(input: DescribeUploadBufferRequest): DescribeUploadBufferResponse {
        val op = SdkHttpOperation.build<DescribeUploadBufferRequest, DescribeUploadBufferResponse> {
            serializer = DescribeUploadBufferOperationSerializer()
            deserializer = DescribeUploadBufferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUploadBuffer"
            }
        }
        registerDescribeUploadBufferMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of virtual tape library (VTL) devices for the specified tape
     * gateway. In the response, Storage Gateway returns VTL device information.
     * This operation is only supported in the tape gateway type.
     */
    override suspend fun describeVtlDevices(input: DescribeVtlDevicesRequest): DescribeVtlDevicesResponse {
        val op = SdkHttpOperation.build<DescribeVtlDevicesRequest, DescribeVtlDevicesResponse> {
            serializer = DescribeVTLDevicesOperationSerializer()
            deserializer = DescribeVTLDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVTLDevices"
            }
        }
        registerDescribeVtlDevicesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the working storage of a gateway. This operation is only
     * supported in the stored volumes gateway type. This operation is deprecated in cached
     * volumes API version (20120630). Use DescribeUploadBuffer instead.
     * Working storage is also referred to as upload buffer. You can also use the
     * DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.
     * The response includes disk IDs that are configured as working storage, and it includes
     * the amount of working storage allocated and used.
     */
    override suspend fun describeWorkingStorage(input: DescribeWorkingStorageRequest): DescribeWorkingStorageResponse {
        val op = SdkHttpOperation.build<DescribeWorkingStorageRequest, DescribeWorkingStorageResponse> {
            serializer = DescribeWorkingStorageOperationSerializer()
            deserializer = DescribeWorkingStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorkingStorage"
            }
        }
        registerDescribeWorkingStorageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disconnects a volume from an iSCSI connection and then detaches the volume from the
     * specified gateway. Detaching and attaching a volume enables you to recover your data from
     * one gateway to a different gateway without creating a snapshot. It also makes it easier to
     * move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2
     * instance. This operation is only supported in the volume gateway type.
     */
    override suspend fun detachVolume(input: DetachVolumeRequest): DetachVolumeResponse {
        val op = SdkHttpOperation.build<DetachVolumeRequest, DetachVolumeResponse> {
            serializer = DetachVolumeOperationSerializer()
            deserializer = DetachVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachVolume"
            }
        }
        registerDetachVolumeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disables a tape gateway when the gateway is no longer functioning. For example, if your
     * gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.
     * Use this operation for a tape gateway that is not reachable or not functioning. This
     * operation is only supported in the tape gateway type.
     * After a gateway is disabled, it cannot be enabled.
     */
    override suspend fun disableGateway(input: DisableGatewayRequest): DisableGatewayResponse {
        val op = SdkHttpOperation.build<DisableGatewayRequest, DisableGatewayResponse> {
            serializer = DisableGatewayOperationSerializer()
            deserializer = DisableGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableGateway"
            }
        }
        registerDisableGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an Amazon FSx file system from the specified gateway. After the
     * disassociation process finishes, the gateway can no longer access the Amazon FSx file
     * system. This operation is only supported in the FSx File Gateway type.
     */
    override suspend fun disassociateFileSystem(input: DisassociateFileSystemRequest): DisassociateFileSystemResponse {
        val op = SdkHttpOperation.build<DisassociateFileSystemRequest, DisassociateFileSystemResponse> {
            serializer = DisassociateFileSystemOperationSerializer()
            deserializer = DisassociateFileSystemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFileSystem"
            }
        }
        registerDisassociateFileSystemMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a file gateway to an Active Directory domain. This operation is only supported for
     * file gateways that support the SMB file protocol.
     */
    override suspend fun joinDomain(input: JoinDomainRequest): JoinDomainResponse {
        val op = SdkHttpOperation.build<JoinDomainRequest, JoinDomainResponse> {
            serializer = JoinDomainOperationSerializer()
            deserializer = JoinDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "JoinDomain"
            }
        }
        registerJoinDomainMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the automatic tape creation policies for a gateway. If there are no automatic tape
     * creation policies for the gateway, it returns an empty list.
     * This operation is only supported for tape gateways.
     */
    override suspend fun listAutomaticTapeCreationPolicies(input: ListAutomaticTapeCreationPoliciesRequest): ListAutomaticTapeCreationPoliciesResponse {
        val op = SdkHttpOperation.build<ListAutomaticTapeCreationPoliciesRequest, ListAutomaticTapeCreationPoliciesResponse> {
            serializer = ListAutomaticTapeCreationPoliciesOperationSerializer()
            deserializer = ListAutomaticTapeCreationPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAutomaticTapeCreationPolicies"
            }
        }
        registerListAutomaticTapeCreationPoliciesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares
     * that belong to the calling user account. This operation is only supported for S3 File Gateways.
     */
    override suspend fun listFileShares(input: ListFileSharesRequest): ListFileSharesResponse {
        val op = SdkHttpOperation.build<ListFileSharesRequest, ListFileSharesResponse> {
            serializer = ListFileSharesOperationSerializer()
            deserializer = ListFileSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFileShares"
            }
        }
        registerListFileSharesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of FileSystemAssociationSummary objects. Each object contains a
     * summary of a file system association. This operation is only supported for FSx File
     * Gateways.
     */
    override suspend fun listFileSystemAssociations(input: ListFileSystemAssociationsRequest): ListFileSystemAssociationsResponse {
        val op = SdkHttpOperation.build<ListFileSystemAssociationsRequest, ListFileSystemAssociationsResponse> {
            serializer = ListFileSystemAssociationsOperationSerializer()
            deserializer = ListFileSystemAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFileSystemAssociations"
            }
        }
        registerListFileSystemAssociationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists gateways owned by an account in an Region specified in the request. The
     * returned list is ordered by gateway Amazon Resource Name (ARN).
     * By default, the operation returns a maximum of 100 gateways. This operation supports
     * pagination that allows you to optionally reduce the number of gateways returned in a
     * response.
     * If you have more gateways than are returned in a response (that is, the response returns
     * only a truncated list of your gateways), the response contains a marker that you can
     * specify in your next request to fetch the next page of gateways.
     */
    override suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse {
        val op = SdkHttpOperation.build<ListGatewaysRequest, ListGatewaysResponse> {
            serializer = ListGatewaysOperationSerializer()
            deserializer = ListGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGateways"
            }
        }
        registerListGatewaysMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the gateway's local disks. To specify which gateway to describe,
     * you use the Amazon Resource Name (ARN) of the gateway in the body of the request.
     * The request returns a list of all disks, specifying which are configured as working
     * storage, cache storage, or stored volume or not configured at all. The response includes a
     * DiskStatus field. This field can have a value of present (the disk is
     * available to use), missing (the disk is no longer connected to the gateway), or mismatch
     * (the disk node is occupied by a disk that has incorrect metadata or the disk content is
     * corrupted).
     */
    override suspend fun listLocalDisks(input: ListLocalDisksRequest): ListLocalDisksResponse {
        val op = SdkHttpOperation.build<ListLocalDisksRequest, ListLocalDisksResponse> {
            serializer = ListLocalDisksOperationSerializer()
            deserializer = ListLocalDisksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLocalDisks"
            }
        }
        registerListLocalDisksMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags that have been added to the specified resource. This operation is
     * supported in storage gateways of all types.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more
     * custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN,
     * the operation lists all custom tape pools.
     * This operation supports pagination. You can optionally specify the Limit
     * parameter in the body to limit the number of tape pools in the response. If the number of
     * tape pools returned in the response is truncated, the response includes a
     * Marker element that you can use in your subsequent request to retrieve the
     * next set of tape pools.
     */
    override suspend fun listTapePools(input: ListTapePoolsRequest): ListTapePoolsResponse {
        val op = SdkHttpOperation.build<ListTapePoolsRequest, ListTapePoolsResponse> {
            serializer = ListTapePoolsOperationSerializer()
            deserializer = ListTapePoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTapePools"
            }
        }
        registerListTapePoolsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf
     * (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names
     * (ARNs). If you don't specify a tape ARN, the operation lists all virtual tapes in both
     * your VTL and VTS.
     * This operation supports pagination. By default, the operation returns a maximum of up to
     * 100 tapes. You can optionally specify the Limit parameter in the body to limit
     * the number of tapes in the response. If the number of tapes returned in the response is
     * truncated, the response includes a Marker element that you can use in your
     * subsequent request to retrieve the next set of tapes. This operation is only supported in
     * the tape gateway type.
     */
    override suspend fun listTapes(input: ListTapesRequest): ListTapesResponse {
        val op = SdkHttpOperation.build<ListTapesRequest, ListTapesResponse> {
            serializer = ListTapesOperationSerializer()
            deserializer = ListTapesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTapes"
            }
        }
        registerListTapesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists iSCSI initiators that are connected to a volume. You can use this operation to
     * determine whether a volume is being used or not. This operation is only supported in the
     * cached volume and stored volume gateway types.
     */
    override suspend fun listVolumeInitiators(input: ListVolumeInitiatorsRequest): ListVolumeInitiatorsResponse {
        val op = SdkHttpOperation.build<ListVolumeInitiatorsRequest, ListVolumeInitiatorsResponse> {
            serializer = ListVolumeInitiatorsOperationSerializer()
            deserializer = ListVolumeInitiatorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVolumeInitiators"
            }
        }
        registerListVolumeInitiatorsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the recovery points for a specified gateway. This operation is only supported in
     * the cached volume gateway type.
     * Each cache volume has one recovery point. A volume recovery point is a point in time at
     * which all data of the volume is consistent and from which you can create a snapshot or
     * clone a new cached volume from a source volume. To create a snapshot from a volume recovery
     * point use the CreateSnapshotFromVolumeRecoveryPoint operation.
     */
    override suspend fun listVolumeRecoveryPoints(input: ListVolumeRecoveryPointsRequest): ListVolumeRecoveryPointsResponse {
        val op = SdkHttpOperation.build<ListVolumeRecoveryPointsRequest, ListVolumeRecoveryPointsResponse> {
            serializer = ListVolumeRecoveryPointsOperationSerializer()
            deserializer = ListVolumeRecoveryPointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVolumeRecoveryPoints"
            }
        }
        registerListVolumeRecoveryPointsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The
     * response includes only the volume ARNs. If you want additional volume information, use the
     * DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes API.
     * The operation supports pagination. By default, the operation returns a maximum of up to
     * 100 volumes. You can optionally specify the Limit field in the body to limit
     * the number of volumes in the response. If the number of volumes returned in the response is
     * truncated, the response includes a Marker field. You can use this Marker value in your
     * subsequent request to retrieve the next set of volumes. This operation is only supported in
     * the cached volume and stored volume gateway types.
     */
    override suspend fun listVolumes(input: ListVolumesRequest): ListVolumesResponse {
        val op = SdkHttpOperation.build<ListVolumesRequest, ListVolumesResponse> {
            serializer = ListVolumesOperationSerializer()
            deserializer = ListVolumesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVolumes"
            }
        }
        registerListVolumesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sends you notification through CloudWatch Events when all files written to your file
     * share have been uploaded to Amazon S3.
     * Storage Gateway can send a notification through Amazon CloudWatch Events when all
     * files written to your file share up to that point in time have been uploaded to Amazon S3.
     * These files include files written to the file share up to the time that you make a request
     * for notification. When the upload is done, Storage Gateway sends you notification through
     * an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification
     * through event targets such as Amazon SNS or Lambda function.
     * This operation is only supported for S3 File Gateways.
     * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification">Getting file upload notification in the Storage Gateway User
     * Guide.
     */
    override suspend fun notifyWhenUploaded(input: NotifyWhenUploadedRequest): NotifyWhenUploadedResponse {
        val op = SdkHttpOperation.build<NotifyWhenUploadedRequest, NotifyWhenUploadedResponse> {
            serializer = NotifyWhenUploadedOperationSerializer()
            deserializer = NotifyWhenUploadedOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "NotifyWhenUploaded"
            }
        }
        registerNotifyWhenUploadedMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Refreshes the cached inventory of objects for the specified file share. This operation
     * finds objects in the Amazon S3 bucket that were added, removed, or replaced since the
     * gateway last listed the bucket's contents and cached the results. This operation does
     * not import files into the S3 File Gateway cache storage. It only updates the cached inventory
     * to reflect changes in the inventory of the objects in the S3 bucket. This operation is only
     * supported in the S3 File Gateway types.
     * You can subscribe to be notified through an Amazon
     * CloudWatch event when your RefreshCache operation completes. For more
     * information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations in the Storage Gateway
     * User Guide. This operation is Only supported for S3 File Gateways.
     * When this API is called, it only initiates the refresh operation. When the API call
     * completes and returns a success code, it doesn't necessarily mean that the file
     * refresh has completed. You should use the refresh-complete notification to determine that
     * the operation has completed before you check for new files on the gateway file share. You
     * can subscribe to be notified through a CloudWatch event when your RefreshCache
     * operation completes.
     * Throttle limit: This API is asynchronous, so the gateway will accept no more than two
     * refreshes at any time. We recommend using the refresh-complete CloudWatch event
     * notification before issuing additional requests. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations in the Storage Gateway
     * User Guide.
     * If you invoke the RefreshCache API when two requests are already being processed, any
     * new request will cause an InvalidGatewayRequestException error because too
     * many requests were sent to the server.
     * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations in the Storage Gateway
     * User Guide.
     */
    override suspend fun refreshCache(input: RefreshCacheRequest): RefreshCacheResponse {
        val op = SdkHttpOperation.build<RefreshCacheRequest, RefreshCacheResponse> {
            serializer = RefreshCacheOperationSerializer()
            deserializer = RefreshCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RefreshCache"
            }
        }
        registerRefreshCacheMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified resource. This operation is supported in
     * storage gateways of all types.
     */
    override suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse {
        val op = SdkHttpOperation.build<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse> {
            serializer = RemoveTagsFromResourceOperationSerializer()
            deserializer = RemoveTagsFromResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTagsFromResource"
            }
        }
        registerRemoveTagsFromResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Resets all cache disks that have encountered an error and makes the disks available for
     * reconfiguration as cache storage. If your cache disk encounters an error, the gateway
     * prevents read and write operations on virtual tapes in the gateway. For example, an error
     * can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the
     * gateway loses its cache storage. At this point, you can reconfigure the disks as cache
     * disks. This operation is only supported in the cached volume and tape types.
     * If the cache disk you are resetting contains data that has not been uploaded to
     * Amazon S3 yet, that data can be lost. After you reset cache disks, there will be no
     * configured cache disks left in the gateway, so you must configure at least one new cache
     * disk for your gateway to function properly.
     */
    override suspend fun resetCache(input: ResetCacheRequest): ResetCacheResponse {
        val op = SdkHttpOperation.build<ResetCacheRequest, ResetCacheResponse> {
            serializer = ResetCacheOperationSerializer()
            deserializer = ResetCacheOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetCache"
            }
        }
        registerResetCacheMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway.
     * Virtual tapes archived in the VTS are not associated with any gateway. However after a tape
     * is retrieved, it is associated with a gateway, even though it is also listed in the VTS,
     * that is, archive. This operation is only supported in the tape gateway type.
     * Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to
     * another gateway. You must archive the tape again before you can retrieve it to another
     * gateway. This operation is only supported in the tape gateway type.
     */
    override suspend fun retrieveTapeArchive(input: RetrieveTapeArchiveRequest): RetrieveTapeArchiveResponse {
        val op = SdkHttpOperation.build<RetrieveTapeArchiveRequest, RetrieveTapeArchiveResponse> {
            serializer = RetrieveTapeArchiveOperationSerializer()
            deserializer = RetrieveTapeArchiveOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RetrieveTapeArchive"
            }
        }
        registerRetrieveTapeArchiveMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the recovery point for the specified virtual tape. This operation is only
     * supported in the tape gateway type.
     * A recovery point is a point in time view of a virtual tape at which all the data on the
     * tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be
     * recovered to a new gateway.
     * The virtual tape can be retrieved to only one gateway. The retrieved tape is
     * read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge
     * for retrieving recovery points.
     */
    override suspend fun retrieveTapeRecoveryPoint(input: RetrieveTapeRecoveryPointRequest): RetrieveTapeRecoveryPointResponse {
        val op = SdkHttpOperation.build<RetrieveTapeRecoveryPointRequest, RetrieveTapeRecoveryPointResponse> {
            serializer = RetrieveTapeRecoveryPointOperationSerializer()
            deserializer = RetrieveTapeRecoveryPointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RetrieveTapeRecoveryPoint"
            }
        }
        registerRetrieveTapeRecoveryPointMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the password for your VM local console. When you log in to the local console for
     * the first time, you log in to the VM with the default credentials. We recommend that you
     * set a new password. You don't need to know the default password to set a new
     * password.
     */
    override suspend fun setLocalConsolePassword(input: SetLocalConsolePasswordRequest): SetLocalConsolePasswordResponse {
        val op = SdkHttpOperation.build<SetLocalConsolePasswordRequest, SetLocalConsolePasswordResponse> {
            serializer = SetLocalConsolePasswordOperationSerializer()
            deserializer = SetLocalConsolePasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetLocalConsolePassword"
            }
        }
        registerSetLocalConsolePasswordMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the password for the guest user smbguest. The smbguest
     * user is the user when the authentication method for the file share is set to
     * GuestAccess. This operation only supported for S3 File Gateways
     */
    override suspend fun setSmbGuestPassword(input: SetSmbGuestPasswordRequest): SetSmbGuestPasswordResponse {
        val op = SdkHttpOperation.build<SetSmbGuestPasswordRequest, SetSmbGuestPasswordResponse> {
            serializer = SetSMBGuestPasswordOperationSerializer()
            deserializer = SetSMBGuestPasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetSMBGuestPassword"
            }
        }
        registerSetSmbGuestPasswordMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource
     * Name (ARN) of the gateway in the body of your request.
     * The operation shuts down the gateway service component running in the gateway's
     * virtual machine (VM) and not the host VM.
     * If you want to shut down the VM, it is recommended that you first shut down the
     * gateway component in the VM to avoid unpredictable conditions.
     * After the gateway is shutdown, you cannot call any other API except StartGateway, DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway.
     * Your applications cannot read from or write to the gateway's storage volumes, and
     * there are no snapshots taken.
     * When you make a shutdown request, you will get a 200 OK success response
     * immediately. However, it might take some time for the gateway to shut down. You can call
     * the DescribeGatewayInformation API to check the status. For more
     * information, see ActivateGateway.
     * If do not intend to use the gateway again, you must delete the gateway (using DeleteGateway) to no longer pay software charges associated with the
     * gateway.
     */
    override suspend fun shutdownGateway(input: ShutdownGatewayRequest): ShutdownGatewayResponse {
        val op = SdkHttpOperation.build<ShutdownGatewayRequest, ShutdownGatewayResponse> {
            serializer = ShutdownGatewayOperationSerializer()
            deserializer = ShutdownGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ShutdownGateway"
            }
        }
        registerShutdownGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Start a test that verifies that the specified gateway is configured for High
     * Availability monitoring in your host environment. This request only initiates the test and
     * that a successful response only indicates that the test was started. It doesn't
     * indicate that the test passed. For the status of the test, invoke the
     * DescribeAvailabilityMonitorTest API.
     * Starting this test will cause your gateway to go offline for a brief period.
     */
    override suspend fun startAvailabilityMonitorTest(input: StartAvailabilityMonitorTestRequest): StartAvailabilityMonitorTestResponse {
        val op = SdkHttpOperation.build<StartAvailabilityMonitorTestRequest, StartAvailabilityMonitorTestResponse> {
            serializer = StartAvailabilityMonitorTestOperationSerializer()
            deserializer = StartAvailabilityMonitorTestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartAvailabilityMonitorTest"
            }
        }
        registerStartAvailabilityMonitorTestMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a gateway that you previously shut down (see ShutdownGateway).
     * After the gateway starts, you can then make other API calls, your applications can read
     * from or write to the gateway's storage volumes and you will be able to take snapshot
     * backups.
     * When you make a request, you will get a 200 OK success response immediately. However,
     * it might take some time for the gateway to be ready. You should call DescribeGatewayInformation and check the status before making any
     * additional API calls. For more information, see ActivateGateway.
     * To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in
     * your request.
     */
    override suspend fun startGateway(input: StartGatewayRequest): StartGatewayResponse {
        val op = SdkHttpOperation.build<StartGatewayRequest, StartGatewayResponse> {
            serializer = StartGatewayOperationSerializer()
            deserializer = StartGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartGateway"
            }
        }
        registerStartGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the automatic tape creation policy of a gateway. Use this to update the policy
     * with a new set of automatic tape creation rules. This is only supported for tape
     * gateways.
     * By default, there is no automatic tape creation policy.
     * A gateway can have only one automatic tape creation policy.
     */
    override suspend fun updateAutomaticTapeCreationPolicy(input: UpdateAutomaticTapeCreationPolicyRequest): UpdateAutomaticTapeCreationPolicyResponse {
        val op = SdkHttpOperation.build<UpdateAutomaticTapeCreationPolicyRequest, UpdateAutomaticTapeCreationPolicyResponse> {
            serializer = UpdateAutomaticTapeCreationPolicyOperationSerializer()
            deserializer = UpdateAutomaticTapeCreationPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAutomaticTapeCreationPolicy"
            }
        }
        registerUpdateAutomaticTapeCreationPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the bandwidth rate limits of a gateway. You can update both the upload and
     * download bandwidth rate limit or specify only one of the two. If you don't set a
     * bandwidth rate limit, the existing rate limit remains. This operation is supported for the
     * stored volume, cached volume, and tape gateway types.
     * By default, a gateway's bandwidth rate limits are not set. If you don't set
     * any limit, the gateway does not have any limitations on its bandwidth usage and could
     * potentially use the maximum available bandwidth.
     * To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in
     * your request.
     */
    override suspend fun updateBandwidthRateLimit(input: UpdateBandwidthRateLimitRequest): UpdateBandwidthRateLimitResponse {
        val op = SdkHttpOperation.build<UpdateBandwidthRateLimitRequest, UpdateBandwidthRateLimitResponse> {
            serializer = UpdateBandwidthRateLimitOperationSerializer()
            deserializer = UpdateBandwidthRateLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBandwidthRateLimit"
            }
        }
        registerUpdateBandwidthRateLimitMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do
     * not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect.
     * Use this to initiate or update a gateway's bandwidth rate limit schedule.
     * This operation is supported in the volume and tape gateway types.
     */
    override suspend fun updateBandwidthRateLimitSchedule(input: UpdateBandwidthRateLimitScheduleRequest): UpdateBandwidthRateLimitScheduleResponse {
        val op = SdkHttpOperation.build<UpdateBandwidthRateLimitScheduleRequest, UpdateBandwidthRateLimitScheduleResponse> {
            serializer = UpdateBandwidthRateLimitScheduleOperationSerializer()
            deserializer = UpdateBandwidthRateLimitScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBandwidthRateLimitSchedule"
            }
        }
        registerUpdateBandwidthRateLimitScheduleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a
     * specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for
     * added security, you might use it. This operation is supported in the volume and tape
     * gateway types.
     * When you update CHAP credentials, all existing connections on the target are closed
     * and initiators must reconnect with the new credentials.
     */
    override suspend fun updateChapCredentials(input: UpdateChapCredentialsRequest): UpdateChapCredentialsResponse {
        val op = SdkHttpOperation.build<UpdateChapCredentialsRequest, UpdateChapCredentialsResponse> {
            serializer = UpdateChapCredentialsOperationSerializer()
            deserializer = UpdateChapCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChapCredentials"
            }
        }
        registerUpdateChapCredentialsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a file system association. This operation is only supported in the FSx File Gateways.
     */
    override suspend fun updateFileSystemAssociation(input: UpdateFileSystemAssociationRequest): UpdateFileSystemAssociationResponse {
        val op = SdkHttpOperation.build<UpdateFileSystemAssociationRequest, UpdateFileSystemAssociationResponse> {
            serializer = UpdateFileSystemAssociationOperationSerializer()
            deserializer = UpdateFileSystemAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFileSystemAssociation"
            }
        }
        registerUpdateFileSystemAssociationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a gateway's metadata, which includes the gateway's name and time zone.
     * To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in
     * your request.
     * For gateways activated after September 2, 2015, the gateway's ARN contains the
     * gateway ID rather than the gateway name. However, changing the name of the gateway has
     * no effect on the gateway's ARN.
     */
    override suspend fun updateGatewayInformation(input: UpdateGatewayInformationRequest): UpdateGatewayInformationResponse {
        val op = SdkHttpOperation.build<UpdateGatewayInformationRequest, UpdateGatewayInformationResponse> {
            serializer = UpdateGatewayInformationOperationSerializer()
            deserializer = UpdateGatewayInformationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGatewayInformation"
            }
        }
        registerUpdateGatewayInformationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the
     * software update.
     * When you make this request, you get a 200 OK success response
     * immediately. However, it might take some time for the update to complete. You can call
     * DescribeGatewayInformation to verify the gateway is in the
     * STATE_RUNNING state.
     * A software update forces a system restart of your gateway. You can minimize the
     * chance of any disruption to your applications by increasing your iSCSI Initiators'
     * timeouts. For more information about increasing iSCSI Initiator timeouts for Windows and
     * Linux, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings">Customizing your Windows iSCSI settings and <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings">Customizing your Linux iSCSI settings, respectively.
     */
    override suspend fun updateGatewaySoftwareNow(input: UpdateGatewaySoftwareNowRequest): UpdateGatewaySoftwareNowResponse {
        val op = SdkHttpOperation.build<UpdateGatewaySoftwareNowRequest, UpdateGatewaySoftwareNowResponse> {
            serializer = UpdateGatewaySoftwareNowOperationSerializer()
            deserializer = UpdateGatewaySoftwareNowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGatewaySoftwareNow"
            }
        }
        registerUpdateGatewaySoftwareNowMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a gateway's weekly maintenance start time information, including day and
     * time of the week. The maintenance time is the time in your gateway's time zone.
     */
    override suspend fun updateMaintenanceStartTime(input: UpdateMaintenanceStartTimeRequest): UpdateMaintenanceStartTimeResponse {
        val op = SdkHttpOperation.build<UpdateMaintenanceStartTimeRequest, UpdateMaintenanceStartTimeResponse> {
            serializer = UpdateMaintenanceStartTimeOperationSerializer()
            deserializer = UpdateMaintenanceStartTimeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMaintenanceStartTime"
            }
        }
        registerUpdateMaintenanceStartTimeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.
     * To leave a file share field unchanged, set the corresponding input field to
     * null.
     * Updates the following file share settings:
     * Default storage class for your S3 bucket
     * Metadata defaults for your S3 bucket
     * Allowed NFS clients for your file share
     * Squash settings
     * Write status of your file share
     */
    override suspend fun updateNfsFileShare(input: UpdateNfsFileShareRequest): UpdateNfsFileShareResponse {
        val op = SdkHttpOperation.build<UpdateNfsFileShareRequest, UpdateNfsFileShareResponse> {
            serializer = UpdateNFSFileShareOperationSerializer()
            deserializer = UpdateNFSFileShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNFSFileShare"
            }
        }
        registerUpdateNfsFileShareMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Server Message Block (SMB) file share. This operation is only supported for
     * S3 File Gateways.
     * To leave a file share field unchanged, set the corresponding input field to
     * null.
     * File gateways require Security Token Service (STS) to be activated to enable
     * you to create a file share. Make sure that STS is activated in the Region you
     * are creating your file gateway in. If STS is not activated in this Region,
     * activate it. For information about how to activate STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating STS in an Region in the Identity and Access Management
     * User Guide.
     * File gateways don't support creating hard or symbolic links on a file
     * share.
     */
    override suspend fun updateSmbFileShare(input: UpdateSmbFileShareRequest): UpdateSmbFileShareResponse {
        val op = SdkHttpOperation.build<UpdateSmbFileShareRequest, UpdateSmbFileShareResponse> {
            serializer = UpdateSMBFileShareOperationSerializer()
            deserializer = UpdateSMBFileShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSMBFileShare"
            }
        }
        registerUpdateSmbFileShareMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Controls whether the shares on an S3 File Gateway are visible in a net view or browse
     * list. The operation is only supported for S3 File Gateways.
     */
    override suspend fun updateSmbFileShareVisibility(input: UpdateSmbFileShareVisibilityRequest): UpdateSmbFileShareVisibilityResponse {
        val op = SdkHttpOperation.build<UpdateSmbFileShareVisibilityRequest, UpdateSmbFileShareVisibilityResponse> {
            serializer = UpdateSMBFileShareVisibilityOperationSerializer()
            deserializer = UpdateSMBFileShareVisibilityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSMBFileShareVisibility"
            }
        }
        registerUpdateSmbFileShareVisibilityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the SMB security strategy on a file gateway. This action is only supported in
     * file gateways.
     * This API is called Security level in the User Guide.
     * A higher security level can affect performance of the gateway.
     */
    override suspend fun updateSmbSecurityStrategy(input: UpdateSmbSecurityStrategyRequest): UpdateSmbSecurityStrategyResponse {
        val op = SdkHttpOperation.build<UpdateSmbSecurityStrategyRequest, UpdateSmbSecurityStrategyResponse> {
            serializer = UpdateSMBSecurityStrategyOperationSerializer()
            deserializer = UpdateSMBSecurityStrategyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSMBSecurityStrategy"
            }
        }
        registerUpdateSmbSecurityStrategyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a snapshot schedule configured for a gateway volume. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * The default snapshot schedule for volume is once every 24 hours, starting at the
     * creation time of the volume. You can use this API to change the snapshot schedule
     * configured for the volume.
     * In the request you must identify the gateway volume whose snapshot schedule you want to
     * update, and the schedule information, including when you want the snapshot to begin on a
     * day and the frequency (in hours) of snapshots.
     */
    override suspend fun updateSnapshotSchedule(input: UpdateSnapshotScheduleRequest): UpdateSnapshotScheduleResponse {
        val op = SdkHttpOperation.build<UpdateSnapshotScheduleRequest, UpdateSnapshotScheduleResponse> {
            serializer = UpdateSnapshotScheduleOperationSerializer()
            deserializer = UpdateSnapshotScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSnapshotSchedule"
            }
        }
        registerUpdateSnapshotScheduleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the type of medium changer in a tape gateway. When you activate a tape gateway,
     * you select a medium changer type for the tape gateway. This operation enables you to select
     * a different type of medium changer after a tape gateway is activated. This operation is
     * only supported in the tape gateway type.
     */
    override suspend fun updateVtlDeviceType(input: UpdateVtlDeviceTypeRequest): UpdateVtlDeviceTypeResponse {
        val op = SdkHttpOperation.build<UpdateVtlDeviceTypeRequest, UpdateVtlDeviceTypeResponse> {
            serializer = UpdateVTLDeviceTypeOperationSerializer()
            deserializer = UpdateVTLDeviceTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVTLDeviceType"
            }
        }
        registerUpdateVtlDeviceTypeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
