// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.transform

import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.sdk.kotlin.services.storagegateway.model.TapeRecoveryPointInfo
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeTapeRecoveryPointsOperationDeserializer: HttpDeserialize<DescribeTapeRecoveryPointsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeTapeRecoveryPointsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeTapeRecoveryPointsError(context, response)
        }
        val builder = DescribeTapeRecoveryPointsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTapeRecoveryPointsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeTapeRecoveryPointsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTapeRecoveryPointsOperationBody(builder: DescribeTapeRecoveryPointsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayARN"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val TAPERECOVERYPOINTINFOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TapeRecoveryPointInfos"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GATEWAYARN_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(TAPERECOVERYPOINTINFOS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                TAPERECOVERYPOINTINFOS_DESCRIPTOR.index -> builder.tapeRecoveryPointInfos =
                    deserializer.deserializeList(TAPERECOVERYPOINTINFOS_DESCRIPTOR) {
                        val col0 = mutableListOf<TapeRecoveryPointInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTapeRecoveryPointInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
