// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes the object returned by `DescribeFileSystemAssociations` that describes a created file system association.
 */
public class FileSystemAssociationInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    public val auditDestinationArn: kotlin.String? = builder.auditDestinationArn
    /**
     * The refresh cache information for the file share or FSx file systems.
     */
    public val cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = builder.cacheAttributes
    /**
     * Specifies network configuration information for the gateway associated with the Amazon FSx file system.
     *
     * If multiple file systems are associated with this gateway, this parameter's `IpAddresses` field is required.
     */
    public val endpointNetworkConfiguration: aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration? = builder.endpointNetworkConfiguration
    /**
     * The Amazon Resource Name (ARN) of the file system association.
     */
    public val fileSystemAssociationArn: kotlin.String? = builder.fileSystemAssociationArn
    /**
     * The status of the file system association. Valid Values: `AVAILABLE` | `CREATING` | `DELETING` | `FORCE_DELETING` | `UPDATING` | `ERROR`
     */
    public val fileSystemAssociationStatus: kotlin.String? = builder.fileSystemAssociationStatus
    /**
     * An array containing the FileSystemAssociationStatusDetail data type, which provides detailed information on file system association status.
     */
    public val fileSystemAssociationStatusDetails: List<FileSystemAssociationStatusDetail>? = builder.fileSystemAssociationStatusDetails
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The ARN of the backend Amazon FSx file system used for storing file data. For information, see [FileSystem](https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html) in the *Amazon FSx API Reference*.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.FileSystemAssociationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemAssociationInfo(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("endpointNetworkConfiguration=$endpointNetworkConfiguration,")
        append("fileSystemAssociationArn=$fileSystemAssociationArn,")
        append("fileSystemAssociationStatus=$fileSystemAssociationStatus,")
        append("fileSystemAssociationStatusDetails=$fileSystemAssociationStatusDetails,")
        append("gatewayArn=$gatewayArn,")
        append("locationArn=$locationArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (endpointNetworkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAssociationStatus?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAssociationStatusDetails?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSystemAssociationInfo

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (endpointNetworkConfiguration != other.endpointNetworkConfiguration) return false
        if (fileSystemAssociationArn != other.fileSystemAssociationArn) return false
        if (fileSystemAssociationStatus != other.fileSystemAssociationStatus) return false
        if (fileSystemAssociationStatusDetails != other.fileSystemAssociationStatusDetails) return false
        if (gatewayArn != other.gatewayArn) return false
        if (locationArn != other.locationArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.FileSystemAssociationInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        public var auditDestinationArn: kotlin.String? = null
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        public var cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = null
        /**
         * Specifies network configuration information for the gateway associated with the Amazon FSx file system.
         *
         * If multiple file systems are associated with this gateway, this parameter's `IpAddresses` field is required.
         */
        public var endpointNetworkConfiguration: aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the file system association.
         */
        public var fileSystemAssociationArn: kotlin.String? = null
        /**
         * The status of the file system association. Valid Values: `AVAILABLE` | `CREATING` | `DELETING` | `FORCE_DELETING` | `UPDATING` | `ERROR`
         */
        public var fileSystemAssociationStatus: kotlin.String? = null
        /**
         * An array containing the FileSystemAssociationStatusDetail data type, which provides detailed information on file system association status.
         */
        public var fileSystemAssociationStatusDetails: List<FileSystemAssociationStatusDetail>? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The ARN of the backend Amazon FSx file system used for storing file data. For information, see [FileSystem](https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html) in the *Amazon FSx API Reference*.
         */
        public var locationArn: kotlin.String? = null
        /**
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a key-value pair.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.FileSystemAssociationInfo) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.endpointNetworkConfiguration = x.endpointNetworkConfiguration
            this.fileSystemAssociationArn = x.fileSystemAssociationArn
            this.fileSystemAssociationStatus = x.fileSystemAssociationStatus
            this.fileSystemAssociationStatusDetails = x.fileSystemAssociationStatusDetails
            this.gatewayArn = x.gatewayArn
            this.locationArn = x.locationArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.FileSystemAssociationInfo = FileSystemAssociationInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        public fun cacheAttributes(block: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.Builder.() -> kotlin.Unit) {
            this.cacheAttributes = aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration] inside the given [block]
         */
        public fun endpointNetworkConfiguration(block: aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointNetworkConfiguration = aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration.invoke(block)
        }
    }
}
