// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.transform

import aws.sdk.kotlin.services.storagegateway.model.FileShareInfo
import aws.sdk.kotlin.services.storagegateway.model.ListFileSharesResponse
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListFileSharesOperationDeserializer: HttpDeserialize<ListFileSharesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListFileSharesResponse {
        if (!response.status.isSuccess()) {
            throwListFileSharesError(context, response)
        }
        val builder = ListFileSharesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListFileSharesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListFileSharesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListFileSharesOperationBody(builder: ListFileSharesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FILESHAREINFOLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FileShareInfoList"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextMarker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILESHAREINFOLIST_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(NEXTMARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FILESHAREINFOLIST_DESCRIPTOR.index -> builder.fileShareInfoList =
                    deserializer.deserializeList(FILESHAREINFOLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<FileShareInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileShareInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
